/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.xml;

import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.structureView.impl.xml.XmlStructureViewTreeModel;
import com.intellij.ide.structureView.xml.XmlStructureViewBuilderProvider;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.lang.PsiStructureViewFactory;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlStructureViewBuilderFactory
implements PsiStructureViewFactory {
    @Nullable
    public StructureViewBuilder getStructureViewBuilder(final PsiFile psiFile) {
        if (psiFile instanceof XmlFile) {
            StructureViewBuilder builder = XmlStructureViewBuilderFactory.getStructureViewBuilderForExtensions(psiFile);
            if (builder != null) {
                return builder;
            }
            for (XmlStructureViewBuilderProvider xmlStructureViewBuilderProvider : XmlStructureViewBuilderFactory.getStructureViewBuilderProviders()) {
                StructureViewBuilder structureViewBuilder = xmlStructureViewBuilderProvider.createStructureViewBuilder((XmlFile)psiFile);
                if (structureViewBuilder == null) continue;
                return structureViewBuilder;
            }
            return new TreeBasedStructureViewBuilder(){

                @NotNull
                public StructureViewModel createStructureViewModel() {
                    XmlStructureViewTreeModel xmlStructureViewTreeModel = new XmlStructureViewTreeModel((XmlFile)psiFile);
                    if (xmlStructureViewTreeModel == null) {
                        throw new IllegalStateException("@NotNull method com/intellij/lang/xml/XmlStructureViewBuilderFactory$1.createStructureViewModel must not return null");
                    }
                    return xmlStructureViewTreeModel;
                }
            };
        }
        return null;
    }

    private static XmlStructureViewBuilderProvider[] getStructureViewBuilderProviders() {
        return (XmlStructureViewBuilderProvider[])Extensions.getExtensions((String)"com.intellij.xmlStructureViewBuilderProvider");
    }

    private static StructureViewBuilder getStructureViewBuilderForExtensions(PsiFile psiFile) {
        for (Language language : XMLLanguage.INSTANCE.getLanguageExtensionsForFile(psiFile)) {
            StructureViewBuilder builder = ((PsiStructureViewFactory)LanguageStructureViewBuilder.INSTANCE.forLanguage(language)).getStructureViewBuilder(psiFile);
            if (builder == null) continue;
            return builder;
        }
        return null;
    }
}

