/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.PerFileMappings;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.FileContentUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

public abstract class LanguagePerFileMappings<T>
implements PersistentStateComponent<Element>,
PerFileMappings<T> {
    private final Map<VirtualFile, T> myMappings = new HashMap<VirtualFile, T>();
    private final Project myProject;

    public LanguagePerFileMappings(Project project) {
        this.myProject = project;
    }

    @Nullable
    protected FilePropertyPusher<T> getFilePropertyPusher() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<VirtualFile, T> getMappings() {
        Map<VirtualFile, T> map = this.myMappings;
        synchronized (map) {
            this.cleanup();
            return Collections.unmodifiableMap(this.myMappings);
        }
    }

    private void cleanup() {
        for (VirtualFile file : new ArrayList<VirtualFile>(this.myMappings.keySet())) {
            if (file == null || file.isValid()) continue;
            this.myMappings.remove(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public T getMapping(@Nullable VirtualFile file) {
        if (file != null) {
            Object pushedValue;
            FilePropertyPusher<T> pusher = this.getFilePropertyPusher();
            Object object = pushedValue = pusher == null ? null : file.getUserData(pusher.getFileDataKey());
            if (pushedValue != null) {
                return (T)pushedValue;
            }
        }
        Map<VirtualFile, T> map = this.myMappings;
        synchronized (map) {
            VirtualFile cur = file;
            while (true) {
                T dialect;
                if ((dialect = this.myMappings.get(cur)) != null) {
                    return dialect;
                }
                if (cur == null) break;
                cur = cur.getParent();
            }
        }
        return this.getDefaultMapping(file);
    }

    @Nullable
    protected T getDefaultMapping(@Nullable VirtualFile file) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T getImmediateMapping(VirtualFile file) {
        Map<VirtualFile, T> map = this.myMappings;
        synchronized (map) {
            return this.myMappings.get(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMappings(Map<VirtualFile, T> mappings) {
        ArrayList<VirtualFile> oldFiles;
        Map<VirtualFile, T> map = this.myMappings;
        synchronized (map) {
            oldFiles = new ArrayList<VirtualFile>(this.myMappings.keySet());
            this.myMappings.clear();
            this.myMappings.putAll(mappings);
            this.cleanup();
        }
        this.handleMappingChange(mappings.keySet(), oldFiles, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMapping(VirtualFile file, T dialect) {
        Map<VirtualFile, T> map = this.myMappings;
        synchronized (map) {
            if (dialect == null) {
                this.myMappings.remove(file);
            } else {
                this.myMappings.put(file, dialect);
            }
        }
        List files = ContainerUtil.createMaybeSingletonList((Object)file);
        this.handleMappingChange(files, files, false);
    }

    private void handleMappingChange(Collection<VirtualFile> files, Collection<VirtualFile> oldFiles, boolean includeOpenFiles) {
        FilePropertyPusher<T> pusher = this.getFilePropertyPusher();
        if (pusher != null) {
            for (VirtualFile oldFile : oldFiles) {
                if (oldFile == null) continue;
                oldFile.putUserData(pusher.getFileDataKey(), null);
            }
            PushedFilePropertiesUpdater.getInstance(this.myProject).pushAll(pusher);
        }
        FileContentUtil.reparseFiles((Project)this.myProject, files, (boolean)includeOpenFiles);
    }

    @Override
    public Collection<T> getAvailableValues(VirtualFile file) {
        return this.getAvailableValues();
    }

    protected abstract List<T> getAvailableValues();

    protected abstract String serialize(T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getState() {
        Map<VirtualFile, T> map = this.myMappings;
        synchronized (map) {
            this.cleanup();
            Element element = new Element("x");
            ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(this.myMappings.keySet());
            Collections.sort(files, new Comparator<VirtualFile>(){

                @Override
                public int compare(VirtualFile o1, VirtualFile o2) {
                    if (o1 == null || o2 == null) {
                        return o1 == null ? (o2 == null ? 0 : 1) : -1;
                    }
                    return o1.getPath().compareTo(o2.getPath());
                }
            });
            for (VirtualFile file : files) {
                T dialect = this.myMappings.get(file);
                Element child = new Element("file");
                element.addContent(child);
                child.setAttribute("url", file == null ? "PROJECT" : file.getUrl());
                child.setAttribute("dialect", this.serialize(dialect));
            }
            return element;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(Element state) {
        Map<VirtualFile, T> map = this.myMappings;
        synchronized (map) {
            THashMap dialectMap = new THashMap();
            for (T dialect : this.getAvailableValues()) {
                dialectMap.put((Object)this.serialize(dialect), dialect);
            }
            List files = state.getChildren("file");
            for (Element fileElement : files) {
                VirtualFile file;
                String url = fileElement.getAttributeValue("url");
                String dialectID = fileElement.getAttributeValue("dialect");
                Object dialect = dialectMap.get((Object)dialectID);
                if (dialect == null) continue;
                VirtualFile virtualFile = file = url.equals("PROJECT") ? null : VirtualFileManager.getInstance().findFileByUrl(url);
                if (file == null && !url.equals("PROJECT")) continue;
                this.myMappings.put(file, dialect);
            }
        }
    }
}

