/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.javaee.ExternalResourceListener;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.impl.PsiManagerEx;
import org.jetbrains.annotations.NotNull;

public class PsiExternalResourceNotifier
extends AbstractProjectComponent {
    private final PsiManagerEx myPsiManager;
    private final ExternalResourceManagerEx myExternalResourceManager;
    private final DaemonCodeAnalyzer myDaemonCodeAnalyzer;

    public PsiExternalResourceNotifier(PsiManagerEx psiManager, ExternalResourceManager externalResourceManager, DaemonCodeAnalyzer daemonCodeAnalyzer, Project project) {
        super(project);
        this.myPsiManager = psiManager;
        this.myExternalResourceManager = (ExternalResourceManagerEx)externalResourceManager;
        this.myDaemonCodeAnalyzer = daemonCodeAnalyzer;
        final MyExternalResourceListener myExternalResourceListener = new MyExternalResourceListener();
        this.myExternalResourceManager.addExternalResourceListener(myExternalResourceListener);
        Disposer.register((Disposable)project, (Disposable)new Disposable(){

            public void dispose() {
                PsiExternalResourceNotifier.this.myExternalResourceManager.removeExternalResourceListener(myExternalResourceListener);
            }
        });
    }

    @NotNull
    public String getComponentName() {
        if ("PsiExternalResourceNotifier" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/javaee/PsiExternalResourceNotifier.getComponentName must not return null");
        }
        return "PsiExternalResourceNotifier";
    }

    private class MyExternalResourceListener
    implements ExternalResourceListener {
        private MyExternalResourceListener() {
        }

        @Override
        public void externalResourceChanged() {
            PsiExternalResourceNotifier.this.myPsiManager.physicalChange();
            PsiExternalResourceNotifier.this.myDaemonCodeAnalyzer.restart();
        }
    }
}

