/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.psiView;

import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.internal.psiView.ViewerNodeDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ViewerTreeStructure
extends AbstractTreeStructure {
    private boolean myShowWhiteSpaces = true;
    private boolean myShowTreeNodes = true;
    private final Project myProject;
    private PsiElement myRootPsiElement = null;
    private final Object myRootElement = new Object();

    public ViewerTreeStructure(Project project) {
        this.myProject = project;
    }

    public void setRootPsiElement(PsiElement rootPsiElement) {
        this.myRootPsiElement = rootPsiElement;
    }

    public PsiElement getRootPsiElement() {
        return this.myRootPsiElement;
    }

    public Object getRootElement() {
        return this.myRootElement;
    }

    public Object[] getChildElements(final Object element) {
        if (this.myRootElement == element) {
            Object[] objectArray;
            if (this.myRootPsiElement == null) {
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }
            if (this.myRootPsiElement instanceof PsiFile) {
                objectArray = ((PsiFile)this.myRootPsiElement).getPsiRoots();
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.myRootPsiElement;
            }
            return objectArray;
        }
        final Object[][] children = new Object[][]{ArrayUtil.EMPTY_OBJECT_ARRAY};
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                Object[] result;
                if (ViewerTreeStructure.this.myShowTreeNodes) {
                    ASTNode root;
                    ArrayList<ASTNode> list = new ArrayList<ASTNode>();
                    Object object = element instanceof PsiElement ? SourceTreeToPsiMap.psiElementToTree((PsiElement)element) : (root = element instanceof ASTNode ? (ASTNode)element : null);
                    if (root != null) {
                        for (ASTNode child = root.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                            if (!ViewerTreeStructure.this.myShowWhiteSpaces && child.getElementType() == TokenType.WHITE_SPACE) continue;
                            PsiElement childElement = child.getPsi();
                            list.add((ASTNode)(childElement == null ? child : childElement));
                        }
                    }
                    result = ArrayUtil.toObjectArray(list);
                } else {
                    PsiElement[] elementChildren = ((PsiElement)element).getChildren();
                    if (!ViewerTreeStructure.this.myShowWhiteSpaces) {
                        ArrayList<PsiElement> childrenList = new ArrayList<PsiElement>(elementChildren.length);
                        for (PsiElement psiElement : elementChildren) {
                            if (!ViewerTreeStructure.this.myShowWhiteSpaces && psiElement instanceof PsiWhiteSpace) continue;
                            childrenList.add(psiElement);
                        }
                        result = childrenList.toArray(new PsiElement[childrenList.size()]);
                    } else {
                        result = elementChildren;
                    }
                }
                children[0] = result;
            }
        });
        return children[0];
    }

    public Object getParentElement(Object element) {
        if (element == this.myRootElement) {
            return null;
        }
        if (element == this.myRootPsiElement) {
            return this.myRootElement;
        }
        return ((PsiElement)element).getParent();
    }

    public void commit() {
    }

    public boolean hasSomethingToCommit() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public NodeDescriptor createDescriptor(Object element, NodeDescriptor parentDescriptor) {
        NodeDescriptor nodeDescriptor;
        if (element == this.myRootElement) {
            nodeDescriptor = new NodeDescriptor(this.myProject, null){

                public boolean update() {
                    return false;
                }

                public Object getElement() {
                    return ViewerTreeStructure.this.myRootElement;
                }
            };
            if (nodeDescriptor == null) throw new IllegalStateException("@NotNull method com/intellij/internal/psiView/ViewerTreeStructure.createDescriptor must not return null");
            return nodeDescriptor;
        }
        nodeDescriptor = new ViewerNodeDescriptor(this.myProject, element, parentDescriptor);
        if (nodeDescriptor != null) return nodeDescriptor;
        throw new IllegalStateException("@NotNull method com/intellij/internal/psiView/ViewerTreeStructure.createDescriptor must not return null");
    }

    public boolean isShowWhiteSpaces() {
        return this.myShowWhiteSpaces;
    }

    public void setShowWhiteSpaces(boolean showWhiteSpaces) {
        this.myShowWhiteSpaces = showWhiteSpaces;
    }

    public boolean isShowTreeNodes() {
        return this.myShowTreeNodes;
    }

    public void setShowTreeNodes(boolean showTreeNodes) {
        this.myShowTreeNodes = showTreeNodes;
    }
}

