/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.focus;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusEvent;

public class FocusDebuggerAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.internal.focus.FocusDebuggerAction");
    private FocusDrawer myFocusDrawer;

    public void actionPerformed(AnActionEvent e) {
        if (this.myFocusDrawer == null) {
            this.myFocusDrawer = new FocusDrawer();
            this.myFocusDrawer.start();
            Toolkit.getDefaultToolkit().addAWTEventListener(this.myFocusDrawer, 4L);
        } else {
            this.myFocusDrawer.setRunning(false);
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.myFocusDrawer);
            this.myFocusDrawer = null;
        }
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        if (this.myFocusDrawer == null) {
            presentation.setText("Start Focus Debugger");
        } else {
            presentation.setText("Stop Focus Debugger");
        }
    }

    private static class FocusDrawer
    extends Thread
    implements AWTEventListener {
        private Component myCurrent;
        private Component myPrevious;
        private boolean myTemporary;
        private boolean myRunning = true;

        private FocusDrawer() {
        }

        public void setRunning(boolean running) {
            this.myRunning = running;
        }

        public boolean isRunning() {
            return this.myRunning;
        }

        @Override
        public void run() {
            try {
                while (this.myRunning) {
                    this.paintFocusBorders(false);
                    Thread.sleep(100L);
                }
                this.paintFocusBorders(true);
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
            }
        }

        private void paintFocusBorders(boolean clean) {
            Graphics previousFocusGraphics;
            Graphics currentFocusGraphics;
            if (this.myCurrent != null && (currentFocusGraphics = this.myCurrent.getGraphics()) != null) {
                if (clean) {
                    if (this.myCurrent.isDisplayable()) {
                        this.myCurrent.repaint();
                    }
                } else {
                    currentFocusGraphics.setColor(this.myTemporary ? Color.ORANGE : Color.GREEN);
                    UIUtil.drawDottedRectangle((Graphics)currentFocusGraphics, (int)1, (int)1, (int)(this.myCurrent.getSize().width - 2), (int)(this.myCurrent.getSize().height - 2));
                }
            }
            if (this.myPrevious != null && (previousFocusGraphics = this.myPrevious.getGraphics()) != null) {
                if (clean) {
                    if (this.myPrevious.isDisplayable()) {
                        this.myPrevious.repaint();
                    }
                } else {
                    previousFocusGraphics.setColor(Color.RED);
                    UIUtil.drawDottedRectangle((Graphics)previousFocusGraphics, (int)1, (int)1, (int)(this.myPrevious.getSize().width - 2), (int)(this.myPrevious.getSize().height - 2));
                }
            }
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            if (event instanceof FocusEvent) {
                FocusEvent focusEvent = (FocusEvent)event;
                Component fromComponent = focusEvent.getComponent();
                Component oppositeComponent = focusEvent.getOppositeComponent();
                this.paintFocusBorders(true);
                switch (event.getID()) {
                    case 1004: {
                        this.myCurrent = fromComponent;
                        this.myPrevious = oppositeComponent;
                        this.myTemporary = focusEvent.isTemporary();
                        break;
                    }
                    case 1005: {
                        this.myTemporary = focusEvent.isTemporary();
                    }
                }
            }
        }
    }
}

