/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.encodings;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class EncodingViewer
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.internal.encodings.EncodingViewer");
    private JPanel myPanel;
    private JTextField myText;
    private JComboBox myEncoding;
    private JButton myLoadFile;
    private byte[] myBytes;

    public EncodingViewer() {
        super(false);
        this.$$$setupUI$$$();
        this.initEncodings();
        this.myLoadFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
                VirtualFile[] files = FileChooser.chooseFiles((Component)EncodingViewer.this.myPanel, (FileChooserDescriptor)descriptor);
                if (files.length != 0) {
                    EncodingViewer.this.loadFrom(files[0]);
                }
            }
        });
        this.init();
    }

    protected String getDimensionServiceKey() {
        return "EncodingViewer";
    }

    private void loadFrom(VirtualFile virtualFile) {
        try {
            this.myBytes = LocalFileSystem.getInstance().physicalContentsToByteArray(virtualFile);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return;
        }
        this.refreshText();
    }

    private void refreshText() {
        String selectedCharset = this.getSelectedCharset();
        if (this.myBytes == null || selectedCharset == null) {
            return;
        }
        try {
            this.myText.setText(new String(this.myBytes, selectedCharset));
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Throwable)e);
        }
    }

    private String getSelectedCharset() {
        return ((Charset)this.myEncoding.getSelectedItem()).name();
    }

    private void initEncodings() {
        Charset[] availableCharsets = CharsetToolkit.getAvailableCharsets();
        this.myEncoding.setModel(new DefaultComboBoxModel<Charset>(availableCharsets));
        int defaultIndex = Arrays.asList(availableCharsets).indexOf(CharsetToolkit.getDefaultSystemCharset());
        this.myEncoding.setSelectedIndex(defaultIndex);
        this.myEncoding.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                EncodingViewer.this.refreshText();
            }
        });
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JComboBox jComboBox;
        JButton jButton;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myLoadFile = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/CommonBundle").getString("button.load.file"));
        jPanel2.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myEncoding = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myText = jTextField = new JTextField();
        jScrollPane.setViewportView(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

