/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indentation;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.tree.TokenSet;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IndentationFoldingBuilder
implements FoldingBuilder,
DumbAware {
    private final TokenSet myTokenSet;

    public IndentationFoldingBuilder(TokenSet tokenSet) {
        this.myTokenSet = tokenSet;
    }

    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull ASTNode astNode, @NotNull Document document) {
        if (astNode == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/indentation/IndentationFoldingBuilder.buildFoldRegions must not be null");
        }
        if (document == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/indentation/IndentationFoldingBuilder.buildFoldRegions must not be null");
        }
        LinkedList<FoldingDescriptor> descriptors = new LinkedList<FoldingDescriptor>();
        this.collectDescriptors(astNode, descriptors);
        FoldingDescriptor[] foldingDescriptorArray = descriptors.toArray(new FoldingDescriptor[descriptors.size()]);
        if (foldingDescriptorArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/indentation/IndentationFoldingBuilder.buildFoldRegions must not return null");
        }
        return foldingDescriptorArray;
    }

    private void collectDescriptors(@NotNull ASTNode node, @NotNull List<FoldingDescriptor> descriptors) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/indentation/IndentationFoldingBuilder.collectDescriptors must not be null");
        }
        if (descriptors == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/indentation/IndentationFoldingBuilder.collectDescriptors must not be null");
        }
        ASTNode[] children = node.getChildren(this.myTokenSet);
        if (children.length > 0) {
            if (node.getTreeParent() != null) {
                descriptors.add(new FoldingDescriptor(node, node.getTextRange()));
            }
            for (ASTNode child : children) {
                this.collectDescriptors(child, descriptors);
            }
        }
    }

    @Nullable
    public String getPlaceholderText(@NotNull ASTNode node) {
        String text;
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/indentation/IndentationFoldingBuilder.getPlaceholderText must not be null");
        }
        StringBuilder builder = new StringBuilder();
        for (ASTNode child = node.getFirstChildNode(); child != null && (text = child.getText()) != null && !text.contains("\n"); child = child.getTreeNext()) {
            builder.append(text);
        }
        return builder.toString();
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/indentation/IndentationFoldingBuilder.isCollapsedByDefault must not be null");
        }
        return false;
    }
}

