/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView.smartTree;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.smartTree.CachingChildrenTreeNode;
import com.intellij.ide.util.treeView.smartTree.Group;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElementWrapper;
import com.intellij.ide.util.treeView.smartTree.TreeModel;
import com.intellij.openapi.project.Project;
import java.util.Collection;

public class GroupWrapper
extends CachingChildrenTreeNode<Group> {
    public GroupWrapper(Project project, Group value, TreeModel treeModel) {
        super(project, value, treeModel);
        this.clearChildren();
    }

    @Override
    public void copyFromNewInstance(CachingChildrenTreeNode newInstance) {
        this.clearChildren();
        this.setChildren(newInstance.getChildren());
        this.synchronizeChildren();
    }

    public void update(PresentationData presentation) {
        presentation.updateFrom(((Group)this.getValue()).getPresentation());
    }

    @Override
    public void initChildren() {
        this.clearChildren();
        Collection children = ((Group)this.getValue()).getChildren();
        for (TreeElement child : children) {
            TreeElementWrapper childNode = this.createChildNode(child);
            this.addSubElement(childNode);
        }
    }

    @Override
    protected void performTreeActions() {
        this.filterChildren(this.myTreeModel.getFilters());
        this.groupChildren(this.myTreeModel.getGroupers());
        this.sortChildren(this.myTreeModel.getSorters());
    }
}

