/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView.smartTree;

import com.intellij.ide.structureView.impl.StructureViewElementWrapper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Group;
import com.intellij.ide.util.treeView.smartTree.GroupWrapper;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElementWrapper;
import com.intellij.ide.util.treeView.smartTree.TreeModel;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class CachingChildrenTreeNode<Value>
extends AbstractTreeNode<Value> {
    private List<CachingChildrenTreeNode> myChildren;
    private List<CachingChildrenTreeNode> myOldChildren = null;
    protected final TreeModel myTreeModel;

    public CachingChildrenTreeNode(Project project, Value value, TreeModel treeModel) {
        super(project, value instanceof StructureViewElementWrapper ? ((StructureViewElementWrapper)value).getWrappedElement() : value);
        this.myTreeModel = treeModel;
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        this.ensureChildrenAreInitialized();
        ArrayList<AbstractTreeNode> arrayList = new ArrayList<AbstractTreeNode>(this.myChildren);
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/util/treeView/smartTree/CachingChildrenTreeNode.getChildren must not return null");
        }
        return arrayList;
    }

    private void ensureChildrenAreInitialized() {
        if (this.myChildren == null) {
            this.myChildren = new ArrayList<CachingChildrenTreeNode>();
            this.rebuildSubtree();
        }
    }

    protected void addSubElement(CachingChildrenTreeNode node) {
        this.ensureChildrenAreInitialized();
        this.myChildren.add(node);
        node.setParent(this);
    }

    protected void setChildren(Collection<AbstractTreeNode> children) {
        this.clearChildren();
        for (AbstractTreeNode node : children) {
            this.myChildren.add((CachingChildrenTreeNode)node);
            node.setParent((AbstractTreeNode)this);
        }
    }

    protected void sortChildren(Sorter[] sorters) {
        Collections.sort(this.myChildren, new CompositeComparator(sorters));
        for (CachingChildrenTreeNode child : this.myChildren) {
            if (!(child instanceof GroupWrapper)) continue;
            child.sortChildren(sorters);
        }
    }

    protected void filterChildren(Filter[] filters) {
        Collection<AbstractTreeNode> children = this.getChildren();
        for (Filter filter : filters) {
            Iterator<AbstractTreeNode> eachNode = children.iterator();
            while (eachNode.hasNext()) {
                TreeElementWrapper eachChild = (TreeElementWrapper)eachNode.next();
                if (filter.isVisible((TreeElement)eachChild.getValue())) continue;
                eachNode.remove();
            }
        }
        this.setChildren(children);
    }

    protected void groupChildren(Grouper[] groupers) {
        for (Grouper grouper : groupers) {
            this.groupElements(grouper);
        }
        Collection<AbstractTreeNode> children = this.getChildren();
        for (AbstractTreeNode child : children) {
            if (!(child instanceof GroupWrapper)) continue;
            ((GroupWrapper)child).groupChildren(groupers);
        }
    }

    private void groupElements(Grouper grouper) {
        ArrayList<AbstractTreeNode<TreeElement>> ungrouped = new ArrayList<AbstractTreeNode<TreeElement>>();
        Collection<AbstractTreeNode> children = this.getChildren();
        for (AbstractTreeNode child : children) {
            CachingChildrenTreeNode node = (CachingChildrenTreeNode)child;
            if (!(node instanceof TreeElementWrapper)) continue;
            ungrouped.add(node);
        }
        if (!ungrouped.isEmpty()) {
            this.processUngrouped(ungrouped, grouper);
        }
        LinkedHashSet<AbstractTreeNode> result = new LinkedHashSet<AbstractTreeNode>();
        for (AbstractTreeNode child : children) {
            AbstractTreeNode parent = child.getParent();
            if (parent != this) {
                if (result.contains(parent)) continue;
                result.add(parent);
                continue;
            }
            result.add(child);
        }
        this.setChildren(result);
    }

    private void processUngrouped(List<AbstractTreeNode<TreeElement>> ungrouped, Grouper grouper) {
        Map<TreeElement, AbstractTreeNode> ungroupedObjects = CachingChildrenTreeNode.collectValues(ungrouped);
        Collection groups = grouper.group((AbstractTreeNode)this, ungroupedObjects.keySet());
        Map<Group, GroupWrapper> groupNodes = this.createGroupNodes(groups);
        for (Group group : groups) {
            GroupWrapper groupWrapper = groupNodes.get(group);
            Collection children = group.getChildren();
            for (TreeElement node : children) {
                TreeElementWrapper child = this.createChildNode(node);
                groupWrapper.addSubElement(child);
                AbstractTreeNode abstractTreeNode = ungroupedObjects.get(node);
                abstractTreeNode.setParent((AbstractTreeNode)groupWrapper);
            }
        }
    }

    protected TreeElementWrapper createChildNode(TreeElement child) {
        return new TreeElementWrapper(this.getProject(), child, this.myTreeModel);
    }

    private static Map<TreeElement, AbstractTreeNode> collectValues(List<AbstractTreeNode<TreeElement>> ungrouped) {
        LinkedHashMap<TreeElement, AbstractTreeNode> objects = new LinkedHashMap<TreeElement, AbstractTreeNode>();
        for (AbstractTreeNode<TreeElement> node : ungrouped) {
            objects.put((TreeElement)node.getValue(), node);
        }
        return objects;
    }

    private Map<Group, GroupWrapper> createGroupNodes(Collection<Group> groups) {
        THashMap result = new THashMap();
        for (Group group : groups) {
            result.put(group, this.createGroupWrapper(this.getProject(), group, this.myTreeModel));
        }
        return result;
    }

    protected GroupWrapper createGroupWrapper(Project project, Group group, TreeModel treeModel) {
        return new GroupWrapper(project, group, treeModel);
    }

    private void rebuildSubtree() {
        this.initChildren();
        this.performTreeActions();
        this.synchronizeChildren();
    }

    protected void synchronizeChildren() {
        if (this.myOldChildren != null && this.myChildren != null) {
            HashMap<CachingChildrenTreeNode, CachingChildrenTreeNode> oldValuesToChildrenMap = new HashMap<CachingChildrenTreeNode, CachingChildrenTreeNode>();
            for (CachingChildrenTreeNode oldChild : this.myOldChildren) {
                Object oldValue = oldChild instanceof TreeElementWrapper ? oldChild.getValue() : oldChild;
                if (oldValue == null) continue;
                oldValuesToChildrenMap.put((CachingChildrenTreeNode)((Object)oldValue), oldChild);
            }
            for (int i = 0; i < this.myChildren.size(); ++i) {
                CachingChildrenTreeNode oldChild;
                Object newValue;
                CachingChildrenTreeNode newChild = this.myChildren.get(i);
                Object object = newValue = newChild instanceof TreeElementWrapper ? newChild.getValue() : newChild;
                if (newValue == null || (oldChild = (CachingChildrenTreeNode)((Object)oldValuesToChildrenMap.get(newValue))) == null) continue;
                oldChild.copyFromNewInstance(newChild);
                oldChild.setValue(newChild.getValue());
                this.myChildren.set(i, oldChild);
            }
            this.myOldChildren = null;
        }
    }

    protected abstract void copyFromNewInstance(CachingChildrenTreeNode var1);

    protected abstract void performTreeActions();

    protected abstract void initChildren();

    public void navigate(boolean requestFocus) {
        ((Navigatable)this.getValue()).navigate(requestFocus);
    }

    public boolean canNavigate() {
        return this.getValue() instanceof Navigatable && ((Navigatable)this.getValue()).canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.getValue() instanceof Navigatable && ((Navigatable)this.getValue()).canNavigateToSource();
    }

    protected void clearChildren() {
        if (this.myChildren != null) {
            this.myChildren.clear();
        } else {
            this.myChildren = new ArrayList<CachingChildrenTreeNode>();
        }
    }

    public void rebuildChildren() {
        if (this.myChildren != null) {
            this.myOldChildren = this.myChildren;
            for (CachingChildrenTreeNode node : this.myChildren) {
                node.rebuildChildren();
            }
            this.myChildren = null;
        }
    }

    protected void resetChildren() {
        this.myChildren = null;
    }

    private static class CompositeComparator
    implements Comparator<CachingChildrenTreeNode> {
        private final Sorter[] mySorters;

        public CompositeComparator(Sorter[] sorters) {
            this.mySorters = sorters;
        }

        @Override
        public int compare(CachingChildrenTreeNode o1, CachingChildrenTreeNode o2) {
            Object value1 = o1.getValue();
            Object value2 = o2.getValue();
            for (Sorter sorter : this.mySorters) {
                int result = sorter.getComparator().compare(value1, value2);
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
    }
}

