/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.scopeChooser;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import java.util.LinkedList;
import org.jetbrains.annotations.Nullable;

public class ClassHierarchyScopeDescriptor
extends ScopeDescriptor {
    private SearchScope myCachedScope;
    private final Project myProject;

    public ClassHierarchyScopeDescriptor(Project project) {
        super(null);
        this.myProject = project;
    }

    @Override
    public String getDisplay() {
        return IdeBundle.message((String)"scope.class.hierarchy", (Object[])new Object[0]);
    }

    @Override
    @Nullable
    public SearchScope getScope() {
        if (this.myCachedScope == null) {
            TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)this.myProject).createAllProjectScopeChooser(IdeBundle.message((String)"prompt.choose.base.class.of.the.hierarchy", (Object[])new Object[0]));
            chooser.showDialog();
            PsiClass aClass = chooser.getSelectedClass();
            if (aClass == null) {
                return null;
            }
            LinkedList<PsiClass> classesToSearch = new LinkedList<PsiClass>();
            classesToSearch.add(aClass);
            classesToSearch.addAll(ClassInheritorsSearch.search((PsiClass)aClass, (SearchScope)aClass.getUseScope(), (boolean)true).findAll());
            this.myCachedScope = new LocalSearchScope(classesToSearch.toArray(new PsiElement[classesToSearch.size()]), IdeBundle.message((String)"scope.hierarchy", (Object[])new Object[]{ClassPresentationUtil.getNameForClass(aClass, true)}));
        }
        return this.myCachedScope;
    }
}

