/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard.modes;

import com.intellij.ide.util.newProjectWizard.ProjectNameWithTypeStep;
import com.intellij.ide.util.newProjectWizard.StepSequence;
import com.intellij.ide.util.newProjectWizard.modes.WizardMode;
import com.intellij.ide.util.projectWizard.EmptyModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateFromScratchMode
extends WizardMode {
    @NonNls
    private final Map<String, ModuleBuilder> myBuildersMap = new HashMap<String, ModuleBuilder>();

    @Override
    @NotNull
    public String getDisplayName(WizardContext context) {
        String string = ProjectBundle.message((String)"project.new.wizard.from.scratch.title", (Object[])new Object[]{context.getPresentationName()});
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/util/newProjectWizard/modes/CreateFromScratchMode.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String getDescription(WizardContext context) {
        String string = ProjectBundle.message((String)"project.new.wizard.from.scratch.description", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName(), context.getPresentationName()});
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/util/newProjectWizard/modes/CreateFromScratchMode.getDescription must not return null");
        }
        return string;
    }

    @Override
    @Nullable
    protected StepSequence createSteps(WizardContext context, ModulesProvider modulesProvider) {
        StepSequence sequence = new StepSequence(null);
        sequence.addCommonStep(new ProjectNameWithTypeStep(context, sequence, this));
        for (ModuleBuilder builder : ModuleBuilder.getAllBuilders()) {
            this.addModuleBuilder(builder, context, modulesProvider, sequence);
        }
        this.myBuildersMap.put(ModuleType.EMPTY.getId(), (ModuleBuilder)new EmptyModuleBuilder());
        return sequence;
    }

    private void addModuleBuilder(ModuleBuilder builder, WizardContext context, ModulesProvider modulesProvider, StepSequence myStepSequence) {
        String id = builder.getBuilderId();
        StepSequence sequence = new StepSequence(myStepSequence);
        this.myBuildersMap.put(id, builder);
        for (ModuleWizardStep step : builder.createWizardSteps(context, modulesProvider)) {
            sequence.addCommonStep(step);
        }
        if (!sequence.getCommonSteps().isEmpty()) {
            myStepSequence.addSpecificSteps(id, sequence);
        }
    }

    @Override
    public boolean isAvailable(WizardContext context) {
        return true;
    }

    public ModuleBuilder getModuleBuilder() {
        return this.myBuildersMap.get(this.getSelectedType());
    }

    @Override
    @Nullable
    public JComponent getAdditionalSettings() {
        return null;
    }

    @Override
    public void onChosen(boolean enabled) {
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myBuildersMap.clear();
    }
}

