/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.openapi.module.ModuleType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class StepSequence {
    private final List<ModuleWizardStep> myCommonSteps = new ArrayList<ModuleWizardStep>();
    private final Map<String, StepSequence> mySpecificSteps = new HashMap<String, StepSequence>();
    @NonNls
    private String myType;
    private StepSequence myParentSequence;

    public StepSequence() {
        this(null);
    }

    public StepSequence(StepSequence stepSequence) {
        this.myParentSequence = stepSequence;
    }

    public void addCommonStep(ModuleWizardStep step) {
        this.myCommonSteps.add(step);
    }

    public void addSpecificSteps(String type, StepSequence sequence) {
        this.mySpecificSteps.put(type, sequence);
    }

    public List<ModuleWizardStep> getCommonSteps() {
        return this.myCommonSteps;
    }

    public StepSequence getSpecificSteps(String type) {
        return this.mySpecificSteps.get(type);
    }

    public Set<String> getTypes() {
        return this.mySpecificSteps.keySet();
    }

    @Nullable
    public ModuleWizardStep getNextStep(ModuleWizardStep step) {
        StepSequence stepSequence = this.mySpecificSteps.get(this.myType);
        if (this.myCommonSteps.contains(step)) {
            int idx = this.myCommonSteps.indexOf(step);
            if (idx < this.myCommonSteps.size() - 1) {
                return this.myCommonSteps.get(idx + 1);
            }
            if (stepSequence != null && stepSequence.getCommonSteps().size() > 0) {
                return stepSequence.getCommonSteps().get(0);
            }
        }
        if (stepSequence != null) {
            return stepSequence.getNextStep(step);
        }
        return null;
    }

    @Nullable
    public ModuleWizardStep getPreviousStep(ModuleWizardStep step) {
        StepSequence stepSequence;
        if (this.myCommonSteps.contains(step)) {
            List<ModuleWizardStep> commonSteps;
            int idx = this.myCommonSteps.indexOf(step);
            if (idx > 0) {
                return this.myCommonSteps.get(idx - 1);
            }
            if (this.myParentSequence != null && !(commonSteps = this.myParentSequence.getCommonSteps()).isEmpty()) {
                return commonSteps.get(commonSteps.size() - 1);
            }
        }
        return (stepSequence = this.mySpecificSteps.get(this.myType)) != null ? stepSequence.getPreviousStep(step) : null;
    }

    public void setType(@NonNls String type) {
        this.myType = type == null ? ModuleType.EMPTY.getId() : type;
    }

    public String getSelectedType() {
        return this.myType;
    }
}

