/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ModuleDescriptor {
    private String myName;
    private final Map<File, Set<File>> myContentToSourceRoots = new HashMap<File, Set<File>>();
    private final Set<File> myLibraryFiles = new HashSet<File>();
    private final Set<ModuleDescriptor> myDependencies = new HashSet<ModuleDescriptor>();
    private static final String[] ourModuleNameStoplist = new String[]{"java", "src", "source", "sources", "C:", "D:", "E:", "F:", "temp", "tmp"};

    public ModuleDescriptor(File contentRoot, Set<File> sourceRoots) {
        this.myName = ModuleDescriptor.suggestModuleName(contentRoot);
        this.myContentToSourceRoots.put(contentRoot, sourceRoots);
    }

    private static String suggestModuleName(File contentRoot) {
        for (File dir = contentRoot; dir != null; dir = dir.getParentFile()) {
            String suggestion = dir.getName();
            boolean belongsToStopList = false;
            for (String undesirableName : ourModuleNameStoplist) {
                if (!suggestion.equalsIgnoreCase(undesirableName)) continue;
                belongsToStopList = true;
                break;
            }
            if (belongsToStopList) continue;
            return StringUtil.capitalize((String)suggestion);
        }
        return StringUtil.capitalize((String)contentRoot.getName());
    }

    public String getName() {
        return this.myName;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public Set<File> getContentRoots() {
        return Collections.unmodifiableSet(this.myContentToSourceRoots.keySet());
    }

    public Set<File> getSourceRoots() {
        HashSet<File> allSources = new HashSet<File>();
        for (Set<File> files : this.myContentToSourceRoots.values()) {
            allSources.addAll(files);
        }
        return allSources;
    }

    public Set<File> getSourceRoots(File contentRoot) {
        Set<File> sources = this.myContentToSourceRoots.get(contentRoot);
        return sources != null ? Collections.unmodifiableSet(sources) : Collections.emptySet();
    }

    public void addContentRoot(File contentRoot) {
        this.myContentToSourceRoots.put(contentRoot, new HashSet());
    }

    public Set<File> removeContentRoot(File contentRoot) {
        return this.myContentToSourceRoots.remove(contentRoot);
    }

    public void addSourceRoot(File contentRoot, File sourceRoot) {
        Set<File> sources = this.myContentToSourceRoots.get(contentRoot);
        if (sources == null) {
            sources = new HashSet<File>();
            this.myContentToSourceRoots.put(contentRoot, sources);
        }
        sources.add(sourceRoot);
    }

    public void addDependencyOn(ModuleDescriptor dependence) {
        this.myDependencies.add(dependence);
    }

    public void removeDependencyOn(ModuleDescriptor module) {
        this.myDependencies.remove(module);
    }

    public void addLibraryFile(File libFile) {
        this.myLibraryFiles.add(libFile);
    }

    public Set<File> getLibraryFiles() {
        return this.myLibraryFiles;
    }

    public Set<ModuleDescriptor> getDependencies() {
        return Collections.unmodifiableSet(this.myDependencies);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[Module: ").append(this.getContentRoots()).append(" | ");
        for (File sourceRoot : this.getSourceRoots()) {
            builder.append(sourceRoot.getName()).append(",");
        }
        builder.append("]");
        return builder.toString();
    }

    public void clearModuleDependencies() {
        this.myDependencies.clear();
    }

    public void clearLibraryFiles() {
        this.myLibraryFiles.clear();
    }

    @NotNull
    public String computeModuleFilePath() throws InvalidDataException {
        String name = this.getName();
        Set<File> contentRoots = this.getContentRoots();
        if (contentRoots.size() > 0) {
            String string = contentRoots.iterator().next().getPath() + File.separator + name + ".iml";
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/ide/util/importProject/ModuleDescriptor.computeModuleFilePath must not return null");
            }
            return string;
        }
        throw new InvalidDataException("Module " + name + " has no content roots and will not be created.");
    }
}

