/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.ide.util.importProject.LibrariesLayoutPanel;
import com.intellij.ide.util.importProject.LibraryDescriptor;
import com.intellij.ide.util.importProject.ModuleInsight;
import com.intellij.ide.util.newProjectWizard.ProjectFromSourcesBuilder;
import com.intellij.ide.util.projectWizard.AbstractStepWithProgress;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.util.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;

public class LibrariesDetectionStep
extends AbstractStepWithProgress<List<LibraryDescriptor>> {
    private final ProjectFromSourcesBuilder myBuilder;
    private final ModuleInsight myInsight;
    private final Icon myIcon;
    private final String myHelpId;
    private LibrariesLayoutPanel myLibrariesPanel;
    int myPreviousStateHashCode = -1;

    public LibrariesDetectionStep(ProjectFromSourcesBuilder builder, ModuleInsight insight, Icon icon, @NonNls String helpId) {
        super("Stop library analysis?");
        this.myBuilder = builder;
        this.myInsight = insight;
        this.myIcon = icon;
        this.myHelpId = helpId;
    }

    public void updateDataModel() {
        this.myBuilder.setLibraries(this.myLibrariesPanel.getChosenEntries());
    }

    @Override
    protected JComponent createResultsPanel() {
        this.myLibrariesPanel = new LibrariesLayoutPanel(this.myInsight);
        return this.myLibrariesPanel;
    }

    @Override
    protected String getProgressText() {
        return "Searching for libraries. Please wait.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean shouldRunProgress() {
        int currentHash = this.calcStateHashCode();
        try {
            boolean bl = currentHash != this.myPreviousStateHashCode;
            return bl;
        }
        finally {
            this.myPreviousStateHashCode = currentHash;
        }
    }

    private int calcStateHashCode() {
        int hash = this.myBuilder.getContentEntryPath().hashCode();
        for (Pair<String, String> pair : this.myBuilder.getSourcePaths()) {
            hash = 31 * hash + ((String)pair.getFirst()).hashCode();
            hash = 31 * hash + ((String)pair.getSecond()).hashCode();
        }
        return hash;
    }

    @Override
    protected List<LibraryDescriptor> calculate() {
        List<Pair<String, String>> sourcePaths = this.myBuilder.getSourcePaths();
        ArrayList<Pair<File, String>> _sourcePaths = new ArrayList<Pair<File, String>>();
        for (Pair<String, String> path : sourcePaths) {
            _sourcePaths.add(new Pair((Object)new File((String)path.first), (Object)(path.second != null ? (String)path.second : "")));
        }
        HashSet<String> ignored = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(FileTypeManager.getInstance().getIgnoredFilesList(), ";", false);
        while (tokenizer.hasMoreTokens()) {
            ignored.add(tokenizer.nextToken());
        }
        this.myInsight.setRoots(Collections.singletonList(new File(this.myBuilder.getContentEntryPath())), _sourcePaths, ignored);
        this.myInsight.scanLibraries();
        return this.myInsight.getSuggestedLibraries();
    }

    @Override
    protected void onFinished(List<LibraryDescriptor> libraries, boolean canceled) {
        this.myLibrariesPanel.rebuild();
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public String getHelpId() {
        return this.myHelpId;
    }
}

