/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.ide.util.gotoByName.ContributorsBasedGotoByModel;
import com.intellij.ide.util.gotoByName.GotoFileCellRenderer;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.psi.PsiFile;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoFileModel
extends ContributorsBasedGotoByModel {
    private final int myMaxSize;
    private HashSet<FileType> myFileTypes;

    public GotoFileModel(Project project) {
        super(project, (ChooseByNameContributor[])Extensions.getExtensions((ExtensionPointName)ChooseByNameContributor.FILE_EP_NAME));
        this.myMaxSize = WindowManagerEx.getInstanceEx().getFrame((Project)project).getSize().width;
    }

    public synchronized void setFileTypes(FileType[] fileTypes) {
        this.myFileTypes = new HashSet<FileType>(Arrays.asList(fileTypes));
    }

    private synchronized Set<FileType> getFileTypes() {
        return this.myFileTypes;
    }

    @Override
    protected boolean acceptItem(NavigationItem item) {
        if (item instanceof PsiFile) {
            PsiFile file = (PsiFile)item;
            Set<FileType> types = this.getFileTypes();
            if (types != null) {
                if (types.contains(file.getFileType())) {
                    return true;
                }
                VirtualFile vFile = file.getVirtualFile();
                return vFile != null && types.contains(vFile.getFileType());
            }
            return true;
        }
        return super.acceptItem(item);
    }

    public String getPromptText() {
        return IdeBundle.message((String)"prompt.gotofile.enter.file.name", (Object[])new Object[0]);
    }

    public String getCheckBoxName() {
        return IdeBundle.message((String)"checkbox.include.non.project.files", (Object[])new Object[0]);
    }

    public char getCheckBoxMnemonic() {
        return SystemInfo.isMac ? (char)'P' : 'n';
    }

    public String getNotInMessage() {
        return IdeBundle.message((String)"label.no.non.java.files.found", (Object[])new Object[0]);
    }

    public String getNotFoundMessage() {
        return IdeBundle.message((String)"label.no.files.found", (Object[])new Object[0]);
    }

    public boolean loadInitialCheckBoxState() {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        return propertiesComponent.isTrueValue("GoToClass.includeJavaFiles");
    }

    public void saveInitialCheckBoxState(boolean state) {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        propertiesComponent.setValue("GoToClass.includeJavaFiles", Boolean.toString(state));
    }

    @Override
    public PsiElementListCellRenderer getListCellRenderer() {
        return new GotoFileCellRenderer(this.myMaxSize);
    }

    @Nullable
    public String getFullName(Object element) {
        if (element instanceof PsiFile) {
            VirtualFile virtualFile = ((PsiFile)element).getVirtualFile();
            return virtualFile != null ? virtualFile.getPath() : null;
        }
        return this.getElementName(element);
    }

    @NotNull
    public String[] getSeparators() {
        String[] stringArray = new String[]{"/", "\\"};
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/util/gotoByName/GotoFileModel.getSeparators must not return null");
        }
        return stringArray;
    }

    @Override
    public String getHelpId() {
        return "procedures.navigating.goto.class";
    }
}

