/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.commander.CommanderPanel;
import com.intellij.ide.commander.ProjectListBuilder;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.structureView.newStructureView.TreeActionsOwner;
import com.intellij.ide.structureView.newStructureView.TreeModelWrapper;
import com.intellij.ide.util.FileStructureFilter;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.SmartTreeStructure;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeModel;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.ui.ListScrollingUtil;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileStructureDialog
extends DialogWrapper {
    private final Editor myEditor;
    private final Navigatable myNavigatable;
    private final Project myProject;
    private MyCommanderPanel myCommanderPanel;
    private final StructureViewModel myTreeModel;
    private final StructureViewModel myBaseTreeModel;
    private SmartTreeStructure myTreeStructure;
    private final MyTreeActionsOwner myTreeActionsOwner;
    @NonNls
    private static final String ourPropertyKey = "FileStructure.narrowDown";
    private boolean myShouldNarrowDown;

    public FileStructureDialog(StructureViewModel structureViewModel, @Nullable Editor editor, Project project, Navigatable navigatable, @NotNull Disposable auxDisposable, boolean applySortAndFilter) {
        if (auxDisposable == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/ide/util/FileStructureDialog.<init> must not be null");
        }
        super(project, true);
        this.myShouldNarrowDown = false;
        this.myProject = project;
        this.myEditor = editor;
        this.myNavigatable = navigatable;
        this.myBaseTreeModel = structureViewModel;
        if (applySortAndFilter) {
            this.myTreeActionsOwner = new MyTreeActionsOwner();
            this.myTreeModel = new TreeModelWrapper(structureViewModel, this.myTreeActionsOwner);
        } else {
            this.myTreeActionsOwner = null;
            this.myTreeModel = structureViewModel;
        }
        PsiFile psiFile = this.getPsiFile(project);
        PsiElement psiElement = this.getCurrentElement(psiFile);
        this.init();
        if (psiElement != null) {
            if (structureViewModel.shouldEnterElement((Object)psiElement)) {
                this.myCommanderPanel.getBuilder().enterElement(psiElement, PsiUtilBase.getVirtualFile((PsiElement)psiElement));
            } else {
                this.myCommanderPanel.getBuilder().selectElement(psiElement, PsiUtilBase.getVirtualFile((PsiElement)psiElement));
            }
        }
        Disposer.register((Disposable)this.myDisposable, (Disposable)auxDisposable);
    }

    protected PsiFile getPsiFile(Project project) {
        return PsiDocumentManager.getInstance((Project)project).getPsiFile(this.myEditor.getDocument());
    }

    @Nullable
    protected Border createContentPaneBorder() {
        return null;
    }

    public void dispose() {
        this.myCommanderPanel.dispose();
        super.dispose();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.ide.util.FileStructureDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return IdeFocusTraversalPolicy.getPreferredFocusedComponent(this.myCommanderPanel);
    }

    @Nullable
    protected PsiElement getCurrentElement(@Nullable PsiFile psiFile) {
        if (psiFile == null) {
            return null;
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        Object elementAtCursor = this.myTreeModel.getCurrentEditorElement();
        if (elementAtCursor instanceof PsiElement) {
            return (PsiElement)elementAtCursor;
        }
        return null;
    }

    protected JComponent createCenterPanel() {
        this.myCommanderPanel = new MyCommanderPanel(this.myProject);
        this.myTreeStructure = new MyStructureTreeStructure();
        ArrayList<FileStructureFilter> fileStructureFilters = new ArrayList<FileStructureFilter>();
        if (this.myTreeActionsOwner != null) {
            for (Filter filter : this.myBaseTreeModel.getFilters()) {
                if (!(filter instanceof FileStructureFilter)) continue;
                FileStructureFilter fsFilter = (FileStructureFilter)filter;
                this.myTreeActionsOwner.setFilterIncluded(fsFilter, true);
                fileStructureFilters.add(fsFilter);
            }
        }
        PsiFile psiFile = this.getPsiFile(this.myProject);
        boolean showRoot = this.isShowRoot(psiFile);
        ProjectListBuilder projectListBuilder = new ProjectListBuilder(this.myProject, this.myCommanderPanel, this.myTreeStructure, null, showRoot){

            @Override
            protected boolean nodeIsAcceptableForElement(AbstractTreeNode node, Object element) {
                return Comparing.equal((Object)((StructureViewTreeElement)node.getValue()).getValue(), (Object)element);
            }

            @Override
            protected void refreshSelection() {
                FileStructureDialog.this.myCommanderPanel.scrollSelectionInView();
                if (FileStructureDialog.this.myShouldNarrowDown) {
                    FileStructureDialog.this.myCommanderPanel.updateSpeedSearch();
                }
            }

            @Override
            protected List<AbstractTreeNode> getAllAcceptableNodes(Object[] childElements, VirtualFile file) {
                ArrayList<AbstractTreeNode> result = new ArrayList<AbstractTreeNode>();
                for (Object childElement : childElements) {
                    result.add((AbstractTreeNode)childElement);
                }
                return result;
            }
        };
        this.myCommanderPanel.setBuilder(projectListBuilder);
        this.myCommanderPanel.setTitlePanelVisible(false);
        new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                boolean succeeded = FileStructureDialog.this.myCommanderPanel.navigateSelectedElement();
                if (succeeded) {
                    this.unregisterCustomShortcutSet(FileStructureDialog.this.myCommanderPanel);
                }
            }
        }.registerCustomShortcutSet(ActionManager.getInstance().getAction("EditSource").getShortcutSet(), (JComponent)this.myCommanderPanel);
        this.myCommanderPanel.setPreferredSize(new Dimension(400, 500));
        JPanel panel = new JPanel(new GridBagLayout());
        this.addNarrowDownCheckbox(panel);
        for (FileStructureFilter filter : fileStructureFilters) {
            this.addFilterCheckbox(panel, filter);
        }
        panel.add((Component)this.myCommanderPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    protected boolean isShowRoot(PsiFile psiFile) {
        StructureViewBuilder viewBuilder = LanguageStructureViewBuilder.INSTANCE.getStructureViewBuilder(psiFile);
        return viewBuilder instanceof TreeBasedStructureViewBuilder && ((TreeBasedStructureViewBuilder)viewBuilder).isRootNodeShown();
    }

    private void addNarrowDownCheckbox(JPanel panel) {
        final JCheckBox checkBox = new JCheckBox(IdeBundle.message((String)"checkbox.narrow.down.the.list.on.typing", (Object[])new Object[0]));
        checkBox.setSelected(PropertiesComponent.getInstance().isTrueValue(ourPropertyKey));
        checkBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FileStructureDialog.this.myShouldNarrowDown = checkBox.isSelected();
                PropertiesComponent.getInstance().setValue(FileStructureDialog.ourPropertyKey, Boolean.toString(FileStructureDialog.this.myShouldNarrowDown));
                ProjectListBuilder builder = (ProjectListBuilder)FileStructureDialog.this.myCommanderPanel.getBuilder();
                if (builder == null) {
                    return;
                }
                builder.addUpdateRequest();
            }
        });
        checkBox.setFocusable(false);
        panel.add((Component)checkBox, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
    }

    private void addFilterCheckbox(JPanel panel, final FileStructureFilter fileStructureFilter) {
        final JCheckBox chkFilter = new JCheckBox();
        chkFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileStructureDialog.this.myTreeActionsOwner.setFilterIncluded(fileStructureFilter, !chkFilter.isSelected());
                FileStructureDialog.this.myTreeStructure.rebuildTree();
                ProjectListBuilder builder = (ProjectListBuilder)FileStructureDialog.this.myCommanderPanel.getBuilder();
                if (builder != null) {
                    builder.updateList(true);
                }
            }
        });
        chkFilter.setFocusable(false);
        String text = fileStructureFilter.getCheckBoxText();
        Shortcut[] shortcuts = fileStructureFilter.getShortcut();
        if (shortcuts.length > 0) {
            text = text + " (" + KeymapUtil.getShortcutText((Shortcut)shortcuts[0]) + ")";
            new AnAction(){

                public void actionPerformed(AnActionEvent e) {
                    chkFilter.doClick();
                }
            }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcuts), (JComponent)panel);
        }
        chkFilter.setText(text);
        panel.add((Component)chkFilter, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
    }

    @Nullable
    protected JComponent createSouthPanel() {
        return null;
    }

    public CommanderPanel getPanel() {
        return this.myCommanderPanel;
    }

    private static SpeedSearchBase.SpeedSearchComparator createSpeedSearchComparator() {
        return new SpeedSearchBase.SpeedSearchComparator(){

            @Override
            public void translateCharacter(StringBuilder buf, char ch) {
                if (ch == '*') {
                    buf.append(".*");
                } else {
                    if (ch == ':') {
                        buf.append(".*");
                    }
                    super.translateCharacter(buf, ch);
                }
            }
        };
    }

    private class MyTreeActionsOwner
    implements TreeActionsOwner {
        private final Set<Filter> myFilters = new HashSet();

        private MyTreeActionsOwner() {
        }

        @Override
        public void setActionActive(String name, boolean state) {
        }

        @Override
        public boolean isActionActive(String name) {
            for (Sorter sorter : FileStructureDialog.this.myBaseTreeModel.getSorters()) {
                if (!sorter.getName().equals(name) || sorter.isVisible()) continue;
                return true;
            }
            for (Filter filter : this.myFilters) {
                if (!filter.getName().equals(name)) continue;
                return true;
            }
            return "ALPHA_COMPARATOR".equals(name);
        }

        public void setFilterIncluded(FileStructureFilter filter, boolean selected) {
            if (selected) {
                this.myFilters.add(filter);
            } else {
                this.myFilters.remove(filter);
            }
        }
    }

    private class MyStructureTreeStructure
    extends SmartTreeStructure {
        public MyStructureTreeStructure() {
            super(FileStructureDialog.this.myProject, (TreeModel)FileStructureDialog.this.myTreeModel);
        }

        @Override
        public Object[] getChildElements(Object element) {
            Object[] childElements = super.getChildElements(element);
            if (!FileStructureDialog.this.myShouldNarrowDown) {
                return childElements;
            }
            String enteredPrefix = FileStructureDialog.this.myCommanderPanel.getEnteredPrefix();
            if (enteredPrefix == null) {
                return childElements;
            }
            ArrayList<Object> filteredElements = new ArrayList<Object>(childElements.length);
            SpeedSearchBase.SpeedSearchComparator speedSearchComparator = FileStructureDialog.createSpeedSearchComparator();
            for (Object child : childElements) {
                String name;
                Object value;
                if (child instanceof AbstractTreeNode && (value = ((AbstractTreeNode)child).getValue()) instanceof TreeElement && ((name = ((TreeElement)value).getPresentation().getPresentableText()) == null || !speedSearchComparator.doCompare(enteredPrefix, name))) continue;
                filteredElements.add(child);
            }
            return ArrayUtil.toObjectArray(filteredElements);
        }

        @Override
        public void rebuildTree() {
            this.getChildElements(this.getRootElement());
            super.rebuildTree();
        }
    }

    private class MyCommanderPanel
    extends CommanderPanel
    implements DataProvider {
        @Override
        protected boolean shouldDrillDownOnEmptyElement(AbstractTreeNode node) {
            return false;
        }

        public MyCommanderPanel(Project _project) {
            super(_project, false);
            this.myList.setSelectionMode(0);
            this.myListSpeedSearch.addChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    ProjectListBuilder builder = (ProjectListBuilder)MyCommanderPanel.this.getBuilder();
                    if (builder == null) {
                        return;
                    }
                    builder.addUpdateRequest(MyCommanderPanel.this.hasPrefixShortened(evt));
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int index = MyCommanderPanel.this.myList.getSelectedIndex();
                            if (index != -1 && index < MyCommanderPanel.this.myList.getModel().getSize()) {
                                MyCommanderPanel.this.myList.clearSelection();
                                ListScrollingUtil.selectItem((JList)MyCommanderPanel.this.myList, (int)index);
                            } else {
                                ListScrollingUtil.ensureSelectionExists((JList)MyCommanderPanel.this.myList);
                            }
                        }
                    });
                }
            });
            this.myListSpeedSearch.setComparator(FileStructureDialog.createSpeedSearchComparator());
        }

        private boolean hasPrefixShortened(PropertyChangeEvent evt) {
            return evt.getNewValue() != null && evt.getOldValue() != null && ((String)evt.getNewValue()).length() < ((String)evt.getOldValue()).length();
        }

        @Override
        public boolean navigateSelectedElement() {
            final Ref succeeded = new Ref();
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            commandProcessor.executeCommand(FileStructureDialog.this.myProject, new Runnable(){

                @Override
                public void run() {
                    succeeded.set((Object)MyCommanderPanel.super.navigateSelectedElement());
                    IdeDocumentHistory.getInstance(FileStructureDialog.this.myProject).includeCurrentCommandAsNavigation();
                }
            }, "Navigate", null);
            if (((Boolean)succeeded.get()).booleanValue()) {
                FileStructureDialog.this.close(1);
            }
            return (Boolean)succeeded.get();
        }

        public Object getData(String dataId) {
            Object selectedElement = FileStructureDialog.this.myCommanderPanel.getSelectedValue();
            if (selectedElement instanceof TreeElement) {
                selectedElement = ((StructureViewTreeElement)selectedElement).getValue();
            }
            if (PlatformDataKeys.NAVIGATABLE.is(dataId)) {
                return selectedElement instanceof Navigatable ? selectedElement : FileStructureDialog.this.myNavigatable;
            }
            if (OpenFileDescriptor.NAVIGATE_IN_EDITOR.is(dataId)) {
                return FileStructureDialog.this.myEditor;
            }
            return this.getDataImpl(dataId);
        }

        public String getEnteredPrefix() {
            return this.myListSpeedSearch.getEnteredPrefix();
        }

        public void updateSpeedSearch() {
            this.myListSpeedSearch.refreshSelection();
        }

        public void scrollSelectionInView() {
            int selectedIndex = this.myList.getSelectedIndex();
            if (selectedIndex >= 0) {
                ListScrollingUtil.ensureIndexIsVisible((JList)this.myList, (int)selectedIndex, (int)0);
            }
        }
    }
}

