/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.customization;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.customization.ActionUrl;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.ide.ui.customization.CustomizationUtil;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.actionSystem.ex.QuickListsManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.keymap.impl.ui.ActionsTree;
import com.intellij.openapi.keymap.impl.ui.ActionsTreeUtil;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DetailsComponent;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.packageDependencies.ui.TreeExpansionMonitor;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.InsertPathAction;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ImageLoader;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public class CustomizableActionsPanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.ui.customization.CustomizableActionsPanel");
    private static final Icon EMPTY_ICON = new EmptyIcon(18, 18);
    private static final Icon QUICK_LIST_ICON = IconLoader.getIcon((String)"/actions/quickList.png");
    private JButton myEditIconButton;
    private JButton myRemoveActionButton;
    private JButton myAddActionButton;
    private JButton myMoveActionDownButton;
    private JButton myMoveActionUpButton;
    private JPanel myPanel;
    private JTree myActionsTree;
    private JButton myAddSeparatorButton;
    private final TreeExpansionMonitor myTreeExpansionMonitor;
    private CustomActionsSchema mySelectedSchema;
    private JPanel myDetailsPanel;
    private JButton myRestoreDefaultButton;
    public static final Icon FULLISH_ICON = IconLoader.getIcon((String)"/toolbar/unknown.png");
    private DetailsComponent myDetailsComponent;

    public CustomizableActionsPanel() {
        this.$$$setupUI$$$();
        Group rootGroup = new Group("root", null, null);
        final DefaultMutableTreeNode root = new DefaultMutableTreeNode(rootGroup);
        DefaultTreeModel model = new DefaultTreeModel(root);
        this.myActionsTree.setModel(model);
        this.myActionsTree.setRootVisible(false);
        this.myActionsTree.setShowsRootHandles(true);
        UIUtil.setLineStyleAngled((JTree)this.myActionsTree);
        this.myActionsTree.setCellRenderer(new MyTreeCellRenderer());
        this.setButtonsDisabled();
        final ActionManager actionManager = ActionManager.getInstance();
        this.myActionsTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath[] selectionPaths = CustomizableActionsPanel.this.myActionsTree.getSelectionPaths();
                boolean isSingleSelection = selectionPaths != null && selectionPaths.length == 1;
                CustomizableActionsPanel.this.myAddActionButton.setEnabled(isSingleSelection);
                if (isSingleSelection) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectionPaths[0].getLastPathComponent();
                    String actionId = CustomizableActionsPanel.getActionId(node);
                    if (actionId != null) {
                        AnAction action = actionManager.getAction(actionId);
                        CustomizableActionsPanel.this.myEditIconButton.setEnabled(action != null && (!action.isDefaultIcon() || action.getTemplatePresentation() != null && action.getTemplatePresentation().getIcon() == null));
                    } else {
                        CustomizableActionsPanel.this.myEditIconButton.setEnabled(false);
                    }
                } else {
                    CustomizableActionsPanel.this.myEditIconButton.setEnabled(false);
                }
                CustomizableActionsPanel.this.myAddSeparatorButton.setEnabled(isSingleSelection);
                CustomizableActionsPanel.this.myRemoveActionButton.setEnabled(selectionPaths != null);
                if (selectionPaths != null) {
                    for (TreePath selectionPath : selectionPaths) {
                        if (selectionPath.getPath() == null || selectionPath.getPath().length > 2) continue;
                        CustomizableActionsPanel.this.setButtonsDisabled();
                        return;
                    }
                }
                CustomizableActionsPanel.this.myMoveActionUpButton.setEnabled(CustomizableActionsPanel.isMoveSupported(CustomizableActionsPanel.this.myActionsTree, -1));
                CustomizableActionsPanel.this.myMoveActionDownButton.setEnabled(CustomizableActionsPanel.isMoveSupported(CustomizableActionsPanel.this.myActionsTree, 1));
            }
        });
        this.myAddActionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List expandedPaths = TreeUtil.collectExpandedPaths((JTree)CustomizableActionsPanel.this.myActionsTree);
                TreePath selectionPath = CustomizableActionsPanel.this.myActionsTree.getLeadSelectionPath();
                if (selectionPath != null) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
                    FindAvailableActionsDialog dlg = new FindAvailableActionsDialog();
                    dlg.show();
                    if (dlg.isOK()) {
                        Set<Object> toAdd = dlg.getTreeSelectedActionIds();
                        if (toAdd == null) {
                            return;
                        }
                        for (Object o : toAdd) {
                            ActionUrl url = new ActionUrl(ActionUrl.getGroupPath(new TreePath(node.getPath())), o, 1, node.getParent().getIndex(node) + 1);
                            CustomizableActionsPanel.this.addCustomizedAction(url);
                            ActionUrl.changePathInActionsTree(CustomizableActionsPanel.this.myActionsTree, url);
                            if (!(o instanceof String)) continue;
                            DefaultMutableTreeNode current = new DefaultMutableTreeNode(url.getComponent());
                            current.setParent((DefaultMutableTreeNode)node.getParent());
                            CustomizableActionsPanel.this.editToolbarIcon((String)o, current);
                        }
                        ((DefaultTreeModel)CustomizableActionsPanel.this.myActionsTree.getModel()).reload();
                    }
                }
                TreeUtil.restoreExpandedPaths((JTree)CustomizableActionsPanel.this.myActionsTree, (List)expandedPaths);
            }
        });
        this.myEditIconButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomizableActionsPanel.this.myRestoreDefaultButton.setEnabled(true);
                List expandedPaths = TreeUtil.collectExpandedPaths((JTree)CustomizableActionsPanel.this.myActionsTree);
                TreePath selectionPath = CustomizableActionsPanel.this.myActionsTree.getLeadSelectionPath();
                if (selectionPath != null) {
                    EditIconDialog dlg = new EditIconDialog((DefaultMutableTreeNode)selectionPath.getLastPathComponent());
                    dlg.show();
                    if (dlg.isOK()) {
                        CustomizableActionsPanel.this.myActionsTree.repaint();
                    }
                }
                TreeUtil.restoreExpandedPaths((JTree)CustomizableActionsPanel.this.myActionsTree, (List)expandedPaths);
            }
        });
        this.myAddSeparatorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List expandedPaths = TreeUtil.collectExpandedPaths((JTree)CustomizableActionsPanel.this.myActionsTree);
                TreePath selectionPath = CustomizableActionsPanel.this.myActionsTree.getLeadSelectionPath();
                if (selectionPath != null) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
                    ActionUrl url = new ActionUrl(ActionUrl.getGroupPath(selectionPath), Separator.getInstance(), 1, node.getParent().getIndex(node) + 1);
                    ActionUrl.changePathInActionsTree(CustomizableActionsPanel.this.myActionsTree, url);
                    CustomizableActionsPanel.this.addCustomizedAction(url);
                    ((DefaultTreeModel)CustomizableActionsPanel.this.myActionsTree.getModel()).reload();
                }
                TreeUtil.restoreExpandedPaths((JTree)CustomizableActionsPanel.this.myActionsTree, (List)expandedPaths);
            }
        });
        this.myRemoveActionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List expandedPaths = TreeUtil.collectExpandedPaths((JTree)CustomizableActionsPanel.this.myActionsTree);
                TreePath[] selectionPath = CustomizableActionsPanel.this.myActionsTree.getSelectionPaths();
                if (selectionPath != null) {
                    for (TreePath treePath : selectionPath) {
                        ActionUrl url = CustomizationUtil.getActionUrl(treePath, -1);
                        ActionUrl.changePathInActionsTree(CustomizableActionsPanel.this.myActionsTree, url);
                        CustomizableActionsPanel.this.addCustomizedAction(url);
                    }
                    ((DefaultTreeModel)CustomizableActionsPanel.this.myActionsTree.getModel()).reload();
                }
                TreeUtil.restoreExpandedPaths((JTree)CustomizableActionsPanel.this.myActionsTree, (List)expandedPaths);
            }
        });
        this.myMoveActionUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List expandedPaths = TreeUtil.collectExpandedPaths((JTree)CustomizableActionsPanel.this.myActionsTree);
                TreePath[] selectionPath = CustomizableActionsPanel.this.myActionsTree.getSelectionPaths();
                if (selectionPath != null) {
                    for (TreePath treePath : selectionPath) {
                        ActionUrl url = CustomizationUtil.getActionUrl(treePath, 2);
                        int absolutePosition = url.getAbsolutePosition();
                        url.setInitialPosition(absolutePosition);
                        url.setAbsolutePosition(absolutePosition - 1);
                        ActionUrl.changePathInActionsTree(CustomizableActionsPanel.this.myActionsTree, url);
                        CustomizableActionsPanel.this.addCustomizedAction(url);
                    }
                    ((DefaultTreeModel)CustomizableActionsPanel.this.myActionsTree.getModel()).reload();
                    TreeUtil.restoreExpandedPaths((JTree)CustomizableActionsPanel.this.myActionsTree, (List)expandedPaths);
                    for (TreePath path : selectionPath) {
                        CustomizableActionsPanel.this.myActionsTree.addSelectionPath(path);
                    }
                }
            }
        });
        this.myMoveActionDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List expandedPaths = TreeUtil.collectExpandedPaths((JTree)CustomizableActionsPanel.this.myActionsTree);
                TreePath[] selectionPath = CustomizableActionsPanel.this.myActionsTree.getSelectionPaths();
                if (selectionPath != null) {
                    for (int i = selectionPath.length - 1; i >= 0; --i) {
                        TreePath treePath = selectionPath[i];
                        ActionUrl url = CustomizationUtil.getActionUrl(treePath, 2);
                        int absolutePosition = url.getAbsolutePosition();
                        url.setInitialPosition(absolutePosition);
                        url.setAbsolutePosition(absolutePosition + 1);
                        ActionUrl.changePathInActionsTree(CustomizableActionsPanel.this.myActionsTree, url);
                        CustomizableActionsPanel.this.addCustomizedAction(url);
                    }
                    ((DefaultTreeModel)CustomizableActionsPanel.this.myActionsTree.getModel()).reload();
                    TreeUtil.restoreExpandedPaths((JTree)CustomizableActionsPanel.this.myActionsTree, (List)expandedPaths);
                    for (TreePath path : selectionPath) {
                        CustomizableActionsPanel.this.myActionsTree.addSelectionPath(path);
                    }
                }
            }
        });
        this.myRestoreDefaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomizableActionsPanel.this.mySelectedSchema.copyFrom(new CustomActionsSchema());
                CustomizableActionsPanel.this.patchActionsTreeCorrespondingToSchema(root);
                CustomizableActionsPanel.this.myRestoreDefaultButton.setEnabled(false);
            }
        });
        this.patchActionsTreeCorrespondingToSchema(root);
        this.myTreeExpansionMonitor = TreeExpansionMonitor.install(this.myActionsTree);
    }

    private void addCustomizedAction(ActionUrl url) {
        this.mySelectedSchema.addAction(url);
        this.myRestoreDefaultButton.setEnabled(true);
    }

    public void initUi() {
        this.myDetailsComponent = new DetailsComponent();
        this.myDetailsComponent.setContent((JComponent)this.myDetailsPanel);
    }

    public DetailsComponent getDetails() {
        return this.myDetailsComponent;
    }

    private void editToolbarIcon(String actionId, DefaultMutableTreeNode node) {
        int exitCode;
        AnAction anAction = ActionManager.getInstance().getAction(actionId);
        if (CustomizableActionsPanel.isToolbarAction(node) && anAction.getTemplatePresentation() != null && anAction.getTemplatePresentation().getIcon() == null && (exitCode = Messages.showOkCancelDialog((String)IdeBundle.message((String)"error.adding.action.without.icon.to.toolbar", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.unable.to.add.action.without.icon.to.toolbar", (Object[])new Object[0]), (Icon)Messages.getInformationIcon())) == 0) {
            this.mySelectedSchema.addIconCustomization(actionId, null);
            anAction.getTemplatePresentation().setIcon(FULLISH_ICON);
            anAction.setDefaultIcon(false);
            node.setUserObject(Pair.create((Object)actionId, (Object)FULLISH_ICON));
            this.myActionsTree.repaint();
            CustomizableActionsPanel.setCustomizationSchemaForCurrentProjects();
        }
    }

    private void setButtonsDisabled() {
        this.myRemoveActionButton.setEnabled(false);
        this.myAddActionButton.setEnabled(false);
        this.myEditIconButton.setEnabled(false);
        this.myAddSeparatorButton.setEnabled(false);
        this.myMoveActionDownButton.setEnabled(false);
        this.myMoveActionUpButton.setEnabled(false);
    }

    private static boolean isMoveSupported(JTree tree, int dir) {
        TreePath[] selectionPaths = tree.getSelectionPaths();
        if (selectionPaths != null) {
            DefaultMutableTreeNode parent = null;
            for (TreePath treePath : selectionPaths) {
                if (treePath.getLastPathComponent() == null) continue;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                if (parent == null) {
                    parent = (DefaultMutableTreeNode)node.getParent();
                }
                if (parent != node.getParent()) {
                    return false;
                }
                if (!(dir > 0 ? parent.getIndex(node) == parent.getChildCount() - 1 : parent.getIndex(node) == 0)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    private static void setCustomizationSchemaForCurrentProjects() {
        Project[] openProjects;
        for (Project project : openProjects = ProjectManager.getInstance().getOpenProjects()) {
            IdeFrameImpl frame = WindowManagerEx.getInstanceEx().getFrame(project);
            if (frame == null) continue;
            frame.updateToolbar();
            frame.updateMenuBar();
        }
        IdeFrameImpl frame = WindowManagerEx.getInstanceEx().getFrame(null);
        if (frame != null) {
            frame.updateToolbar();
            frame.updateMenuBar();
        }
    }

    public void apply() throws ConfigurationException {
        List treePaths = TreeUtil.collectExpandedPaths((JTree)this.myActionsTree);
        if (this.mySelectedSchema != null) {
            CustomizationUtil.optimizeSchema(this.myActionsTree, this.mySelectedSchema);
        }
        this.restorePathsAfterTreeOptimization(treePaths);
        CustomActionsSchema.getInstance().copyFrom(this.mySelectedSchema);
        CustomizableActionsPanel.setCustomizationSchemaForCurrentProjects();
    }

    private void restorePathsAfterTreeOptimization(List<TreePath> treePaths) {
        for (TreePath treePath : treePaths) {
            this.myActionsTree.expandPath(CustomizationUtil.getPathByUserObjects(this.myActionsTree, treePath));
        }
    }

    public void reset() {
        this.mySelectedSchema = new CustomActionsSchema();
        this.mySelectedSchema.copyFrom(CustomActionsSchema.getInstance());
        this.patchActionsTreeCorrespondingToSchema((DefaultMutableTreeNode)this.myActionsTree.getModel().getRoot());
        this.myRestoreDefaultButton.setEnabled(this.mySelectedSchema.isModified(new CustomActionsSchema()));
    }

    public boolean isModified() {
        CustomizationUtil.optimizeSchema(this.myActionsTree, this.mySelectedSchema);
        return CustomActionsSchema.getInstance().isModified(this.mySelectedSchema);
    }

    private void patchActionsTreeCorrespondingToSchema(DefaultMutableTreeNode root) {
        root.removeAllChildren();
        if (this.mySelectedSchema != null) {
            CustomActionsSchema.fillActionGroups(root);
            for (ActionUrl actionUrl : this.mySelectedSchema.getActions()) {
                ActionUrl.changePathInActionsTree(this.myActionsTree, actionUrl);
            }
        }
        ((DefaultTreeModel)this.myActionsTree.getModel()).reload();
    }

    private static boolean isToolbarAction(DefaultMutableTreeNode node) {
        return node.getParent() != null && ((DefaultMutableTreeNode)node.getParent()).getUserObject() instanceof Group && ((Group)((DefaultMutableTreeNode)node.getParent()).getUserObject()).getName().equals(ActionsTreeUtil.MAIN_TOOLBAR);
    }

    @Nullable
    private static String getActionId(DefaultMutableTreeNode node) {
        return (String)(node.getUserObject() instanceof String ? node.getUserObject() : (node.getUserObject() instanceof Pair ? ((Pair)node.getUserObject()).first : null));
    }

    protected void doSetIcon(DefaultMutableTreeNode node, String path) {
        String actionId = CustomizableActionsPanel.getActionId(node);
        if (actionId == null) {
            return;
        }
        AnAction action = ActionManager.getInstance().getAction(actionId);
        if (action != null && action.getTemplatePresentation() != null) {
            if (path != null && path.length() > 0) {
                Icon icon;
                Image image = null;
                try {
                    image = ImageLoader.loadFromStream((InputStream)VfsUtil.convertToURL((String)VfsUtil.pathToUrl((String)path.replace(File.separatorChar, '/'))).openStream());
                }
                catch (IOException e) {
                    LOG.debug((Throwable)e);
                }
                Icon icon2 = icon = new File(path).exists() ? IconLoader.getIcon((Image)image) : null;
                if (icon != null) {
                    if (icon.getIconWidth() > EMPTY_ICON.getIconWidth() || icon.getIconHeight() > EMPTY_ICON.getIconHeight()) {
                        Messages.showErrorDialog((Component)this.myActionsTree, (String)IdeBundle.message((String)"custom.icon.validation.message", (Object[])new Object[0]), (String)IdeBundle.message((String)"custom.icon.validation.title", (Object[])new Object[0]));
                        return;
                    }
                    node.setUserObject(Pair.create((Object)actionId, (Object)icon));
                    this.mySelectedSchema.addIconCustomization(actionId, path);
                }
            } else {
                node.setUserObject(Pair.create((Object)actionId, null));
                this.mySelectedSchema.removeIconCustomization(actionId);
                DefaultMutableTreeNode nodeOnToolbar = this.findNodeOnToolbar(actionId);
                if (nodeOnToolbar != null) {
                    this.editToolbarIcon(actionId, nodeOnToolbar);
                    node.setUserObject(nodeOnToolbar.getUserObject());
                }
            }
        }
    }

    private static TextFieldWithBrowseButton createBrowseField() {
        TextFieldWithBrowseButton textField = new TextFieldWithBrowseButton();
        textField.setPreferredSize(new Dimension(150, textField.getPreferredSize().height));
        textField.setMinimumSize(new Dimension(150, textField.getPreferredSize().height));
        FileChooserDescriptor fileChooserDescriptor = new FileChooserDescriptor(true, false, false, false, false, false){

            public boolean isFileSelectable(VirtualFile file) {
                return file.getName().endsWith(".png");
            }
        };
        textField.addBrowseFolderListener(IdeBundle.message((String)"title.browse.icon", (Object[])new Object[0]), IdeBundle.message((String)"prompt.browse.icon.for.selected.action", (Object[])new Object[0]), null, fileChooserDescriptor);
        InsertPathAction.addTo((JTextComponent)textField.getTextField(), (FileChooserDescriptor)fileChooserDescriptor);
        return textField;
    }

    @Nullable
    private DefaultMutableTreeNode findNodeOnToolbar(String actionId) {
        TreeNode toolbar = ((DefaultMutableTreeNode)this.myActionsTree.getModel().getRoot()).getChildAt(1);
        for (int i = 0; i < toolbar.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)toolbar.getChildAt(i);
            String childId = CustomizableActionsPanel.getActionId(child);
            if (childId == null || !childId.equals(actionId)) continue;
            return child;
        }
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JButton jButton4;
        JButton jButton5;
        JButton jButton6;
        JButton jButton7;
        JTree jTree;
        JPanel jPanel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(9, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myDetailsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(8, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 9, 3, 0, 3, 3, 3, null, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(0, 0, 8, 1, 0, 3, 7, 7, null, null, null));
        this.myActionsTree = jTree = new JTree();
        jScrollPane.setViewportView(jTree);
        this.myAddActionButton = jButton7 = new JButton();
        this.$$$loadButtonText$$$(jButton7, ResourceBundle.getBundle("messages/IdeBundle").getString("button.add.action.after"));
        jPanel.add((Component)jButton7, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myRemoveActionButton = jButton6 = new JButton();
        this.$$$loadButtonText$$$(jButton6, ResourceBundle.getBundle("messages/IdeBundle").getString("button.remove"));
        jPanel.add((Component)jButton6, new GridConstraints(3, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myMoveActionDownButton = jButton5 = new JButton();
        this.$$$loadButtonText$$$(jButton5, ResourceBundle.getBundle("messages/IdeBundle").getString("button.move.down.d"));
        jPanel.add((Component)jButton5, new GridConstraints(5, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myMoveActionUpButton = jButton4 = new JButton();
        this.$$$loadButtonText$$$(jButton4, ResourceBundle.getBundle("messages/IdeBundle").getString("button.move.up.u"));
        jPanel.add((Component)jButton4, new GridConstraints(4, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myAddSeparatorButton = jButton3 = new JButton();
        this.$$$loadButtonText$$$(jButton3, ResourceBundle.getBundle("messages/IdeBundle").getString("button.add.separator"));
        jPanel.add((Component)jButton3, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myEditIconButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("messages/IdeBundle").getString("button.edit.action.icon"));
        jPanel.add((Component)jButton2, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myRestoreDefaultButton = jButton = new JButton();
        jButton.setText("Restore Default");
        jButton.setMnemonic('S');
        jButton.setDisplayedMnemonicIndex(2);
        jPanel.add((Component)jButton, new GridConstraints(7, 1, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class FindAvailableActionsDialog
    extends DialogWrapper {
        private JTree myTree;
        private JButton mySetIconButton;
        private TextFieldWithBrowseButton myTextField;

        FindAvailableActionsDialog() {
            super(false);
            this.setTitle(IdeBundle.message((String)"action.choose.actions.to.add", (Object[])new Object[0]));
            this.init();
        }

        protected JComponent createCenterPanel() {
            Group rootGroup = ActionsTreeUtil.createMainGroup(null, null, QuickListsManager.getInstance().getAllQuickLists());
            DefaultMutableTreeNode root = ActionsTreeUtil.createNode(rootGroup);
            DefaultTreeModel model = new DefaultTreeModel(root);
            this.myTree = new JTree();
            this.myTree.setModel(model);
            this.myTree.setCellRenderer(new MyTreeCellRenderer());
            final ActionManager actionManager = ActionManager.getInstance();
            this.mySetIconButton = new JButton(IdeBundle.message((String)"button.set.icon", (Object[])new Object[0]));
            this.mySetIconButton.setEnabled(false);
            this.mySetIconButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TreePath selectionPath = FindAvailableActionsDialog.this.myTree.getSelectionPath();
                    if (selectionPath != null) {
                        CustomizableActionsPanel.this.doSetIcon((DefaultMutableTreeNode)selectionPath.getLastPathComponent(), FindAvailableActionsDialog.this.myTextField.getText());
                        FindAvailableActionsDialog.this.myTree.repaint();
                    }
                }
            });
            this.myTextField = CustomizableActionsPanel.createBrowseField();
            this.myTextField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    FindAvailableActionsDialog.this.enableSetIconButton(actionManager);
                }
            });
            JPanel northPanel = new JPanel(new BorderLayout());
            northPanel.add((Component)this.myTextField, "Center");
            northPanel.add((Component)new JLabel(IdeBundle.message((String)"label.icon.path", (Object[])new Object[0])), "West");
            northPanel.add((Component)this.mySetIconButton, "East");
            northPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)northPanel, "North");
            panel.add((Component)ScrollPaneFactory.createScrollPane((JComponent)this.myTree), "Center");
            this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    DefaultMutableTreeNode node;
                    String actionId;
                    FindAvailableActionsDialog.this.enableSetIconButton(actionManager);
                    TreePath selectionPath = FindAvailableActionsDialog.this.myTree.getSelectionPath();
                    if (selectionPath != null && (actionId = CustomizableActionsPanel.getActionId(node = (DefaultMutableTreeNode)selectionPath.getLastPathComponent())) != null) {
                        FindAvailableActionsDialog.this.myTextField.setText(CustomizableActionsPanel.this.mySelectedSchema.getIconPath(actionId));
                    }
                }
            });
            return panel;
        }

        protected void doOKAction() {
            final ActionManager actionManager = ActionManager.getInstance();
            TreeUtil.traverseDepth((TreeNode)((TreeNode)this.myTree.getModel().getRoot()), (TreeUtil.Traverse)new TreeUtil.Traverse(){

                public boolean accept(Object node) {
                    DefaultMutableTreeNode mutableNode;
                    Object userObject;
                    if (node instanceof DefaultMutableTreeNode && (userObject = (mutableNode = (DefaultMutableTreeNode)node).getUserObject()) instanceof Pair) {
                        String actionId = (String)((Pair)userObject).first;
                        AnAction action = actionManager.getAction(actionId);
                        Icon icon = (Icon)((Pair)userObject).second;
                        action.getTemplatePresentation().setIcon(icon);
                        action.setDefaultIcon(icon == null);
                        CustomizableActionsPanel.this.editToolbarIcon(actionId, mutableNode);
                    }
                    return true;
                }
            });
            super.doOKAction();
            CustomizableActionsPanel.setCustomizationSchemaForCurrentProjects();
        }

        protected void enableSetIconButton(ActionManager actionManager) {
            AnAction action;
            TreePath selectionPath = this.myTree.getSelectionPath();
            Object userObject = null;
            if (selectionPath != null && (userObject = ((DefaultMutableTreeNode)selectionPath.getLastPathComponent()).getUserObject()) instanceof String && (action = actionManager.getAction((String)userObject)) != null && action.getTemplatePresentation() != null && action.getTemplatePresentation().getIcon() != null) {
                this.mySetIconButton.setEnabled(!action.isDefaultIcon());
                return;
            }
            this.mySetIconButton.setEnabled(this.myTextField.getText().length() != 0 && selectionPath != null && new DefaultMutableTreeNode(selectionPath).isLeaf() && !(userObject instanceof Separator));
        }

        @Nullable
        public Set<Object> getTreeSelectedActionIds() {
            TreePath[] paths = this.myTree.getSelectionPaths();
            if (paths == null) {
                return null;
            }
            HashSet<Object> actions = new HashSet<Object>();
            for (TreePath path : paths) {
                Object node = path.getLastPathComponent();
                if (!(node instanceof DefaultMutableTreeNode)) continue;
                DefaultMutableTreeNode defNode = (DefaultMutableTreeNode)node;
                Object userObject = defNode.getUserObject();
                actions.add(userObject);
            }
            return actions;
        }

        protected String getDimensionServiceKey() {
            return "#com.intellij.ide.ui.customization.CustomizableActionsPanel.FindAvailableActionsDialog";
        }
    }

    private class EditIconDialog
    extends DialogWrapper {
        private final DefaultMutableTreeNode myNode;
        protected TextFieldWithBrowseButton myTextField;

        protected EditIconDialog(DefaultMutableTreeNode node) {
            super(false);
            this.setTitle(IdeBundle.message((String)"title.choose.action.icon.path", (Object[])new Object[0]));
            this.init();
            this.myNode = node;
            String actionId = CustomizableActionsPanel.getActionId(node);
            if (actionId != null) {
                this.myTextField.setText(CustomizableActionsPanel.this.mySelectedSchema.getIconPath(actionId));
            }
        }

        protected JComponent createCenterPanel() {
            this.myTextField = CustomizableActionsPanel.createBrowseField();
            JPanel northPanel = new JPanel(new BorderLayout());
            northPanel.add((Component)this.myTextField, "North");
            return northPanel;
        }

        protected void doOKAction() {
            if (this.myNode != null) {
                if (this.myTextField.getText().length() > 0 && !new File(this.myTextField.getText()).exists()) {
                    Messages.showErrorDialog((Component)CustomizableActionsPanel.this.myPanel, (String)IdeBundle.message((String)"error.file.not.found.message", (Object[])new Object[]{this.myTextField.getText()}));
                    return;
                }
                CustomizableActionsPanel.this.doSetIcon(this.myNode, this.myTextField.getText());
                Object userObject = this.myNode.getUserObject();
                if (userObject instanceof Pair) {
                    String actionId = (String)((Pair)userObject).first;
                    AnAction action = ActionManager.getInstance().getAction(actionId);
                    Icon icon = (Icon)((Pair)userObject).second;
                    action.getTemplatePresentation().setIcon(icon);
                    action.setDefaultIcon(icon == null);
                    CustomizableActionsPanel.this.editToolbarIcon(actionId, this.myNode);
                }
                CustomizableActionsPanel.this.myActionsTree.repaint();
            }
            CustomizableActionsPanel.setCustomizationSchemaForCurrentProjects();
            super.doOKAction();
        }
    }

    private static class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private MyTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof DefaultMutableTreeNode) {
                Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
                Icon icon = null;
                if (userObject instanceof Group) {
                    Group group = (Group)userObject;
                    String name = group.getName();
                    this.setText(name != null ? name : group.getId());
                    Icon icon2 = icon = expanded ? group.getOpenIcon() : group.getIcon();
                    if (icon == null) {
                        icon = expanded ? this.getOpenIcon() : this.getClosedIcon();
                    }
                } else if (userObject instanceof String) {
                    Icon actionIcon;
                    String actionId = (String)userObject;
                    AnAction action = ActionManager.getInstance().getAction(actionId);
                    this.setText(action != null ? action.getTemplatePresentation().getText() : actionId);
                    if (action != null && (actionIcon = action.getTemplatePresentation().getIcon()) != null) {
                        icon = actionIcon;
                    }
                } else if (userObject instanceof Pair) {
                    String actionId = (String)((Pair)userObject).first;
                    AnAction action = ActionManager.getInstance().getAction(actionId);
                    this.setText(action != null ? action.getTemplatePresentation().getText() : actionId);
                    icon = (Icon)((Pair)userObject).second;
                } else if (userObject instanceof Separator) {
                    this.setText("-------------");
                } else if (userObject instanceof QuickList) {
                    this.setText(((QuickList)userObject).getDisplayName());
                    icon = QUICK_LIST_ICON;
                } else {
                    throw new IllegalArgumentException("unknown userObject: " + userObject);
                }
                this.setIcon(ActionsTree.getEvenIcon(icon));
                if (sel) {
                    this.setForeground(UIUtil.getTreeSelectionForeground());
                } else {
                    this.setForeground(UIUtil.getTreeForeground());
                }
            }
            return this;
        }
    }
}

