/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.newStructureView;

import com.intellij.ide.structureView.FileEditorPositionListener;
import com.intellij.ide.structureView.ModelListener;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.newStructureView.TreeActionsOwner;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.ide.util.treeView.smartTree.TreeAction;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class TreeModelWrapper
implements StructureViewModel {
    private final StructureViewModel myModel;
    private final TreeActionsOwner myStructureView;

    public TreeModelWrapper(StructureViewModel model, TreeActionsOwner structureView) {
        this.myModel = model;
        this.myStructureView = structureView;
    }

    @NotNull
    public StructureViewTreeElement getRoot() {
        StructureViewTreeElement structureViewTreeElement = this.myModel.getRoot();
        if (structureViewTreeElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/structureView/newStructureView/TreeModelWrapper.getRoot must not return null");
        }
        return structureViewTreeElement;
    }

    @NotNull
    public Grouper[] getGroupers() {
        ArrayList<TreeAction> filtered = this.filterActive((TreeAction[])this.myModel.getGroupers());
        Grouper[] grouperArray = filtered.toArray(new Grouper[filtered.size()]);
        if (grouperArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/structureView/newStructureView/TreeModelWrapper.getGroupers must not return null");
        }
        return grouperArray;
    }

    private ArrayList<TreeAction> filterActive(TreeAction[] actions) {
        ArrayList<TreeAction> filtered = new ArrayList<TreeAction>();
        for (TreeAction action : actions) {
            if ((!(action instanceof Sorter) || ((Sorter)action).isVisible()) && !this.myStructureView.isActionActive(action.getName())) continue;
            filtered.add(action);
        }
        return filtered;
    }

    @NotNull
    public Sorter[] getSorters() {
        ArrayList<TreeAction> filtered = this.filterActive((TreeAction[])this.myModel.getSorters());
        Sorter[] sorterArray = filtered.toArray(new Sorter[filtered.size()]);
        if (sorterArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/structureView/newStructureView/TreeModelWrapper.getSorters must not return null");
        }
        return sorterArray;
    }

    @NotNull
    public Filter[] getFilters() {
        ArrayList<TreeAction> filtered = this.filterActive((TreeAction[])this.myModel.getFilters());
        Filter[] filterArray = filtered.toArray(new Filter[filtered.size()]);
        if (filterArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/structureView/newStructureView/TreeModelWrapper.getFilters must not return null");
        }
        return filterArray;
    }

    public Object getCurrentEditorElement() {
        return this.myModel.getCurrentEditorElement();
    }

    public static boolean isActive(TreeAction action, TreeActionsOwner actionsOwner) {
        if (TreeModelWrapper.shouldRevert(action)) {
            return !actionsOwner.isActionActive(action.getName());
        }
        if (action instanceof Sorter && !((Sorter)action).isVisible()) {
            return true;
        }
        return actionsOwner.isActionActive(action.getName());
    }

    public static boolean shouldRevert(TreeAction action) {
        return action instanceof Filter && ((Filter)action).isReverted();
    }

    public void addEditorPositionListener(FileEditorPositionListener listener) {
        this.myModel.addEditorPositionListener(listener);
    }

    public void removeEditorPositionListener(FileEditorPositionListener listener) {
        this.myModel.removeEditorPositionListener(listener);
    }

    public void dispose() {
        this.myModel.dispose();
    }

    public boolean shouldEnterElement(Object element) {
        return false;
    }

    public void addModelListener(ModelListener modelListener) {
        this.myModel.addModelListener(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.myModel.removeModelListener(modelListener);
    }

    public StructureViewModel getModel() {
        return this.myModel;
    }
}

