/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scopeView;

import com.intellij.ProjectTopics;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.CopyPasteDelegator;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewNodeDecorator;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.scopeView.ScopeTreeStructureExpander;
import com.intellij.ide.scopeView.nodes.BasePsiNode;
import com.intellij.ide.util.DeleteHandler;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ui.configuration.actions.ModuleDeleteProvider;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.packageDependencies.DefaultScopesProvider;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.packageDependencies.ui.DependenciesPanel;
import com.intellij.packageDependencies.ui.DependencyNodeComparator;
import com.intellij.packageDependencies.ui.DirectoryNode;
import com.intellij.packageDependencies.ui.FileNode;
import com.intellij.packageDependencies.ui.FileTreeModelBuilder;
import com.intellij.packageDependencies.ui.Marker;
import com.intellij.packageDependencies.ui.ModuleGroupNode;
import com.intellij.packageDependencies.ui.ModuleNode;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.packageDependencies.ui.PackageTreeExpansionMonitor;
import com.intellij.packageDependencies.ui.TreeExpansionMonitor;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.TreeToolTipHandler;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.Function;
import com.intellij.util.containers.HashSet;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopeTreeViewPanel
extends JPanel
implements JDOMExternalizable,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.ide.scopeView.ScopeTreeViewPanel");
    private final IdeView myIdeView = new MyIdeView();
    private final MyPsiTreeChangeAdapter myPsiTreeChangeAdapter = new MyPsiTreeChangeAdapter();
    private final DnDAwareTree myTree = new DnDAwareTree();
    private final Project myProject;
    private FileTreeModelBuilder myBuilder;
    public String CURRENT_SCOPE_NAME;
    private TreeExpansionMonitor myTreeExpansionMonitor;
    private CopyPasteDelegator myCopyPasteDelegator;
    private final MyDeletePSIElementProvider myDeletePSIElementProvider = new MyDeletePSIElementProvider();
    private final ModuleDeleteProvider myDeleteModuleProvider = new ModuleDeleteProvider();
    private final DependencyValidationManager myDependencyValidationManager;
    private final WolfTheProblemSolver.ProblemListener myProblemListener = new MyProblemListener();
    private final MergingUpdateQueue myUpdateQueue = new MergingUpdateQueue("ScopeViewUpdate", 300, this.myTree.isShowing(), (JComponent)((Object)this.myTree));

    public ScopeTreeViewPanel(Project project) {
        super(new BorderLayout());
        this.myUpdateQueue.setPassThrough(false);
        this.myProject = project;
        this.initTree();
        this.add((Component)new JScrollPane((Component)((Object)this.myTree)), "Center");
        this.myDependencyValidationManager = DependencyValidationManager.getInstance((Project)this.myProject);
        UiNotifyConnector uiNotifyConnector = new UiNotifyConnector((Component)((Object)this.myTree), (Activatable)this.myUpdateQueue);
        Disposer.register((Disposable)this, (Disposable)this.myUpdateQueue);
        Disposer.register((Disposable)this, (Disposable)uiNotifyConnector);
    }

    public void initListeners() {
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new MyModuleRootListener());
        PsiManager.getInstance((Project)this.myProject).addPsiTreeChangeListener((PsiTreeChangeListener)this.myPsiTreeChangeAdapter);
        WolfTheProblemSolver.getInstance((Project)this.myProject).addProblemListener(this.myProblemListener);
    }

    public void dispose() {
        FileTreeModelBuilder.clearCaches(this.myProject);
        PsiManager.getInstance((Project)this.myProject).removePsiTreeChangeListener((PsiTreeChangeListener)this.myPsiTreeChangeAdapter);
        WolfTheProblemSolver.getInstance((Project)this.myProject).removeProblemListener(this.myProblemListener);
    }

    public void selectNode(final PsiElement element, final PsiFile file, final boolean requestFocus) {
        this.myUpdateQueue.queue(new Update("Select"){

            public void run() {
                if (ScopeTreeViewPanel.this.myProject.isDisposed()) {
                    return;
                }
                PackageDependenciesNode node = ScopeTreeViewPanel.this.myBuilder.findNode(file, element);
                if (node != null && node.getPsiElement() != element) {
                    TreePath path = new TreePath(node.getPath());
                    if (ScopeTreeViewPanel.this.myTree.isCollapsed(path)) {
                        ScopeTreeViewPanel.this.myTree.expandPath(path);
                        ScopeTreeViewPanel.this.myTree.makeVisible(path);
                    }
                }
                if ((node = ScopeTreeViewPanel.this.myBuilder.findNode(file, element)) != null) {
                    TreeUtil.selectPath((JTree)((Object)ScopeTreeViewPanel.this.myTree), (TreePath)new TreePath(node.getPath()));
                    if (requestFocus) {
                        ScopeTreeViewPanel.this.myTree.requestFocus();
                    }
                }
            }
        });
    }

    public void selectScope(NamedScope scope) {
        this.refreshScope(scope, true);
        if (scope != DefaultScopesProvider.getAllScope()) {
            this.CURRENT_SCOPE_NAME = scope.getName();
        }
    }

    public JPanel getPanel() {
        return this;
    }

    private void initTree() {
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new MyTreeCellRenderer()));
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        UIUtil.setLineStyleAngled((JTree)((Object)this.myTree));
        TreeToolTipHandler.install((JTree)((Object)this.myTree));
        TreeUtil.installActions((JTree)((Object)this.myTree));
        EditSourceOnDoubleClickHandler.install((JTree)((Object)this.myTree));
        new TreeSpeedSearch((JTree)((Object)this.myTree));
        this.myCopyPasteDelegator = new CopyPasteDelegator(this.myProject, this){

            @Override
            @NotNull
            protected PsiElement[] getSelectedElements() {
                PsiElement[] psiElementArray = ScopeTreeViewPanel.this.getSelectedPsiElements();
                if (psiElementArray == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/ide/scopeView/ScopeTreeViewPanel$2.getSelectedElements must not return null");
                }
                return psiElementArray;
            }
        };
        this.myTreeExpansionMonitor = PackageTreeExpansionMonitor.install((JTree)((Object)this.myTree), this.myProject);
        for (ScopeTreeStructureExpander expander : (ScopeTreeStructureExpander[])Extensions.getExtensions(ScopeTreeStructureExpander.EP_NAME, (AreaInstance)this.myProject)) {
            this.myTree.addTreeWillExpandListener(expander);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private PsiElement[] getSelectedPsiElements() {
        PsiElement[] psiElementArray;
        TreePath[] treePaths = this.myTree.getSelectionPaths();
        if (treePaths != null) {
            HashSet result = new HashSet();
            for (TreePath path : treePaths) {
                PackageDependenciesNode node = (PackageDependenciesNode)path.getLastPathComponent();
                PsiElement psiElement = node.getPsiElement();
                if (psiElement == null || !psiElement.isValid()) continue;
                result.add(psiElement);
            }
            psiElementArray = result.toArray(new PsiElement[result.size()]);
            if (psiElementArray == null) throw new IllegalStateException("@NotNull method com/intellij/ide/scopeView/ScopeTreeViewPanel.getSelectedPsiElements must not return null");
            return psiElementArray;
        }
        psiElementArray = PsiElement.EMPTY_ARRAY;
        if (PsiElement.EMPTY_ARRAY != null) return psiElementArray;
        throw new IllegalStateException("@NotNull method com/intellij/ide/scopeView/ScopeTreeViewPanel.getSelectedPsiElements must not return null");
    }

    private void refreshScope(@Nullable NamedScope scope, boolean showProgress) {
        FileTreeModelBuilder.clearCaches(this.myProject);
        this.myTreeExpansionMonitor.freeze();
        if (scope == null || scope.getValue() == null) {
            scope = DefaultScopesProvider.getAllScope();
        }
        LOG.assertTrue(scope != null);
        final NamedScopesHolder holder = NamedScopesHolder.getHolder((Project)this.myProject, (String)scope.getName(), (NamedScopesHolder)this.myDependencyValidationManager);
        final PackageSet packageSet = scope.getValue();
        DependenciesPanel.DependencyPanelSettings settings = new DependenciesPanel.DependencyPanelSettings();
        settings.UI_FILTER_LEGALS = true;
        settings.UI_GROUP_BY_SCOPE_TYPE = false;
        settings.UI_SHOW_FILES = true;
        ProjectView projectView = ProjectView.getInstance(this.myProject);
        settings.UI_FLATTEN_PACKAGES = projectView.isFlattenPackages("Scope");
        settings.UI_COMPACT_EMPTY_MIDDLE_PACKAGES = projectView.isHideEmptyMiddlePackages("Scope");
        this.myBuilder = new FileTreeModelBuilder(this.myProject, new Marker(){

            @Override
            public boolean isMarked(PsiFile file) {
                return packageSet != null && packageSet.contains(file, holder);
            }
        }, settings);
        this.myTree.setModel(this.myBuilder.build(this.myProject, showProgress, projectView.isSortByType("Scope")));
        ((DefaultTreeModel)this.myTree.getModel()).reload();
        this.myTreeExpansionMonitor.restore();
        FileTreeModelBuilder.clearCaches(this.myProject);
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
    }

    private NamedScope getCurrentScope() {
        NamedScope scope = NamedScopesHolder.getScope((Project)this.myProject, (String)this.CURRENT_SCOPE_NAME);
        if (scope == null) {
            scope = DefaultScopesProvider.getAllScope();
        }
        LOG.assertTrue(scope != null);
        return scope;
    }

    @Nullable
    public Object getData(String dataId) {
        PackageDependenciesNode node;
        TreePath selectionPath;
        if (LangDataKeys.MODULE_CONTEXT.is(dataId) && (selectionPath = this.myTree.getSelectionPath()) != null && (node = (PackageDependenciesNode)selectionPath.getLastPathComponent()) instanceof ModuleNode) {
            return ((ModuleNode)node).getModule();
        }
        if (LangDataKeys.PSI_ELEMENT.is(dataId) && (selectionPath = this.myTree.getSelectionPath()) != null) {
            node = (PackageDependenciesNode)selectionPath.getLastPathComponent();
            return node != null && node.isValid() ? node.getPsiElement() : null;
        }
        TreePath[] treePaths = this.myTree.getSelectionPaths();
        if (treePaths != null && LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            HashSet psiElements = new HashSet();
            for (TreePath treePath : treePaths) {
                PsiElement psiElement;
                PackageDependenciesNode node2 = (PackageDependenciesNode)treePath.getLastPathComponent();
                if (!node2.isValid() || (psiElement = node2.getPsiElement()) == null) continue;
                psiElements.add(psiElement);
            }
            return psiElements.isEmpty() ? null : psiElements.toArray(new PsiElement[psiElements.size()]);
        }
        if (LangDataKeys.IDE_VIEW.is(dataId)) {
            return this.myIdeView;
        }
        if (PlatformDataKeys.CUT_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator.getCutProvider();
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator.getCopyProvider();
        }
        if (PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator.getPasteProvider();
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            if (this.getSelectedModules() != null) {
                return this.myDeleteModuleProvider;
            }
            return this.myDeletePSIElementProvider;
        }
        return null;
    }

    @Nullable
    private Module[] getSelectedModules() {
        TreePath[] treePaths = this.myTree.getSelectionPaths();
        if (treePaths != null) {
            HashSet result = new HashSet();
            for (TreePath path : treePaths) {
                PackageDependenciesNode node = (PackageDependenciesNode)path.getLastPathComponent();
                if (node instanceof ModuleNode) {
                    result.add(((ModuleNode)node).getModule());
                    continue;
                }
                if (!(node instanceof ModuleGroupNode)) continue;
                ModuleGroupNode groupNode = (ModuleGroupNode)node;
                ModuleGroup moduleGroup = groupNode.getModuleGroup();
                result.addAll(moduleGroup.modulesInGroup(this.myProject, true));
            }
            return result.isEmpty() ? null : result.toArray(new Module[result.size()]);
        }
        return null;
    }

    private void reload(DefaultMutableTreeNode rootToReload) {
        DefaultTreeModel treeModel = (DefaultTreeModel)this.myTree.getModel();
        if (rootToReload != null) {
            TreeUtil.sort((DefaultMutableTreeNode)rootToReload, (Comparator)this.getNodeComparator());
            this.collapseExpand(rootToReload);
        } else {
            TreeUtil.sort((DefaultTreeModel)treeModel, (Comparator)this.getNodeComparator());
            treeModel.reload();
        }
    }

    private DependencyNodeComparator getNodeComparator() {
        return new DependencyNodeComparator(ProjectView.getInstance(this.myProject).isSortByType("Scope"));
    }

    public void setSortByType() {
        this.myTreeExpansionMonitor.freeze();
        this.reload(null);
        this.myTreeExpansionMonitor.restore();
    }

    private void collapseExpand(DefaultMutableTreeNode node) {
        if (node == null) {
            return;
        }
        ((DefaultTreeModel)this.myTree.getModel()).reload(node);
        TreePath path = new TreePath(node.getPath());
        if (!this.myTree.isCollapsed(path)) {
            this.myTree.collapsePath(path);
            this.myTree.expandPath(path);
            TreeUtil.sort((DefaultMutableTreeNode)node, (Comparator)this.getNodeComparator());
        }
    }

    public DnDAwareTree getTree() {
        return this.myTree;
    }

    private class MyProblemListener
    extends WolfTheProblemSolver.ProblemListener {
        private MyProblemListener() {
        }

        public void problemsAppeared(VirtualFile file) {
            this.queueUpdate(file, new Function<PsiFile, DefaultMutableTreeNode>(){

                @Nullable
                public DefaultMutableTreeNode fun(PsiFile psiFile) {
                    return ScopeTreeViewPanel.this.myBuilder.addFileNode(psiFile);
                }
            });
        }

        public void problemsDisappeared(VirtualFile file) {
            this.queueUpdate(file, new Function<PsiFile, DefaultMutableTreeNode>(){

                @Nullable
                public DefaultMutableTreeNode fun(PsiFile psiFile) {
                    return ScopeTreeViewPanel.this.myBuilder.removeNode((PsiElement)psiFile, psiFile.getContainingDirectory());
                }
            });
        }

        private void queueUpdate(final VirtualFile fileToRefresh, final Function<PsiFile, DefaultMutableTreeNode> rootToReloadGetter) {
            AbstractProjectViewPane pane = ProjectView.getInstance(ScopeTreeViewPanel.this.myProject).getCurrentProjectViewPane();
            if (pane == null || !"Scope".equals(pane.getId()) || !DefaultScopesProvider.getInstance(ScopeTreeViewPanel.this.myProject).getProblemsScope().getName().equals(pane.getSubId())) {
                return;
            }
            ScopeTreeViewPanel.this.myUpdateQueue.queue(new Update(fileToRefresh){

                public void run() {
                    if (ScopeTreeViewPanel.this.myProject.isDisposed() || !fileToRefresh.isValid()) {
                        return;
                    }
                    ScopeTreeViewPanel.this.myTreeExpansionMonitor.freeze();
                    PsiFile psiFile = PsiManager.getInstance((Project)ScopeTreeViewPanel.this.myProject).findFile(fileToRefresh);
                    if (psiFile != null) {
                        ScopeTreeViewPanel.this.reload((DefaultMutableTreeNode)rootToReloadGetter.fun((Object)psiFile));
                    }
                    ScopeTreeViewPanel.this.myTreeExpansionMonitor.restore();
                }

                public boolean isExpired() {
                    return !ScopeTreeViewPanel.this.myTree.isShowing();
                }
            });
        }
    }

    private final class MyDeletePSIElementProvider
    implements DeleteProvider {
        private MyDeletePSIElementProvider() {
        }

        public boolean canDeleteElement(DataContext dataContext) {
            PsiElement[] elements = ScopeTreeViewPanel.this.getSelectedPsiElements();
            return DeleteHandler.shouldEnableDeleteAction(elements);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteElement(DataContext dataContext) {
            List<PsiElement> allElements = Arrays.asList(ScopeTreeViewPanel.this.getSelectedPsiElements());
            ArrayList<PsiElement> validElements = new ArrayList<PsiElement>();
            for (PsiElement psiElement : allElements) {
                if (psiElement == null || !psiElement.isValid()) continue;
                validElements.add(psiElement);
            }
            PsiElement[] elements = validElements.toArray(new PsiElement[validElements.size()]);
            LocalHistoryAction a = LocalHistory.startAction((Project)ScopeTreeViewPanel.this.myProject, (String)IdeBundle.message((String)"progress.deleting", (Object[])new Object[0]));
            try {
                DeleteHandler.deletePsiElement(elements, ScopeTreeViewPanel.this.myProject);
            }
            finally {
                a.finish();
            }
        }
    }

    private class MyIdeView
    implements IdeView {
        private MyIdeView() {
        }

        public void selectElement(PsiElement element) {
            if (element != null) {
                boolean isDirectory = element instanceof PsiDirectory;
                if (!isDirectory) {
                    Editor editor;
                    PsiFile psiFile = element.getContainingFile();
                    PackageSet packageSet = ScopeTreeViewPanel.this.getCurrentScope().getValue();
                    if (packageSet == null) {
                        return;
                    }
                    if (psiFile != null) {
                        ProjectView projectView = ProjectView.getInstance(ScopeTreeViewPanel.this.myProject);
                        if (!packageSet.contains(psiFile, NamedScopesHolder.getHolder((Project)ScopeTreeViewPanel.this.myProject, (String)ScopeTreeViewPanel.this.CURRENT_SCOPE_NAME, (NamedScopesHolder)ScopeTreeViewPanel.this.myDependencyValidationManager))) {
                            projectView.changeView("ProjectPane");
                        }
                        projectView.select(psiFile, psiFile.getVirtualFile(), false);
                    }
                    if ((editor = EditorHelper.openInEditor(element)) != null) {
                        ToolWindowManager.getInstance((Project)ScopeTreeViewPanel.this.myProject).activateEditorComponent();
                    }
                } else {
                    ((PsiDirectory)element).navigate(true);
                }
            }
        }

        @Nullable
        private PsiDirectory getDirectory() {
            TreePath[] selectedPaths = ScopeTreeViewPanel.this.myTree.getSelectionPaths();
            if (selectedPaths != null) {
                if (selectedPaths.length != 1) {
                    return null;
                }
                TreePath path = selectedPaths[0];
                PackageDependenciesNode node = (PackageDependenciesNode)path.getLastPathComponent();
                if (!node.isValid()) {
                    return null;
                }
                if (node instanceof DirectoryNode) {
                    DirectoryNode directoryNode = (DirectoryNode)node;
                    while (directoryNode.getCompactedDirNode() != null) {
                        directoryNode = directoryNode.getCompactedDirNode();
                        LOG.assertTrue(directoryNode != null);
                    }
                    return (PsiDirectory)directoryNode.getPsiElement();
                }
                if (node instanceof BasePsiNode) {
                    PsiElement psiElement = node.getPsiElement();
                    LOG.assertTrue(psiElement != null);
                    PsiFile psiFile = psiElement.getContainingFile();
                    LOG.assertTrue(psiFile != null);
                    return psiFile.getContainingDirectory();
                }
                if (node instanceof FileNode) {
                    PsiFile psiFile = (PsiFile)node.getPsiElement();
                    LOG.assertTrue(psiFile != null);
                    return psiFile.getContainingDirectory();
                }
            }
            return null;
        }

        public PsiDirectory[] getDirectories() {
            PsiDirectory[] psiDirectoryArray;
            PsiDirectory directory = this.getDirectory();
            if (directory == null) {
                psiDirectoryArray = PsiDirectory.EMPTY_ARRAY;
            } else {
                PsiDirectory[] psiDirectoryArray2 = new PsiDirectory[1];
                psiDirectoryArray = psiDirectoryArray2;
                psiDirectoryArray2[0] = directory;
            }
            return psiDirectoryArray;
        }

        @Nullable
        public PsiDirectory getOrChooseDirectory() {
            return DirectoryChooserUtil.getOrChooseDirectory(this);
        }
    }

    private class MyModuleRootListener
    implements ModuleRootListener {
        private MyModuleRootListener() {
        }

        public void beforeRootsChange(ModuleRootEvent event) {
        }

        public void rootsChanged(ModuleRootEvent event) {
            ScopeTreeViewPanel.this.myUpdateQueue.cancelAllUpdates();
            ScopeTreeViewPanel.this.myUpdateQueue.queue(new Update("RootsChanged"){

                public void run() {
                    ScopeTreeViewPanel.this.refreshScope(ScopeTreeViewPanel.this.getCurrentScope(), false);
                }

                public boolean isExpired() {
                    return !ScopeTreeViewPanel.this.myTree.isShowing();
                }
            });
        }
    }

    private class MyPsiTreeChangeAdapter
    extends PsiTreeChangeAdapter {
        private MyPsiTreeChangeAdapter() {
        }

        public void childAdded(PsiTreeChangeEvent event) {
            PsiElement element = event.getParent();
            final PsiElement child = event.getChild();
            if (child == null) {
                return;
            }
            if (element.getContainingFile() == null) {
                this.queueUpdate(new Runnable(){

                    @Override
                    public void run() {
                        if (!child.isValid()) {
                            return;
                        }
                        MyPsiTreeChangeAdapter.this.processNodeCreation(child);
                    }
                }, false);
            }
        }

        private void processNodeCreation(PsiElement psiElement) {
            if (psiElement instanceof PsiFile) {
                ScopeTreeViewPanel.this.reload(ScopeTreeViewPanel.this.myBuilder.addFileNode((PsiFile)psiElement));
            } else if (psiElement instanceof PsiDirectory) {
                PsiElement[] children;
                for (PsiElement child : children = psiElement.getChildren()) {
                    this.processNodeCreation(child);
                }
            }
        }

        public void beforeChildRemoval(PsiTreeChangeEvent event) {
            final PsiElement child = event.getChild();
            final PsiElement parent = event.getParent();
            if (parent instanceof PsiDirectory && (child instanceof PsiFile || child instanceof PsiDirectory)) {
                this.queueUpdate(new Runnable(){

                    @Override
                    public void run() {
                        ScopeTreeViewPanel.this.collapseExpand(ScopeTreeViewPanel.this.myBuilder.removeNode(child, (PsiDirectory)parent));
                    }
                }, true);
            }
        }

        public void childMoved(PsiTreeChangeEvent event) {
            final PsiElement oldParent = event.getOldParent();
            PsiElement newParent = event.getNewParent();
            final PsiElement child = event.getChild();
            if (oldParent instanceof PsiDirectory && newParent instanceof PsiDirectory && child instanceof PsiFile) {
                final PsiFile file = (PsiFile)child;
                this.queueUpdate(new Runnable(){

                    @Override
                    public void run() {
                        ScopeTreeViewPanel.this.collapseExpand(ScopeTreeViewPanel.this.myBuilder.removeNode(child, (PsiDirectory)oldParent));
                        VirtualFile virtualFile = file.getVirtualFile();
                        if (virtualFile != null) {
                            PsiFile newFile;
                            PsiFile psiFile = newFile = file.isValid() ? file : PsiManager.getInstance((Project)ScopeTreeViewPanel.this.myProject).findFile(virtualFile);
                            if (newFile != null) {
                                ScopeTreeViewPanel.this.collapseExpand(ScopeTreeViewPanel.this.myBuilder.addFileNode(newFile));
                            }
                        }
                    }
                }, true);
            }
        }

        public void childrenChanged(PsiTreeChangeEvent event) {
            PsiElement parent = event.getParent();
            final PsiFile file = parent.getContainingFile();
            if (file != null && file.getFileType() == StdFileTypes.JAVA) {
                if (!file.getViewProvider().isPhysical()) {
                    return;
                }
                this.queueUpdate(new Runnable(){

                    @Override
                    public void run() {
                        if (file.isValid()) {
                            ScopeTreeViewPanel.this.collapseExpand(ScopeTreeViewPanel.this.myBuilder.getFileParentNode(file));
                        }
                    }
                }, false);
            }
        }

        public final void propertyChanged(PsiTreeChangeEvent event) {
            String propertyName = event.getPropertyName();
            final PsiElement element = event.getElement();
            if (element != null) {
                final NamedScope scope = ScopeTreeViewPanel.this.getCurrentScope();
                if (propertyName.equals("fileName") || propertyName.equals("propFileTypes")) {
                    this.queueUpdate(new Runnable(){

                        @Override
                        public void run() {
                            if (element.isValid()) {
                                MyPsiTreeChangeAdapter.this.processRenamed(scope, element.getContainingFile());
                            }
                        }
                    }, false);
                } else if (propertyName.equals("directoryName")) {
                    this.queueRefreshScope(scope);
                }
            }
        }

        public void childReplaced(PsiTreeChangeEvent event) {
            final NamedScope scope = ScopeTreeViewPanel.this.getCurrentScope();
            PsiElement element = event.getNewChild();
            final PsiFile psiFile = event.getFile();
            if (psiFile != null) {
                if (psiFile.getLanguage() == psiFile.getViewProvider().getBaseLanguage()) {
                    this.queueUpdate(new Runnable(){

                        @Override
                        public void run() {
                            MyPsiTreeChangeAdapter.this.processRenamed(scope, psiFile);
                        }
                    }, false);
                }
            } else if (element instanceof PsiDirectory && element.isValid()) {
                this.queueRefreshScope(scope);
            }
        }

        private void queueRefreshScope(final NamedScope scope) {
            ScopeTreeViewPanel.this.myUpdateQueue.cancelAllUpdates();
            this.queueUpdate(new Runnable(){

                @Override
                public void run() {
                    ScopeTreeViewPanel.this.refreshScope(scope, true);
                }
            }, false);
        }

        private void processRenamed(NamedScope scope, PsiFile file) {
            if (!file.isValid() || !file.getViewProvider().isPhysical()) {
                return;
            }
            PackageSet packageSet = scope.getValue();
            if (packageSet == null) {
                return;
            }
            if (packageSet.contains(file, NamedScopesHolder.getHolder((Project)ScopeTreeViewPanel.this.myProject, (String)scope.getName(), (NamedScopesHolder)ScopeTreeViewPanel.this.myDependencyValidationManager))) {
                ScopeTreeViewPanel.this.reload(ScopeTreeViewPanel.this.myBuilder.getFileParentNode(file));
            } else {
                ScopeTreeViewPanel.this.reload(ScopeTreeViewPanel.this.myBuilder.removeNode((PsiElement)file, file.getParent()));
            }
        }

        private void queueUpdate(final Runnable request, boolean updateImmediately) {
            final Runnable wrapped = new Runnable(){

                @Override
                public void run() {
                    if (ScopeTreeViewPanel.this.myProject.isDisposed()) {
                        return;
                    }
                    ScopeTreeViewPanel.this.myTreeExpansionMonitor.freeze();
                    request.run();
                    ScopeTreeViewPanel.this.myTreeExpansionMonitor.restore();
                }
            };
            if (updateImmediately && ScopeTreeViewPanel.this.myTree.isShowing()) {
                ScopeTreeViewPanel.this.myUpdateQueue.run(new Update(request){

                    public void run() {
                        wrapped.run();
                    }
                });
            } else {
                ScopeTreeViewPanel.this.myUpdateQueue.queue(new Update(request){

                    public void run() {
                        wrapped.run();
                    }

                    public boolean isExpired() {
                        return !ScopeTreeViewPanel.this.myTree.isShowing();
                    }
                });
            }
        }
    }

    private class MyTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private MyTreeCellRenderer() {
        }

        public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof PackageDependenciesNode) {
                String locationString;
                PackageDependenciesNode node = (PackageDependenciesNode)value;
                try {
                    if (expanded) {
                        this.setIcon(node.getOpenIcon());
                    } else {
                        this.setIcon(node.getClosedIcon());
                    }
                }
                catch (IndexNotReadyException ignore) {
                    // empty catch block
                }
                SimpleTextAttributes regularAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                TextAttributes textAttributes = regularAttributes.toTextAttributes();
                if (node instanceof BasePsiNode && ((BasePsiNode)node).isDeprecated()) {
                    textAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.DEPRECATED_ATTRIBUTES).clone();
                }
                PsiElement psiElement = node.getPsiElement();
                textAttributes.setForegroundColor(CopyPasteManager.getInstance().isCutElement((Object)psiElement) ? CopyPasteManager.CUT_COLOR : node.getStatus().getColor());
                this.append(node.toString(), SimpleTextAttributes.fromTextAttributes((TextAttributes)textAttributes));
                String oldToString = this.toString();
                for (ProjectViewNodeDecorator decorator : (ProjectViewNodeDecorator[])Extensions.getExtensions(ProjectViewNodeDecorator.EP_NAME, (AreaInstance)ScopeTreeViewPanel.this.myProject)) {
                    decorator.decorate(node, this);
                }
                if (this.toString().equals(oldToString) && (locationString = node.getComment()) != null && locationString.length() > 0) {
                    this.append(" (" + locationString + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            }
        }
    }
}

