/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.nodes.AbstractProjectNode;
import com.intellij.ide.projectView.impl.nodes.ExternalLibrariesNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleGroupNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ProjectViewProjectNode
extends AbstractProjectNode {
    public ProjectViewProjectNode(Project project, ViewSettings viewSettings) {
        super(project, project, viewSettings);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        VirtualFile[] files;
        ArrayList<AbstractTreeNode> arrayList;
        List<VirtualFile> topLevelContentRoots = ProjectViewDirectoryHelper.getInstance(this.myProject).getTopLevelRoots();
        LinkedHashSet<Module> modules = new LinkedHashSet<Module>(topLevelContentRoots.size());
        for (VirtualFile root : topLevelContentRoots) {
            Module module = ModuleUtil.findModuleForFile((VirtualFile)root, (Project)this.myProject);
            if (module == null) continue;
            modules.add(module);
        }
        ArrayList<AbstractTreeNode> nodes = new ArrayList<AbstractTreeNode>();
        PsiManager psiManager = PsiManager.getInstance((Project)this.getProject());
        nodes.addAll(this.modulesAndGroups(modules.toArray(new Module[modules.size()])));
        VirtualFile baseDir = this.getProject().getBaseDir();
        if (baseDir == null) {
            arrayList = nodes;
            if (arrayList == null) throw new IllegalStateException("@NotNull method com/intellij/ide/projectView/impl/nodes/ProjectViewProjectNode.getChildren must not return null");
            return arrayList;
        }
        for (VirtualFile file : files = baseDir.getChildren()) {
            if (ModuleUtil.findModuleForFile((VirtualFile)file, (Project)this.getProject()) != null || file.isDirectory()) continue;
            nodes.add((AbstractTreeNode)new PsiFileNode(this.getProject(), psiManager.findFile(file), this.getSettings()));
        }
        if (this.getSettings().isShowLibraryContents()) {
            nodes.add((AbstractTreeNode)new ExternalLibrariesNode(this.getProject(), this.getSettings()));
        }
        if ((arrayList = nodes) != null) return arrayList;
        throw new IllegalStateException("@NotNull method com/intellij/ide/projectView/impl/nodes/ProjectViewProjectNode.getChildren must not return null");
    }

    private static List<VirtualFile> reduceRoots(List<VirtualFile> roots) {
        String userHome;
        if (roots.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            userHome = FileUtil.toSystemIndependentName((String)new File(SystemProperties.getUserHome()).getCanonicalPath());
        }
        catch (IOException e) {
            userHome = null;
        }
        Collections.sort(roots, new Comparator<VirtualFile>(){

            @Override
            public int compare(VirtualFile o1, VirtualFile o2) {
                return o1.getPath().compareTo(o2.getPath());
            }
        });
        Iterator<VirtualFile> it = roots.iterator();
        VirtualFile current = it.next();
        ArrayList<VirtualFile> reducedRoots = new ArrayList<VirtualFile>();
        while (it.hasNext()) {
            VirtualFile next = it.next();
            VirtualFile common = VfsUtil.getCommonAncestor((VirtualFile)current, (VirtualFile)next);
            if (common == null || common.getParent() == null || Comparing.equal((String)common.getPath(), (String)userHome)) {
                reducedRoots.add(current);
                current = next;
                continue;
            }
            current = common;
        }
        reducedRoots.add(current);
        return reducedRoots;
    }

    @Override
    protected AbstractTreeNode createModuleGroup(Module module) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        PsiDirectory psi;
        VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        if (roots.length == 1 && (psi = PsiManager.getInstance((Project)this.myProject).findDirectory(roots[0])) != null) {
            return ProjectViewProjectNode.createTreeNode(PsiDirectoryNode.class, (Project)this.myProject, (Object)psi, (ViewSettings)this.getSettings());
        }
        return ProjectViewProjectNode.createTreeNode(ProjectViewModuleNode.class, (Project)this.getProject(), (Object)module, (ViewSettings)this.getSettings());
    }

    @Override
    protected AbstractTreeNode createModuleGroupNode(ModuleGroup moduleGroup) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        return ProjectViewProjectNode.createTreeNode(ProjectViewModuleGroupNode.class, (Project)this.getProject(), (Object)moduleGroup, (ViewSettings)this.getSettings());
    }
}

