/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.lang.TitledHandler;
import com.intellij.refactoring.rename.RenameHandler;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class RenameModuleHandler
implements RenameHandler,
TitledHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.projectView.actions.RenameModuleHandler");

    public boolean isAvailableOnDataContext(DataContext dataContext) {
        Module module = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
        return module != null;
    }

    public boolean isRenaming(DataContext dataContext) {
        return this.isAvailableOnDataContext(dataContext);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/projectView/impl/RenameModuleHandler.invoke must not be null");
        }
        LOG.assertTrue(false);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, @NotNull DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/projectView/impl/RenameModuleHandler.invoke must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/projectView/impl/RenameModuleHandler.invoke must not be null");
        }
        if (dataContext == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/ide/projectView/impl/RenameModuleHandler.invoke must not be null");
        }
        Module module = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
        LOG.assertTrue(module != null);
        Messages.showInputDialog((Project)project, (String)IdeBundle.message((String)"prompt.enter.new.module.name", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)module.getName(), (InputValidator)new MyInputValidator(project, module));
    }

    public String getActionTitle() {
        return RefactoringBundle.message((String)"rename.module.title");
    }

    private static class MyInputValidator
    implements InputValidator {
        private final Project myProject;
        private final Module myModule;

        public MyInputValidator(Project project, Module module) {
            this.myProject = project;
            this.myModule = module;
        }

        public boolean checkInput(String inputString) {
            return inputString != null && inputString.length() > 0;
        }

        public boolean canClose(String inputString) {
            final ModifiableModuleModel modifiableModel = ModuleManager.getInstance((Project)this.myProject).getModifiableModel();
            try {
                modifiableModel.renameModule(this.myModule, inputString);
            }
            catch (ModuleWithNameAlreadyExists moduleWithNameAlreadyExists) {
                Messages.showErrorDialog((Project)this.myProject, (String)IdeBundle.message((String)"error.module.already.exists", (Object[])new Object[]{inputString}), (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0]));
                return false;
            }
            Ref success = Ref.create((Object)Boolean.TRUE);
            CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            modifiableModel.commit();
                        }
                    });
                }
            }, IdeBundle.message((String)"command.renaming.module", (Object[])new Object[]{this.myModule.getName()}), null);
            return (Boolean)success.get();
        }
    }
}

