/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ProjectTopics;
import com.intellij.ide.CopyPasteUtil;
import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarksListener;
import com.intellij.ide.projectView.BaseProjectTreeBuilder;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ProjectViewPsiTreeChangeListener;
import com.intellij.ide.projectView.impl.AbstractProjectTreeStructure;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class ProjectTreeBuilder
extends BaseProjectTreeBuilder {
    private final ProjectViewPsiTreeChangeListener myPsiTreeChangeListener;
    private final MyFileStatusListener myFileStatusListener;
    private final CopyPasteUtil.DefaultCopyPasteListener myCopyPasteListener;
    private final WolfTheProblemSolver.ProblemListener myProblemListener;

    public ProjectTreeBuilder(Project project, JTree tree, DefaultTreeModel treeModel, Comparator<NodeDescriptor> comparator, ProjectAbstractTreeStructureBase treeStructure) {
        super(project, tree, treeModel, treeStructure, comparator);
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)this);
        this.myPsiTreeChangeListener = this.createPsiTreeChangeListener(this.myProject);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void beforeRootsChange(ModuleRootEvent event) {
            }

            public void rootsChanged(ModuleRootEvent event) {
                ProjectTreeBuilder.this.getUpdater().addSubtreeToUpdate(ProjectTreeBuilder.this.getRootNode());
            }
        });
        connection.subscribe(BookmarksListener.TOPIC, (Object)new MyBookmarksListener());
        PsiManager.getInstance((Project)this.myProject).addPsiTreeChangeListener((PsiTreeChangeListener)this.myPsiTreeChangeListener);
        this.myFileStatusListener = new MyFileStatusListener();
        FileStatusManager.getInstance((Project)this.myProject).addFileStatusListener((FileStatusListener)this.myFileStatusListener);
        this.myCopyPasteListener = new CopyPasteUtil.DefaultCopyPasteListener(this.getUpdater());
        CopyPasteManager.getInstance().addContentChangedListener((CopyPasteManager.ContentChangedListener)this.myCopyPasteListener);
        this.myProblemListener = new MyProblemListener();
        WolfTheProblemSolver.getInstance((Project)project).addProblemListener(this.myProblemListener);
        this.setCanYieldUpdate(true);
        this.initRootNode();
    }

    public final void dispose() {
        super.dispose();
        PsiManager.getInstance((Project)this.myProject).removePsiTreeChangeListener((PsiTreeChangeListener)this.myPsiTreeChangeListener);
        FileStatusManager.getInstance((Project)this.myProject).removeFileStatusListener((FileStatusListener)this.myFileStatusListener);
        CopyPasteManager.getInstance().removeContentChangedListener((CopyPasteManager.ContentChangedListener)this.myCopyPasteListener);
        WolfTheProblemSolver.getInstance((Project)this.myProject).removeProblemListener(this.myProblemListener);
    }

    protected ProjectViewPsiTreeChangeListener createPsiTreeChangeListener(Project project) {
        return new ProjectTreeBuilderPsiListener(project);
    }

    private PsiElement findPsi(VirtualFile vFile) {
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        Object element = vFile.isDirectory() ? psiManager.findDirectory(vFile) : psiManager.findFile(vFile);
        return element;
    }

    private void updateNodesContaining(Collection<VirtualFile> filesToRefresh, DefaultMutableTreeNode rootNode) {
        if (!(rootNode.getUserObject() instanceof ProjectViewNode)) {
            return;
        }
        ProjectViewNode node = (ProjectViewNode)rootNode.getUserObject();
        Collection containingFiles = null;
        for (VirtualFile virtualFile : filesToRefresh) {
            if (!virtualFile.isValid()) {
                this.addSubtreeToUpdate(rootNode);
                return;
            }
            if (!node.contains(virtualFile)) continue;
            if (containingFiles == null) {
                containingFiles = new SmartList();
            }
            containingFiles.add(virtualFile);
        }
        if (containingFiles != null) {
            this.updateNode(rootNode);
            Enumeration<TreeNode> children = rootNode.children();
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                this.updateNodesContaining(containingFiles, child);
            }
        }
    }

    private class MyProblemListener
    extends WolfTheProblemSolver.ProblemListener {
        private final Alarm myUpdateProblemAlarm = new Alarm();
        private final Collection<VirtualFile> myFilesToRefresh = new THashSet();

        private MyProblemListener() {
        }

        public void problemsAppeared(VirtualFile file) {
            this.queueUpdate(file);
        }

        public void problemsDisappeared(VirtualFile file) {
            this.queueUpdate(file);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void queueUpdate(VirtualFile fileToRefresh) {
            Collection<VirtualFile> collection = this.myFilesToRefresh;
            synchronized (collection) {
                if (this.myFilesToRefresh.add(fileToRefresh)) {
                    this.myUpdateProblemAlarm.cancelAllRequests();
                    this.myUpdateProblemAlarm.addRequest(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            THashSet filesToRefresh;
                            if (!ProjectTreeBuilder.this.myProject.isOpen()) {
                                return;
                            }
                            Collection collection = MyProblemListener.this.myFilesToRefresh;
                            synchronized (collection) {
                                filesToRefresh = new THashSet(MyProblemListener.this.myFilesToRefresh);
                            }
                            ProjectTreeBuilder.this.updateNodesContaining((Collection)filesToRefresh, ProjectTreeBuilder.this.getRootNode());
                            collection = MyProblemListener.this.myFilesToRefresh;
                            synchronized (collection) {
                                MyProblemListener.this.myFilesToRefresh.removeAll((Collection<?>)filesToRefresh);
                            }
                        }
                    }, 200, ModalityState.NON_MODAL);
                }
            }
        }
    }

    private final class MyFileStatusListener
    implements FileStatusListener {
        private MyFileStatusListener() {
        }

        public void fileStatusesChanged() {
            ProjectTreeBuilder.this.getUpdater().addSubtreeToUpdate(ProjectTreeBuilder.this.getRootNode());
        }

        public void fileStatusChanged(@NotNull VirtualFile vFile) {
            if (vFile == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/projectView/impl/ProjectTreeBuilder$MyFileStatusListener.fileStatusChanged must not be null");
            }
            PsiElement element = ProjectTreeBuilder.this.findPsi(vFile);
            boolean fileAdded = ProjectTreeBuilder.this.getUpdater().addSubtreeToUpdateByElement((Object)element);
            if (!fileAdded) {
                if (element instanceof PsiFile) {
                    ProjectTreeBuilder.this.getUpdater().addSubtreeToUpdateByElement((Object)((PsiFile)element).getContainingDirectory());
                } else {
                    ProjectTreeBuilder.this.getUpdater().addSubtreeToUpdate(ProjectTreeBuilder.this.getRootNode());
                }
            }
        }
    }

    private final class MyBookmarksListener
    implements BookmarksListener {
        private MyBookmarksListener() {
        }

        @Override
        public void bookmarkAdded(Bookmark b) {
            this.updateForFile(b.getFile());
        }

        @Override
        public void bookmarkRemoved(Bookmark b) {
            this.updateForFile(b.getFile());
        }

        @Override
        public void bookmarkChanged(Bookmark b) {
            this.updateForFile(b.getFile());
        }

        private void updateForFile(VirtualFile file) {
            PsiElement element = ProjectTreeBuilder.this.findPsi(file);
            if (element != null) {
                ProjectTreeBuilder.this.getUpdater().addSubtreeToUpdateByElement((Object)element);
            }
        }
    }

    protected class ProjectTreeBuilderPsiListener
    extends ProjectViewPsiTreeChangeListener {
        public ProjectTreeBuilderPsiListener(Project project) {
            super(project);
        }

        @Override
        protected DefaultMutableTreeNode getRootNode() {
            return ProjectTreeBuilder.this.getRootNode();
        }

        @Override
        protected AbstractTreeUpdater getUpdater() {
            return ProjectTreeBuilder.this.getUpdater();
        }

        @Override
        protected boolean isFlattenPackages() {
            return ((AbstractProjectTreeStructure)ProjectTreeBuilder.this.getTreeStructure()).isFlattenPackages();
        }
    }
}

