/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.impl.AbstractUrl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.NonNls;

public class DirectoryUrl
extends AbstractUrl {
    @NonNls
    private static final String ELEMENT_TYPE = "directory";

    public DirectoryUrl(String url, String moduleName) {
        super(url, moduleName, ELEMENT_TYPE);
    }

    public static DirectoryUrl create(PsiDirectory directory) {
        Project project = directory.getProject();
        VirtualFile virtualFile = directory.getVirtualFile();
        Module module = ModuleUtil.findModuleForFile((VirtualFile)virtualFile, (Project)project);
        return new DirectoryUrl(virtualFile.getUrl(), module != null ? module.getName() : null);
    }

    @Override
    public Object[] createPath(Project project) {
        Module module;
        Module module2 = module = this.moduleName != null ? ModuleManager.getInstance((Project)project).findModuleByName(this.moduleName) : null;
        if (module == null) {
            return null;
        }
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        VirtualFile file = virtualFileManager.findFileByUrl(this.url);
        if (file == null) {
            return null;
        }
        PsiDirectory directory = PsiManager.getInstance((Project)project).findDirectory(file);
        if (directory == null) {
            return null;
        }
        return new Object[]{directory};
    }

    @Override
    protected AbstractUrl createUrl(String moduleName, String url) {
        return new DirectoryUrl(url, moduleName);
    }

    @Override
    public AbstractUrl createUrlByElement(Object element) {
        if (element instanceof PsiDirectory) {
            return DirectoryUrl.create((PsiDirectory)element);
        }
        return null;
    }
}

