/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.RepositoryContentHandler;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NonNls;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RepositoryHelper {
    @NonNls
    public static final String DOWNLOAD_URL = RepositoryHelper.getDownloadUrl() + "?action=download&id=";
    @NonNls
    private static final String FILENAME = "filename=";
    @NonNls
    public static final String extPluginsFile = "availables.xml";

    public static ArrayList<IdeaPluginDescriptor> process(JLabel label) throws IOException, ParserConfigurationException, SAXException {
        ArrayList<IdeaPluginDescriptor> plugins = null;
        try {
            BuildNumber buildNumber = ApplicationInfo.getInstance().getBuild();
            String url = RepositoryHelper.getListUrl() + "?build=" + buildNumber.asString();
            RepositoryHelper.setLabelText(label, IdeBundle.message((String)"progress.connecting.to.plugin.manager", (Object[])new Object[]{RepositoryHelper.getRepositoryHost()}));
            HttpConfigurable.getInstance().prepareURL(RepositoryHelper.getRepositoryHost());
            RepositoryContentHandler handler = new RepositoryContentHandler();
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            RepositoryHelper.setLabelText(label, IdeBundle.message((String)"progress.waiting.for.reply.from.plugin.manager", (Object[])new Object[]{RepositoryHelper.getRepositoryHost()}));
            InputStream is = RepositoryHelper.getConnectionInputStream(connection);
            if (is != null) {
                RepositoryHelper.setLabelText(label, IdeBundle.message((String)"progress.downloading.list.of.plugins", (Object[])new Object[0]));
                File temp = RepositoryHelper.createLocalPluginsDescriptions();
                RepositoryHelper.readPluginsStream(temp, is, handler);
                plugins = handler.getPluginsList();
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            if (e.getCause() == null || !(e.getCause() instanceof InterruptedException)) {
                // empty if block
            }
        }
        return plugins;
    }

    private static void setLabelText(final JLabel label, final String message) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                label.setText(message);
            }
        });
    }

    public static InputStream getConnectionInputStream(URLConnection connection) {
        try {
            return connection.getInputStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static File createLocalPluginsDescriptions() throws IOException {
        File basePath = new File(PathManager.getPluginsPath());
        basePath.mkdirs();
        File temp = new File(basePath, extPluginsFile);
        if (temp.exists()) {
            FileUtil.delete((File)temp);
        }
        FileUtil.createIfDoesntExist((File)temp);
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readPluginsStream(File temp, InputStream is, RepositoryContentHandler handler) throws SAXException, IOException, ParserConfigurationException {
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        FileOutputStream fos = null;
        try {
            int size;
            fos = new FileOutputStream(temp, false);
            byte[] buffer = new byte[1024];
            while ((size = is.read(buffer)) != -1) {
                fos.write(buffer, 0, size);
            }
            fos.close();
            fos = null;
            parser.parse(temp, (DefaultHandler)handler);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    public static String getRepositoryHost() {
        return ApplicationInfoImpl.getShadowInstance().getPluginManagerUrl();
    }

    public static String getListUrl() {
        return ApplicationInfoImpl.getShadowInstance().getPluginsListUrl();
    }

    public static String getDownloadUrl() {
        return ApplicationInfoImpl.getShadowInstance().getPluginsDownloadUrl();
    }
}

