/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.CommonBundle;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.ActionInstallPlugin;
import com.intellij.ide.plugins.ActionUninstallPlugin;
import com.intellij.ide.plugins.AvailablePluginsTableModel;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsTableModel;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerColumnInfo;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.PluginTable;
import com.intellij.ide.plugins.PluginTableModel;
import com.intellij.ide.plugins.RepositoryContentHandler;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.plugins.SortableProvider;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.FilterComponent;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.TableUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import com.intellij.util.concurrency.SwingWorker;
import com.intellij.util.net.HTTPProxySettingsDialog;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.helpers.DefaultHandler;

public class PluginManagerMain
implements Disposable {
    public static Logger LOG = Logger.getInstance((String)"#com.intellij.ide.plugins.PluginManagerMain");
    @NonNls
    private static final String TEXT_PREFIX = "<html><body style=\"font-family: Arial; font-size: 12pt;\">";
    @NonNls
    private static final String TEXT_SUFIX = "</body></html>";
    @NonNls
    private static final String HTML_PREFIX = "<html><body><a href=\"\">";
    @NonNls
    private static final String HTML_SUFIX = "</a></body></html>";
    private boolean requireShutdown = false;
    private JPanel myToolbarPanel;
    private JPanel main;
    private JEditorPane myDescriptionTextArea;
    private JEditorPane myChangeNotesTextArea;
    private JLabel myVendorLabel;
    private JLabel myVendorEmailLabel;
    private JLabel myVendorUrlLabel;
    private JLabel myPluginUrlLabel;
    private JLabel myVersionLabel;
    private JLabel mySizeLabel;
    private JButton myHttpProxySettingsButton;
    private JProgressBar myProgressBar;
    private JButton btnCancel;
    private JLabel mySynchStatus;
    private JPanel myTablePanel;
    private JButton myReloadButton;
    private final TabbedPaneWrapper myTabbedPane;
    private DefaultActionGroup actionGroup;
    private final InstalledPluginsTableModel installedPluginsModel;
    private final PluginTable installedPluginTable;
    private final AvailablePluginsTableModel availablePluginsModel;
    private final PluginTable availablePluginsTable;
    private ArrayList<IdeaPluginDescriptor> pluginsList;
    private final ActionToolbar myActionToolbar;
    private final MyPluginsFilter myFilter;

    public PluginManagerMain(SortableProvider installedProvider, SortableProvider availableProvider) {
        this.$$$setupUI$$$();
        this.myFilter = new MyPluginsFilter();
        this.myDescriptionTextArea.addHyperlinkListener(new MyHyperlinkListener());
        this.myChangeNotesTextArea.addHyperlinkListener(new MyHyperlinkListener());
        this.installedPluginsModel = new InstalledPluginsTableModel(installedProvider);
        this.installedPluginTable = new PluginTable(this.installedPluginsModel);
        this.installedPluginTable.setColumnWidth(2, 45);
        JScrollPane installedScrollPane = ScrollPaneFactory.createScrollPane((JComponent)((Object)this.installedPluginTable));
        this.installedPluginTable.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int column = InstalledPluginsTableModel.getCheckboxColumn();
                int[] selectedRows = PluginManagerMain.this.installedPluginTable.getSelectedRows();
                boolean currentlyMarked = true;
                for (int selectedRow : selectedRows) {
                    if (selectedRow < 0 || !PluginManagerMain.this.installedPluginTable.isCellEditable(selectedRow, column)) {
                        return;
                    }
                    currentlyMarked &= ((Boolean)PluginManagerMain.this.installedPluginTable.getValueAt(selectedRow, column)).booleanValue();
                }
                for (int selectedRow : selectedRows) {
                    PluginManagerMain.this.installedPluginTable.setValueAt(currentlyMarked ? Boolean.FALSE : Boolean.TRUE, selectedRow, column);
                }
            }
        }, KeyStroke.getKeyStroke(32, 0), 0);
        this.availablePluginsModel = new AvailablePluginsTableModel(availableProvider);
        this.availablePluginsTable = new PluginTable(this.availablePluginsModel);
        this.availablePluginsTable.setColumnWidth(1, 70);
        JScrollPane availableScrollPane = ScrollPaneFactory.createScrollPane((JComponent)((Object)this.availablePluginsTable));
        this.installTableActions(this.installedPluginTable);
        this.installTableActions(this.availablePluginsTable);
        this.myHttpProxySettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HTTPProxySettingsDialog settingsDialog = new HTTPProxySettingsDialog();
                settingsDialog.pack();
                settingsDialog.show();
                if (settingsDialog.isOK()) {
                    PluginManagerMain.this.loadAvailablePlugins();
                }
            }
        });
        this.myReloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginManagerMain.this.loadAvailablePlugins();
                PluginManagerMain.this.myFilter.setFilter("");
            }
        });
        this.myTabbedPane = new TabbedPaneWrapper(this);
        this.myTablePanel.add((Component)this.myTabbedPane.getComponent(), "Center");
        this.myTablePanel.setMinimumSize(new Dimension(400, -1));
        this.myTabbedPane.addTab(IdeBundle.message((String)"plugin.status.installed", (Object[])new Object[0]), installedScrollPane);
        this.myTabbedPane.addTab(IdeBundle.message((String)"plugin.status.available", (Object[])new Object[0]), availableScrollPane);
        this.myTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PluginTable pluginTable = PluginManagerMain.this.getPluginTable();
                TableUtil.ensureSelectionExists((JTable)((Object)pluginTable));
                PluginManagerMain.this.pluginInfoUpdate(pluginTable.getSelectedObject());
                PluginManagerMain.this.myActionToolbar.updateActionsImmediately();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PluginManagerMain.this.myFilter.filter();
                    }
                });
            }
        });
        this.myToolbarPanel.setLayout(new BorderLayout());
        this.myActionToolbar = ActionManager.getInstance().createActionToolbar("PluginManaer", this.getActionGroup(), true);
        this.myToolbarPanel.add((Component)this.myActionToolbar.getComponent(), "West");
        this.myToolbarPanel.add((Component)((Object)this.myFilter), "East");
    }

    public void dispose() {
    }

    public void filter(String filter) {
        this.myFilter.setSelectedItem(filter);
    }

    public void reset() {
        UiNotifyConnector.doWhenFirstShown((JComponent)((Object)this.getPluginTable()), (Runnable)new Runnable(){

            @Override
            public void run() {
                PluginManagerMain.this.requireShutdown = false;
                PluginManagerMain.this.pluginsList = null;
                TableUtil.ensureSelectionExists((JTable)((Object)PluginManagerMain.this.getPluginTable()));
                PluginManagerMain.this.loadAvailablePlugins();
            }
        });
    }

    PluginTable getPluginTable() {
        return this.myTabbedPane.getSelectedIndex() == 0 ? this.installedPluginTable : this.availablePluginsTable;
    }

    public PluginTable getInstalledPluginTable() {
        return this.installedPluginTable;
    }

    public PluginTable getAvailablePluginsTable() {
        return this.availablePluginsTable;
    }

    public InstalledPluginsTableModel getInstalledPluginsModel() {
        return this.installedPluginsModel;
    }

    public AvailablePluginsTableModel getAvailablePluginsModel() {
        return this.availablePluginsModel;
    }

    private void installTableActions(final PluginTable pluginTable) {
        pluginTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                IdeaPluginDescriptor[] descriptors = pluginTable.getSelectedObjects();
                PluginManagerMain.this.pluginInfoUpdate(descriptors != null && descriptors.length == 1 ? descriptors[0] : null);
                PluginManagerMain.this.myActionToolbar.updateActionsImmediately();
            }
        });
        PopupHandler.installUnknownPopupHandler((JComponent)((Object)pluginTable), (ActionGroup)this.getActionGroup(), (ActionManager)ActionManager.getInstance());
        this.myVendorEmailLabel.setCursor(new Cursor(12));
        this.myVendorEmailLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isConsumed()) {
                    return;
                }
                IdeaPluginDescriptor pluginDescriptor = PluginManagerMain.this.getPluginTable().getSelectedObject();
                if (pluginDescriptor != null) {
                    PluginManagerMain.launchBrowserAction(pluginDescriptor.getVendorEmail(), "mailto:");
                    e.consume();
                }
            }
        });
        this.myVendorUrlLabel.setCursor(new Cursor(12));
        this.myVendorUrlLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isConsumed()) {
                    return;
                }
                IdeaPluginDescriptor pluginDescriptor = PluginManagerMain.this.getPluginTable().getSelectedObject();
                if (pluginDescriptor != null) {
                    PluginManagerMain.launchBrowserAction(pluginDescriptor.getVendorUrl(), "");
                    e.consume();
                }
            }
        });
        this.myPluginUrlLabel.setCursor(new Cursor(12));
        this.myPluginUrlLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isConsumed()) {
                    return;
                }
                IdeaPluginDescriptor pluginDescriptor = PluginManagerMain.this.getPluginTable().getSelectedObject();
                if (pluginDescriptor != null) {
                    PluginManagerMain.launchBrowserAction(pluginDescriptor.getUrl(), "");
                    e.consume();
                }
            }
        });
        new MySpeedSearchBar(pluginTable);
    }

    public void setRequireShutdown(boolean val) {
        this.requireShutdown |= val;
    }

    public ArrayList<IdeaPluginDescriptorImpl> getDependentList(IdeaPluginDescriptorImpl pluginDescriptor) {
        return this.installedPluginsModel.dependent(pluginDescriptor);
    }

    private void loadAvailablePlugins() {
        try {
            File file = new File(PathManager.getPluginsPath(), "availables.xml");
            if (file.exists()) {
                RepositoryContentHandler handler = new RepositoryContentHandler();
                SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                parser.parse(file, (DefaultHandler)handler);
                ArrayList<IdeaPluginDescriptor> list = handler.getPluginsList();
                this.modifyPluginsList(list);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.loadPluginsFromHostInBackground();
    }

    private void modifyPluginsList(ArrayList<IdeaPluginDescriptor> list) {
        IdeaPluginDescriptor[] selected = this.availablePluginsTable.getSelectedObjects();
        if (this.pluginsList == null) {
            this.availablePluginsModel.addData(list);
            this.installedPluginsModel.addData(list);
        } else {
            this.availablePluginsModel.modifyData(list);
            this.installedPluginsModel.modifyData(list);
        }
        this.pluginsList = list;
        if (selected != null) {
            this.select(selected);
        }
    }

    private void loadPluginsFromHostInBackground() {
        this.setDownloadStatus(true);
        new SwingWorker(){
            ArrayList<IdeaPluginDescriptor> list = null;
            Exception error;

            public Object construct() {
                try {
                    this.list = RepositoryHelper.process(PluginManagerMain.this.mySynchStatus);
                }
                catch (Exception e) {
                    this.error = e;
                }
                return this.list;
            }

            public void finished() {
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (list != null) {
                            PluginManagerMain.this.modifyPluginsList(list);
                            PluginManagerMain.this.setDownloadStatus(false);
                        } else if (error != null) {
                            LOG.info((Throwable)error);
                            PluginManagerMain.this.setDownloadStatus(false);
                            if (0 == Messages.showDialog((String)IdeBundle.message((String)"error.list.of.plugins.was.not.loaded", (Object[])new Object[]{error.getMessage()}), (String)IdeBundle.message((String)"title.plugins", (Object[])new Object[0]), (String[])new String[]{CommonBundle.message((String)"button.retry", (Object[])new Object[0]), CommonBundle.getCancelButtonText()}, (int)0, (Icon)Messages.getErrorIcon())) {
                                PluginManagerMain.this.loadPluginsFromHostInBackground();
                            }
                        }
                    }
                });
            }
        }.start();
    }

    private void setDownloadStatus(boolean what) {
        this.btnCancel.setVisible(what);
        this.mySynchStatus.setVisible(what);
        this.myProgressBar.setVisible(what);
        this.myProgressBar.setEnabled(what);
        this.myProgressBar.setIndeterminate(what);
    }

    private ActionGroup getActionGroup() {
        if (this.actionGroup == null) {
            this.actionGroup = new DefaultActionGroup();
            this.actionGroup.add((AnAction)new ActionInstallPlugin(this));
            this.actionGroup.add((AnAction)new ActionUninstallPlugin(this, this.installedPluginTable));
        }
        return this.actionGroup;
    }

    public JPanel getMainPanel() {
        return this.main;
    }

    public static boolean downloadPlugins(final List<PluginNode> plugins) throws IOException {
        final boolean[] result = new boolean[1];
        try {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    result[0] = PluginInstaller.prepareToInstall(plugins);
                }
            }, IdeBundle.message((String)"progress.download.plugins", (Object[])new Object[0]), true, null);
        }
        catch (RuntimeException e) {
            if (e.getCause() != null && e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
        return result[0];
    }

    public boolean isRequireShutdown() {
        return this.requireShutdown;
    }

    public void ignoreChanges() {
        this.requireShutdown = false;
    }

    private static void setTextValue(String val, JEditorPane pane) {
        if (val != null) {
            pane.setText(TEXT_PREFIX + val.trim() + TEXT_SUFIX);
            pane.setCaretPosition(0);
        } else {
            pane.setText("<html><body style=\"font-family: Arial; font-size: 12pt;\"></body></html>");
        }
    }

    private static void setTextValue(String val, JLabel label) {
        label.setText(val != null ? val : "");
    }

    private static void setHtmlValue(String val, JLabel label) {
        boolean isValid = val != null && val.trim().length() > 0;
        String setVal = isValid ? HTML_PREFIX + val.trim() + HTML_SUFIX : IdeBundle.message((String)"plugin.status.not.specified", (Object[])new Object[0]);
        label.setText(setVal);
        label.setCursor(isValid ? Cursor.getPredefinedCursor(12) : Cursor.getPredefinedCursor(0));
    }

    private void pluginInfoUpdate(Object plugin) {
        if (plugin != null) {
            String size;
            IdeaPluginDescriptor pluginDescriptor = (IdeaPluginDescriptor)plugin;
            this.myVendorLabel.setText(pluginDescriptor.getVendor());
            String description = pluginDescriptor.getDescription();
            PluginManagerMain.setTextValue(description != null ? SearchUtil.markup(description, this.myFilter.getFilter()) : null, this.myDescriptionTextArea);
            PluginManagerMain.setTextValue(pluginDescriptor.getChangeNotes(), this.myChangeNotesTextArea);
            PluginManagerMain.setHtmlValue(pluginDescriptor.getVendorEmail(), this.myVendorEmailLabel);
            PluginManagerMain.setHtmlValue(pluginDescriptor.getVendorUrl(), this.myVendorUrlLabel);
            PluginManagerMain.setHtmlValue(pluginDescriptor.getUrl(), this.myPluginUrlLabel);
            PluginManagerMain.setTextValue(pluginDescriptor.getVersion(), this.myVersionLabel);
            String string = size = plugin instanceof PluginNode ? ((PluginNode)plugin).getSize() : null;
            if (size != null) {
                size = PluginManagerColumnInfo.getFormattedSize(size);
            }
            PluginManagerMain.setTextValue(size, this.mySizeLabel);
        } else {
            this.myVendorLabel.setText("");
            PluginManagerMain.setTextValue(null, this.myDescriptionTextArea);
            PluginManagerMain.setTextValue(null, this.myChangeNotesTextArea);
            this.myVendorEmailLabel.setText("");
            this.myVendorUrlLabel.setText("");
            this.myPluginUrlLabel.setText("");
            this.myVersionLabel.setText("");
            this.mySizeLabel.setText("");
        }
    }

    private static void launchBrowserAction(String cmd, String prefix) {
        if (cmd != null && cmd.trim().length() > 0) {
            try {
                BrowserUtil.launchBrowser((String)(prefix + cmd.trim()));
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
        }
    }

    public boolean isModified() {
        if (this.requireShutdown) {
            return true;
        }
        for (int i = 0; i < this.installedPluginsModel.getRowCount(); ++i) {
            IdeaPluginDescriptorImpl pluginDescriptor = (IdeaPluginDescriptorImpl)this.installedPluginsModel.getObjectAt(i);
            if (pluginDescriptor.isEnabled() == this.installedPluginsModel.getEnabledMap().get(pluginDescriptor.getPluginId()).booleanValue()) continue;
            return true;
        }
        for (IdeaPluginDescriptor descriptor : this.myFilter.getFilteredInstalled()) {
            if (((IdeaPluginDescriptorImpl)descriptor).isEnabled() == this.installedPluginsModel.getEnabledMap().get(descriptor.getPluginId()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public void apply() {
        if (!this.canApply()) {
            return;
        }
        this.setRequireShutdown(true);
        for (int i = 0; i < this.installedPluginTable.getRowCount(); ++i) {
            IdeaPluginDescriptorImpl pluginDescriptor = (IdeaPluginDescriptorImpl)this.installedPluginsModel.getObjectAt(i);
            pluginDescriptor.setEnabled(((Boolean)this.installedPluginsModel.getValueAt(i, InstalledPluginsTableModel.getCheckboxColumn())).booleanValue());
        }
        for (IdeaPluginDescriptor descriptor : this.myFilter.getFilteredInstalled()) {
            ((IdeaPluginDescriptorImpl)descriptor).setEnabled(this.installedPluginsModel.getEnabledMap().get(descriptor.getPluginId()).booleanValue());
        }
        try {
            ArrayList<String> ids = new ArrayList<String>();
            for (Map.Entry<PluginId, Boolean> entry : this.installedPluginsModel.getEnabledMap().entrySet()) {
                if (entry.getValue().booleanValue()) continue;
                ids.add(entry.getKey().getIdString());
            }
            PluginManager.saveDisabledPlugins(ids, (boolean)false);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private boolean canApply() {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<PluginId, Boolean> entry : this.installedPluginsModel.getEnabledMap().entrySet()) {
            IdeaPluginDescriptorImpl pluginDescriptor = (IdeaPluginDescriptorImpl)PluginManager.getPlugin((PluginId)entry.getKey());
            if (!entry.getValue().booleanValue()) continue;
            final HashSet absent = new HashSet();
            PluginManager.checkDependants((IdeaPluginDescriptor)pluginDescriptor, (Function)new Function<PluginId, IdeaPluginDescriptor>(){

                @Nullable
                public IdeaPluginDescriptor fun(PluginId pluginId) {
                    return PluginManager.getPlugin((PluginId)pluginId);
                }
            }, (Condition)new Condition<PluginId>(){

                public boolean value(PluginId pluginId) {
                    if (!PluginManagerMain.this.installedPluginsModel.isEnabled(pluginId)) {
                        absent.add(pluginId);
                        return false;
                    }
                    return true;
                }
            });
            if (absent.isEmpty()) continue;
            buf.append(IdeBundle.message((String)"disabled.plugins.warning.message", (Object[])new Object[]{pluginDescriptor.getName(), StringUtil.join(absent, (Function)new Function<PluginId, String>(){

                public String fun(PluginId pluginId) {
                    IdeaPluginDescriptor ideaPluginDescriptor = PluginManager.getPlugin((PluginId)pluginId);
                    return "\"" + (ideaPluginDescriptor != null ? ideaPluginDescriptor.getName() : pluginId.getIdString()) + "\"";
                }
            }, (String)", "), absent.size()}));
        }
        if (buf.length() > 0) {
            String message = "<html><body><ul>" + buf.toString() + "</ul>" + "Changes won't be applied." + TEXT_SUFIX;
            Messages.showErrorDialog((Component)this.main, (String)message);
            return false;
        }
        return true;
    }

    public void select(IdeaPluginDescriptor ... descriptors) {
        this.installedPluginTable.select(descriptors);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JProgressBar jProgressBar;
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JPanel jPanel;
        JPanel jPanel2;
        JLabel jLabel2;
        JLabel jLabel3;
        JLabel jLabel4;
        JEditorPane jEditorPane;
        JEditorPane jEditorPane2;
        JLabel jLabel5;
        JLabel jLabel6;
        JLabel jLabel7;
        JPanel jPanel3;
        this.main = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.setPreferredSize(new Dimension(600, 600));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 7, null, null, null));
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setOneTouchExpandable(true);
        jPanel4.add((Component)jSplitPane, "Center");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridBagLayout());
        jSplitPane.setRightComponent(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(5, 5, 5, 5), -1, -1, false, false));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel5.add((Component)jPanel6, gridBagConstraints);
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("messages/IdeBundle").getString("group.vendor"), 0, 0, null, null));
        JLabel jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, ResourceBundle.getBundle("messages/IdeBundle").getString("label.plugin.vendor.home.page"));
        jPanel6.add((Component)jLabel8, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel9 = new JLabel();
        this.$$$loadLabelText$$$(jLabel9, ResourceBundle.getBundle("messages/IdeBundle").getString("label.plugin.vendor.name"));
        jPanel6.add((Component)jLabel9, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel10 = new JLabel();
        this.$$$loadLabelText$$$(jLabel10, ResourceBundle.getBundle("messages/IdeBundle").getString("label.plugin.vendor.email"));
        jPanel6.add((Component)jLabel10, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVendorUrlLabel = jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("messages/IdeBundle").getString("plugin.status.not.specified"));
        jPanel6.add((Component)jLabel7, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, new Dimension(10, -1), null, null));
        this.myVendorEmailLabel = jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("messages/IdeBundle").getString("plugin.status.not.specified"));
        jPanel6.add((Component)jLabel6, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, new Dimension(10, -1), null, null));
        this.myVendorLabel = jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("messages/IdeBundle").getString("plugin.status.not.specified"));
        jPanel6.add((Component)jLabel5, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, new Dimension(10, -1), null, null));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 4;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.fill = 1;
        jPanel5.add((Component)jPanel7, gridBagConstraints2);
        JLabel jLabel11 = new JLabel();
        this.$$$loadLabelText$$$(jLabel11, ResourceBundle.getBundle("messages/IdeBundle").getString("editbox.plugin.description"));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.anchor = 16;
        jPanel7.add((Component)jLabel11, gridBagConstraints3);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setVerticalScrollBarPolicy(22);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.weighty = 0.5;
        gridBagConstraints4.fill = 1;
        jPanel7.add((Component)jScrollPane, gridBagConstraints4);
        this.myDescriptionTextArea = jEditorPane2 = new JEditorPane();
        jEditorPane2.setEditable(false);
        jEditorPane2.setMaximumSize(new Dimension(-1, -1));
        jEditorPane2.setContentType("text/html");
        jScrollPane.setViewportView(jEditorPane2);
        JLabel jLabel12 = new JLabel();
        this.$$$loadLabelText$$$(jLabel12, ResourceBundle.getBundle("messages/IdeBundle").getString("editbox.plugin.change.notes"));
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 2;
        gridBagConstraints5.anchor = 17;
        jPanel7.add((Component)jLabel12, gridBagConstraints5);
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.setVerticalScrollBarPolicy(22);
        jScrollPane2.setAutoscrolls(true);
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.gridy = 3;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.weighty = 0.5;
        gridBagConstraints6.fill = 1;
        jPanel7.add((Component)jScrollPane2, gridBagConstraints6);
        this.myChangeNotesTextArea = jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        jEditorPane.setMaximumSize(new Dimension(-1, -1));
        jEditorPane.setMargin(new Insets(0, 0, 0, 0));
        jEditorPane.setContentType("text/html");
        jEditorPane.setText("<html>\r\n  <head>\r\n\r\n  </head>\r\n  <body>\r\n    <p style=\"margin-top: 0\">\r\n      \r\n    </p>\r\n  </body>\r\n</html>\r\n");
        jScrollPane2.setViewportView(jEditorPane);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridx = 0;
        gridBagConstraints7.gridy = 1;
        gridBagConstraints7.gridwidth = 4;
        gridBagConstraints7.gridheight = 2;
        gridBagConstraints7.weightx = 1.0;
        gridBagConstraints7.anchor = 11;
        gridBagConstraints7.fill = 2;
        jPanel5.add((Component)jPanel8, gridBagConstraints7);
        JLabel jLabel13 = new JLabel();
        this.$$$loadLabelText$$$(jLabel13, ResourceBundle.getBundle("messages/IdeBundle").getString("label.plugin.home.page"));
        jPanel8.add((Component)jLabel13, new GridConstraints(0, 0, 1, 1, 10, 0, 0, 0, null, null, null));
        JLabel jLabel14 = new JLabel();
        this.$$$loadLabelText$$$(jLabel14, ResourceBundle.getBundle("messages/IdeBundle").getString("plugin.version.label"));
        jPanel8.add((Component)jLabel14, new GridConstraints(1, 0, 1, 1, 10, 0, 0, 0, null, null, null));
        JLabel jLabel15 = new JLabel();
        this.$$$loadLabelText$$$(jLabel15, ResourceBundle.getBundle("messages/IdeBundle").getString("plugin.size.label"));
        jPanel8.add((Component)jLabel15, new GridConstraints(1, 2, 1, 1, 10, 0, 0, 0, null, null, null));
        this.myPluginUrlLabel = jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/IdeBundle").getString("plugin.status.not.specified"));
        jPanel8.add((Component)jLabel4, new GridConstraints(0, 1, 1, 3, 10, 0, 0, 0, new Dimension(10, -1), null, null));
        this.mySizeLabel = jLabel3 = new JLabel();
        jLabel3.setText("?");
        jPanel8.add((Component)jLabel3, new GridConstraints(1, 3, 1, 1, 10, 0, 0, 0, null, null, null));
        this.myVersionLabel = jLabel2 = new JLabel();
        jLabel2.setText("?");
        jPanel8.add((Component)jLabel2, new GridConstraints(1, 1, 1, 1, 10, 0, 0, 0, null, null, null));
        this.myTablePanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jSplitPane.setLeftComponent(jPanel2);
        this.myToolbarPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, "North");
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel9, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myReloadButton = jButton3 = new JButton();
        jButton3.setText("Reload");
        jButton3.setMnemonic('R');
        jButton3.setDisplayedMnemonicIndex(0);
        jPanel9.add((Component)jButton3, new GridConstraints(1, 0, 1, 1, 0, 1, 1, 0, null, null, null));
        this.myHttpProxySettingsButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("messages/IdeBundle").getString("button.http.proxy.settings"));
        jPanel9.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 1, 0, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel10, new GridConstraints(1, 1, 1, 1, 0, 3, 7, 3, null, null, null));
        this.btnCancel = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/IdeBundle").getString("button.cancel"));
        jButton.setInheritsPopupMenu(false);
        jPanel10.add((Component)jButton, new GridConstraints(1, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myProgressBar = jProgressBar = new JProgressBar();
        jPanel10.add((Component)jProgressBar, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.mySynchStatus = jLabel = new JLabel();
        jLabel.setText("");
        jPanel10.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(-1, 14), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.main;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class MyPluginsFilter
    extends FilterComponent {
        private final List<IdeaPluginDescriptor> myFilteredInstalled;
        private final List<IdeaPluginDescriptor> myFilteredAvailable;

        public MyPluginsFilter() {
            super("PLUGIN_FILTER", 5);
            this.myFilteredInstalled = new ArrayList<IdeaPluginDescriptor>();
            this.myFilteredAvailable = new ArrayList<IdeaPluginDescriptor>();
        }

        public void filter() {
            if (PluginManagerMain.this.installedPluginTable.isShowing()) {
                this.filter(PluginManagerMain.this.installedPluginsModel, this.myFilteredInstalled);
                if (PluginManagerMain.this.pluginsList != null) {
                    PluginManagerMain.this.installedPluginsModel.modifyData(PluginManagerMain.this.pluginsList);
                }
            } else {
                this.filter(PluginManagerMain.this.availablePluginsModel, this.myFilteredAvailable);
            }
        }

        public List<IdeaPluginDescriptor> getFilteredInstalled() {
            return this.myFilteredInstalled;
        }

        private void filter(PluginTableModel model, List<IdeaPluginDescriptor> filtered) {
            String filter = this.getFilter().toLowerCase();
            SearchableOptionsRegistrar optionsRegistrar = SearchableOptionsRegistrar.getInstance();
            Set search = optionsRegistrar.getProcessedWords(filter);
            ArrayList<IdeaPluginDescriptor> current = new ArrayList<IdeaPluginDescriptor>();
            List<IdeaPluginDescriptor> view = model.view;
            LinkedHashSet<IdeaPluginDescriptor> toBeProcessed = new LinkedHashSet<IdeaPluginDescriptor>(view);
            toBeProcessed.addAll(filtered);
            filtered.clear();
            for (IdeaPluginDescriptor descriptor : toBeProcessed) {
                String changeNotes;
                String category;
                String description;
                if (descriptor.getName().toLowerCase().indexOf(filter) != -1) {
                    current.add(descriptor);
                    continue;
                }
                if (this.isAccepted(search, current, descriptor, descriptor.getName()) || (description = descriptor.getDescription()) != null && this.isAccepted(search, current, descriptor, description) || (category = descriptor.getCategory()) != null && this.isAccepted(search, current, descriptor, category) || (changeNotes = descriptor.getChangeNotes()) != null && this.isAccepted(search, current, descriptor, changeNotes)) continue;
                filtered.add(descriptor);
            }
            model.filter(current);
        }

        private boolean isAccepted(Set<String> search, ArrayList<IdeaPluginDescriptor> current, IdeaPluginDescriptor descriptor, String description) {
            SearchableOptionsRegistrar optionsRegistrar = SearchableOptionsRegistrar.getInstance();
            HashSet<String> descriptionSet = new HashSet<String>(search);
            descriptionSet.removeAll(optionsRegistrar.getProcessedWords(description));
            if (descriptionSet.isEmpty()) {
                current.add(descriptor);
                return true;
            }
            return false;
        }

        public void dispose() {
            super.dispose();
            this.myFilteredInstalled.clear();
            this.myFilteredAvailable.clear();
        }
    }

    private static class MySpeedSearchBar
    extends SpeedSearchBase<PluginTable> {
        public MySpeedSearchBar(PluginTable cmp) {
            super(cmp);
        }

        @Override
        public int getSelectedIndex() {
            return ((PluginTable)((Object)this.myComponent)).getSelectedRow();
        }

        @Override
        public Object[] getAllElements() {
            return ((PluginTable)((Object)this.myComponent)).getElements();
        }

        @Override
        public String getElementText(Object element) {
            return ((IdeaPluginDescriptor)element).getName();
        }

        @Override
        public void selectElement(Object element, String selectedText) {
            for (int i = 0; i < ((PluginTable)((Object)this.myComponent)).getRowCount(); ++i) {
                if (!((PluginTable)((Object)this.myComponent)).getObjectAt(i).getName().equals(((IdeaPluginDescriptor)element).getName())) continue;
                ((PluginTable)((Object)this.myComponent)).setRowSelectionInterval(i, i);
                TableUtil.scrollSelectionToVisible((JTable)((JTable)this.myComponent));
                break;
            }
        }
    }

    private static class MyHyperlinkListener
    implements HyperlinkListener {
        private MyHyperlinkListener() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane pane = (JEditorPane)e.getSource();
                if (e instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                    HTMLDocument doc = (HTMLDocument)pane.getDocument();
                    doc.processHTMLFrameHyperlinkEvent(evt);
                } else {
                    URL url = e.getURL();
                    if (url != null) {
                        BrowserUtil.launchBrowser((String)url.toString());
                    }
                }
            }
        }
    }
}

