/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManagerColumnInfo;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.PluginTable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.IconLoader;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Icon;

public class ActionUninstallPlugin
extends AnAction
implements DumbAware {
    private static final String promptTitle = IdeBundle.message((String)"title.plugin.uninstall", (Object[])new Object[0]);
    private final PluginTable pluginTable;
    private final PluginManagerMain host;

    public ActionUninstallPlugin(PluginManagerMain mgr, PluginTable table) {
        super(IdeBundle.message((String)"action.uninstall.plugin", (Object[])new Object[0]), IdeBundle.message((String)"action.uninstall.plugin", (Object[])new Object[0]), IconLoader.getIcon((String)"/actions/uninstall.png"));
        this.pluginTable = table;
        this.host = mgr;
    }

    public void update(AnActionEvent e) {
        boolean enabled;
        Presentation presentation = e.getPresentation();
        if (!this.pluginTable.isShowing()) {
            presentation.setEnabled(false);
            return;
        }
        IdeaPluginDescriptor[] selection = this.pluginTable.getSelectedObjects();
        boolean bl = enabled = selection != null;
        if (enabled) {
            for (IdeaPluginDescriptor descriptor : selection) {
                IdeaPluginDescriptorImpl ideaPluginDescriptor;
                if (descriptor instanceof IdeaPluginDescriptorImpl && ((ideaPluginDescriptor = (IdeaPluginDescriptorImpl)descriptor).isDeleted() || ideaPluginDescriptor.isBundled())) {
                    enabled = false;
                    break;
                }
                if (!(descriptor instanceof PluginNode)) continue;
                enabled &= PluginManagerColumnInfo.getRealNodeState((PluginNode)descriptor) == 5;
            }
        }
        presentation.setEnabled(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        IdeaPluginDescriptor[] selection = this.pluginTable.getSelectedObjects();
        String message = selection.length == 1 ? IdeBundle.message((String)"prompt.uninstall.plugin", (Object[])new Object[]{selection[0].getName()}) : IdeBundle.message((String)"prompt.uninstall.several.plugins", (Object[])new Object[]{selection.length});
        if (Messages.showYesNoDialog((Component)this.host.getMainPanel(), (String)message, (String)promptTitle, (Icon)Messages.getQuestionIcon()) != 0) {
            return;
        }
        for (IdeaPluginDescriptor descriptor : selection) {
            IdeaPluginDescriptorImpl pluginDescriptor = (IdeaPluginDescriptorImpl)descriptor;
            boolean actualDelete = true;
            ArrayList<IdeaPluginDescriptorImpl> dependant = this.host.getDependentList(pluginDescriptor);
            if (dependant.size() > 0) {
                message = IdeBundle.message((String)"several.plugins.depend.on.0.continue.to.remove", (Object[])new Object[]{pluginDescriptor.getName()});
                boolean bl = actualDelete = Messages.showYesNoDialog((Component)this.host.getMainPanel(), (String)message, (String)promptTitle, (Icon)Messages.getQuestionIcon()) == 0;
            }
            if (!actualDelete) continue;
            this.uninstallPlugin(pluginDescriptor);
        }
    }

    private void uninstallPlugin(IdeaPluginDescriptorImpl descriptor) {
        PluginId pluginId = descriptor.getPluginId();
        descriptor.setDeleted(true);
        try {
            PluginInstaller.prepareToUninstall(pluginId);
            this.host.setRequireShutdown(descriptor.isEnabled());
            this.pluginTable.updateUI();
        }
        catch (IOException e1) {
            PluginManagerMain.LOG.error((Throwable)e1);
        }
    }
}

