/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.ProjectTopics;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.ide.CopyPasteDelegator;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeView;
import com.intellij.ide.navigationToolbar.NavBarModel;
import com.intellij.ide.navigationToolbar.NavBarModelListener;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.ide.util.DeleteHandler;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.TimerListener;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.actions.ModuleDeleteProvider;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ListenerUtil;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupOwner;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.Alarm;
import com.intellij.util.Icons;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavBarPanel
extends JPanel
implements DataProvider,
PopupOwner {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.navigationToolbar.NavigationToolbarPanel");
    private final ArrayList<MyItemLabel> myList = new ArrayList();
    private final NavBarModel myModel;
    private final Project myProject;
    private Runnable myDetacher;
    private final ModuleDeleteProvider myDeleteModuleProvider = new ModuleDeleteProvider();
    private final IdeView myIdeView = new MyIdeView();
    private final CopyPasteDelegator myCopyPasteDelegator;
    private LightweightHint myHint = null;
    private ListPopupImpl myNodePopup = null;
    private final Alarm myListUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private final Alarm myModelUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);

    public NavBarPanel(final Project project) {
        super(new FlowLayout(0, 5, 0));
        this.myProject = project;
        this.myModel = new NavBarModel(this.myProject);
        this.setBackground(UIUtil.getListBackground());
        this.setOpaque(true);
        PopupHandler.installPopupHandler((JComponent)this, (String)"ProjectViewPopupMenu", (String)"NavBar");
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavBarPanel.this.shiftFocus(-1);
            }
        }, KeyStroke.getKeyStroke(37, 0), 0);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavBarPanel.this.shiftFocus(1);
            }
        }, KeyStroke.getKeyStroke(39, 0), 0);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavBarPanel.this.shiftFocus(-NavBarPanel.this.myModel.getSelectedIndex());
            }
        }, KeyStroke.getKeyStroke(36, 0), 0);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavBarPanel.this.shiftFocus(NavBarPanel.this.myModel.size() - 1 - NavBarPanel.this.myModel.getSelectedIndex());
            }
        }, KeyStroke.getKeyStroke(35, 0), 0);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NavBarPanel.this.myModel.getSelectedIndex() != -1) {
                    NavBarPanel.this.ctrlClick(NavBarPanel.this.myModel.getSelectedIndex());
                }
            }
        }, KeyStroke.getKeyStroke(40, 0), 0);
        ActionListener dblClickAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NavBarPanel.this.myModel.getSelectedIndex() != -1) {
                    NavBarPanel.this.doubleClick(NavBarPanel.this.myModel.getSelectedIndex());
                }
            }
        };
        this.registerKeyboardAction(dblClickAction, KeyStroke.getKeyStroke(115, 0), 0);
        this.registerKeyboardAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object o = NavBarPanel.this.myModel.getSelectedValue();
                NavBarPanel.this.navigateInsideBar(NavBarPanel.optimizeTarget(o));
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
        this.registerKeyboardAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavBarPanel.this.myModel.setSelectedIndex(-1);
                ToolWindowManager.getInstance((Project)project).activateEditorComponent();
            }
        }, KeyStroke.getKeyStroke(27, 0), 0);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                NavBarPanel.this.updateItems();
            }

            @Override
            public void focusLost(final FocusEvent e) {
                if (NavBarPanel.this.myProject.isDisposed()) {
                    NavBarPanel.this.hideHint();
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NavBarPanel.this.processFocusLost(e);
                    }
                });
            }
        });
        this.installBorder(-1);
        this.myCopyPasteDelegator = new CopyPasteDelegator(this.myProject, this){

            @Override
            @NotNull
            protected PsiElement[] getSelectedElements() {
                PsiElement[] psiElementArray;
                PsiElement element = (PsiElement)NavBarPanel.this.getSelectedElement(PsiElement.class);
                if (element == null) {
                    psiElementArray = PsiElement.EMPTY_ARRAY;
                } else {
                    PsiElement[] psiElementArray2 = new PsiElement[1];
                    psiElementArray = psiElementArray2;
                    psiElementArray2[0] = element;
                }
                if (psiElementArray == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/ide/navigationToolbar/NavBarPanel$10.getSelectedElements must not return null");
                }
                return psiElementArray;
            }
        };
        this.updateModel();
        this.updateList();
    }

    private static Object optimizeTarget(Object target) {
        PsiDirectory[] subDir;
        if (target instanceof PsiDirectory && ((PsiDirectory)target).getFiles().length == 0 && (subDir = ((PsiDirectory)target).getSubdirectories()).length == 1) {
            return NavBarPanel.optimizeTarget(subDir[0]);
        }
        return target;
    }

    private void processFocusLost(FocusEvent e) {
        Component opposite;
        boolean childPopupInactive;
        boolean nodePopupInactive = this.myNodePopup == null || !this.myNodePopup.isVisible() || !this.myNodePopup.isFocused();
        boolean bl = childPopupInactive = !JBPopupFactory.getInstance().isChildPopupFocused((Component)this);
        if (nodePopupInactive && childPopupInactive && (opposite = e.getOppositeComponent()) != null && opposite != this && !this.isAncestorOf(opposite) && !e.isTemporary()) {
            this.hideHint();
        }
        this.updateItems();
    }

    private void updateItems() {
        for (MyItemLabel item : this.myList) {
            item.update();
        }
    }

    public void select() {
        this.updateModel();
        this.updateList();
        if (!this.myList.isEmpty()) {
            this.myModel.setSelectedIndex(this.myList.size() - 1);
            IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this, true);
        }
    }

    private void shiftFocus(int direction) {
        this.myModel.setSelectedIndex(this.myModel.getIndexByModel(this.myModel.getSelectedIndex() + direction));
    }

    private void scrollSelectionToVisible() {
        int selectedIndex = this.myModel.getSelectedIndex();
        if (selectedIndex == -1 || selectedIndex >= this.myList.size()) {
            return;
        }
        MyItemLabel selectedItem = this.myList.get(selectedIndex);
        Rectangle rect = selectedItem.getBounds();
        this.scrollRectToVisible(rect);
    }

    @Nullable
    private MyItemLabel getItem(int index) {
        if (index != -1 && index < this.myList.size()) {
            return this.myList.get(index);
        }
        return null;
    }

    private void scheduleModelUpdate() {
        this.myModelUpdateAlarm.cancelAllRequests();
        if (!this.isInFloatingMode()) {
            this.myModelUpdateAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    if (NavBarPanel.this.myProject.isDisposed()) {
                        return;
                    }
                    NavBarPanel.this.updateModel();
                }
            }, 300);
        }
    }

    private boolean isInFloatingMode() {
        return this.myHint != null && this.myHint.isVisible();
    }

    private void updateModel() {
        DataContext context = DataManager.getInstance().getDataContext();
        if (LangDataKeys.IDE_VIEW.getData(context) == this.myIdeView || PlatformDataKeys.PROJECT.getData(context) != this.myProject || this.isNodePopupShowing()) {
            this.scheduleModelUpdate();
            return;
        }
        this.myModel.updateModel(context);
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.myList.isEmpty()) {
            return super.getPreferredSize();
        }
        return new MyItemLabel(0, Icons.DIRECTORY_OPEN_ICON, "Sample", SimpleTextAttributes.REGULAR_ATTRIBUTES).getPreferredSize();
    }

    private void updateList() {
        this.myList.clear();
        for (int index = 0; index < this.myModel.size(); ++index) {
            Object object = this.myModel.get(index);
            Icon closedIcon = NavBarPanel.getIcon(object, false);
            Icon openIcon = NavBarPanel.getIcon(object, true);
            if (closedIcon == null && openIcon != null) {
                closedIcon = openIcon;
            }
            if (openIcon == null && closedIcon != null) {
                openIcon = closedIcon;
            }
            if (openIcon == null) {
                openIcon = closedIcon = new EmptyIcon(5, 5);
            }
            MyItemLabel label = new MyItemLabel(index, this.wrapIcon(openIcon, closedIcon, index), NavBarModel.getPresentableText(object, this.getWindow()), this.myModel.getTextAttributes(object, false));
            this.installActions(index, label);
            this.myList.add(label);
        }
        this.rebuildComponent();
    }

    @Nullable
    private static Icon getIcon(final Object object, final boolean isopen) {
        if (!NavBarModel.checkValid(object)) {
            return null;
        }
        if (object instanceof Project) {
            return IconLoader.getIcon((String)"/nodes/project.png");
        }
        if (object instanceof Module) {
            return ((Module)object).getModuleType().getNodeIcon(false);
        }
        try {
            if (object instanceof PsiElement) {
                return (Icon)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Icon>(){

                    public Icon compute() {
                        return ((PsiElement)object).isValid() ? ((PsiElement)object).getIcon(isopen ? 4 : 8) : null;
                    }
                });
            }
        }
        catch (IndexNotReadyException e) {
            return null;
        }
        if (object instanceof JdkOrderEntry) {
            return ((JdkOrderEntry)object).getJdk().getSdkType().getIcon();
        }
        if (object instanceof LibraryOrderEntry) {
            return IconLoader.getIcon((String)"/nodes/ppLibClosed.png");
        }
        if (object instanceof ModuleOrderEntry) {
            return ((ModuleOrderEntry)object).getModule().getModuleType().getNodeIcon(false);
        }
        return null;
    }

    private Icon wrapIcon(final Icon openIcon, final Icon closedIcon, final int idx) {
        return new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                if (NavBarPanel.this.myModel.getSelectedIndex() == idx && NavBarPanel.this.myNodePopup != null && NavBarPanel.this.myNodePopup.isVisible()) {
                    openIcon.paintIcon(c, g, x, y);
                } else {
                    closedIcon.paintIcon(c, g, x, y);
                }
            }

            @Override
            public int getIconWidth() {
                return openIcon.getIconWidth();
            }

            @Override
            public int getIconHeight() {
                return openIcon.getIconHeight();
            }
        };
    }

    private void rebuildComponent() {
        this.removeAll();
        for (MyItemLabel item : this.myList) {
            this.add((Component)((Object)item));
        }
        this.revalidate();
        this.repaint();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NavBarPanel.this.scrollSelectionToVisible();
            }
        });
    }

    private Window getWindow() {
        return SwingUtilities.getWindowAncestor(this);
    }

    private void installActions(final int index, MyItemLabel component) {
        ListenerUtil.addMouseListener((Component)((Object)component), new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!e.isConsumed() && !e.isPopupTrigger() && e.getClickCount() == 2) {
                    NavBarPanel.this.myModel.setSelectedIndex(index);
                    IdeFocusManager.getInstance((Project)NavBarPanel.this.myProject).requestFocus((Component)NavBarPanel.this, true);
                    NavBarPanel.this.doubleClick(index);
                    e.consume();
                }
            }
        });
        ListenerUtil.addMouseListener((Component)((Object)component), new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SystemInfo.isWindows) {
                    this.click(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (!SystemInfo.isWindows) {
                    this.click(e);
                }
            }

            private void click(MouseEvent e) {
                if (!e.isConsumed() && e.isPopupTrigger()) {
                    NavBarPanel.this.myModel.setSelectedIndex(index);
                    IdeFocusManager.getInstance((Project)NavBarPanel.this.myProject).requestFocus((Component)NavBarPanel.this, true);
                    NavBarPanel.this.rightClick(index);
                    e.consume();
                }
            }
        });
        ListenerUtil.addMouseListener((Component)((Object)component), new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SystemInfo.isWindows) {
                    this.click(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (!SystemInfo.isWindows) {
                    this.click(e);
                }
            }

            private void click(MouseEvent e) {
                if (!e.isConsumed() && !e.isPopupTrigger() && e.getClickCount() == 1) {
                    NavBarPanel.this.ctrlClick(index);
                    NavBarPanel.this.myModel.setSelectedIndex(index);
                    e.consume();
                }
            }
        });
    }

    private void doubleClick(int index) {
        this.doubleClick(this.myModel.getElement(index));
    }

    private void doubleClick(Object object) {
        if (object instanceof Navigatable) {
            Navigatable navigatable = (Navigatable)object;
            if (navigatable.canNavigate()) {
                navigatable.navigate(true);
            }
        } else if (object instanceof Module) {
            ProjectView projectView = ProjectView.getInstance(this.myProject);
            AbstractProjectViewPane projectViewPane = projectView.getProjectViewPaneById(projectView.getCurrentViewId());
            projectViewPane.selectModule((Module)object, true);
        } else if (object instanceof Project) {
            return;
        }
        this.hideHint();
    }

    private void ctrlClick(final int index) {
        Object object;
        List<Object> objects;
        if (this.isNodePopupShowing()) {
            this.cancelPopup();
            if (this.myModel.getSelectedIndex() == index) {
                return;
            }
        }
        if (!(objects = this.myModel.calcElementChildren(object = this.myModel.getElement(index))).isEmpty()) {
            Object[] siblings = new Object[objects.size()];
            Icon[] icons = new Icon[objects.size()];
            for (int i = 0; i < objects.size(); ++i) {
                siblings[i] = objects.get(i);
                icons[i] = NavBarPanel.getIcon(siblings[i], false);
            }
            MyItemLabel item = this.getItem(index);
            LOG.assertTrue(item != null);
            BaseListPopupStep<Object> step = new BaseListPopupStep<Object>("", siblings, icons){

                public boolean isSpeedSearchEnabled() {
                    return true;
                }

                @NotNull
                public String getTextFor(Object value) {
                    String string = NavBarModel.getPresentableText(value, null);
                    if (string == null) {
                        throw new IllegalStateException("@NotNull method com/intellij/ide/navigationToolbar/NavBarPanel$18.getTextFor must not return null");
                    }
                    return string;
                }

                public boolean isSelectable(Object value) {
                    return true;
                }

                public PopupStep onChosen(final Object selectedValue, boolean finalChoice) {
                    return this.doFinalStep(new Runnable(){

                        @Override
                        public void run() {
                            NavBarPanel.this.navigateInsideBar(NavBarPanel.optimizeTarget(selectedValue));
                        }
                    });
                }
            };
            step.setDefaultOptionIndex(index < this.myModel.size() - 1 ? objects.indexOf(this.myModel.getElement(index + 1)) : 0);
            this.myNodePopup = new ListPopupImpl((ListPopupStep)step){

                @Override
                protected ListCellRenderer getListElementRenderer() {
                    return new MySiblingsListCellRenderer();
                }
            };
            this.myNodePopup.registerAction("left", 37, 0, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NavBarPanel.this.myNodePopup.goBack();
                    NavBarPanel.this.shiftFocus(-1);
                    NavBarPanel.this.restorePopup();
                }
            });
            this.myNodePopup.registerAction("right", 39, 0, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NavBarPanel.this.myNodePopup.goBack();
                    NavBarPanel.this.shiftFocus(1);
                    NavBarPanel.this.restorePopup();
                }
            });
            ListenerUtil.addMouseListener(this.myNodePopup.getComponent(), new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (SystemInfo.isWindows) {
                        this.click(e);
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (!SystemInfo.isWindows) {
                        this.click(e);
                    }
                }

                private void click(MouseEvent e) {
                    if (!e.isConsumed() && e.isPopupTrigger()) {
                        NavBarPanel.this.myModel.setSelectedIndex(index);
                        IdeFocusManager.getInstance((Project)NavBarPanel.this.myProject).requestFocus((Component)NavBarPanel.this, true);
                        NavBarPanel.this.rightClick(index);
                        e.consume();
                    }
                }
            });
            this.myNodePopup.showUnderneathOf((Component)((Object)item));
        }
    }

    private boolean isNodePopupShowing() {
        return this.myNodePopup != null && this.myNodePopup.isVisible();
    }

    private void navigateInsideBar(Object object) {
        this.myModel.updateModel(object);
        this.updateList();
        this.myModel.setSelectedIndex(this.myList.size() - 1);
        if (this.myHint != null) {
            Dimension dimension = this.getPreferredSize();
            Rectangle bounds = this.myHint.getBounds();
            this.myHint.setBounds(bounds.x, bounds.y, dimension.width, dimension.height);
        }
        if (this.myModel.hasChildren(object)) {
            this.restorePopup();
        } else {
            this.doubleClick(object);
        }
    }

    private void rightClick(int index) {
        ActionManager actionManager = ActionManager.getInstance();
        ActionGroup group = (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction("NavbarPopupMenu");
        ActionPopupMenu popupMenu = actionManager.createActionPopupMenu("NavBar", group);
        MyItemLabel item = this.getItem(index);
        if (item != null) {
            popupMenu.getComponent().show(this, item.getX(), item.getY() + item.getHeight());
        }
    }

    private void restorePopup() {
        this.cancelPopup();
        this.ctrlClick(this.myModel.getSelectedIndex());
    }

    private void cancelPopup() {
        if (this.myNodePopup != null) {
            this.myNodePopup.cancel();
            this.myNodePopup = null;
        }
    }

    private void hideHint() {
        if (this.myHint != null) {
            this.myHint.hide();
            this.myHint = null;
        }
    }

    @Nullable
    public Object getData(String dataId) {
        if (PlatformDataKeys.PROJECT.is(dataId)) {
            return !this.myProject.isDisposed() ? this.myProject : null;
        }
        if (LangDataKeys.MODULE.is(dataId)) {
            Module module = this.getSelectedElement(Module.class);
            if (module != null && !module.isDisposed()) {
                return module;
            }
            PsiElement element = this.getSelectedElement(PsiElement.class);
            if (element != null) {
                return ModuleUtil.findModuleForPsiElement((PsiElement)element);
            }
            return null;
        }
        if (LangDataKeys.MODULE_CONTEXT.is(dataId)) {
            VirtualFile dir;
            PsiDirectory directory = this.getSelectedElement(PsiDirectory.class);
            if (directory != null && ProjectRootsUtil.isModuleContentRoot(dir = directory.getVirtualFile(), this.myProject)) {
                return ModuleUtil.findModuleForPsiElement((PsiElement)directory);
            }
            return null;
        }
        if (LangDataKeys.PSI_ELEMENT.is(dataId)) {
            PsiElement element = this.getSelectedElement(PsiElement.class);
            return element != null && element.isValid() ? element : null;
        }
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            PsiElement[] psiElementArray;
            PsiElement element = this.getSelectedElement(PsiElement.class);
            if (element != null && element.isValid()) {
                PsiElement[] psiElementArray2 = new PsiElement[1];
                psiElementArray = psiElementArray2;
                psiElementArray2[0] = element;
            } else {
                psiElementArray = null;
            }
            return psiElementArray;
        }
        if (PlatformDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            PsiElement[] psiElements = (PsiElement[])this.getData(LangDataKeys.PSI_ELEMENT_ARRAY.getName());
            if (psiElements == null) {
                return null;
            }
            LinkedHashSet<VirtualFile> files = new LinkedHashSet<VirtualFile>();
            for (PsiElement element : psiElements) {
                if (!(element instanceof PsiFileSystemItem)) continue;
                files.add(((PsiFileSystemItem)element).getVirtualFile());
            }
            return files.size() > 0 ? VfsUtil.toVirtualFileArray(files) : null;
        }
        if (PlatformDataKeys.CONTEXT_COMPONENT.is(dataId)) {
            return this;
        }
        if (PlatformDataKeys.CUT_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator.getCutProvider();
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator.getCopyProvider();
        }
        if (PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator.getPasteProvider();
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return this.getSelectedElement(Module.class) != null ? this.myDeleteModuleProvider : new DeleteHandler.DefaultDeleteProvider();
        }
        if (LangDataKeys.IDE_VIEW.is(dataId)) {
            return this.myIdeView;
        }
        return null;
    }

    @Nullable
    private <T> T getSelectedElement(Class<T> klass) {
        Object selectedValue;
        int modelSize;
        Object selectedValue1 = this.myModel.getSelectedValue();
        if (selectedValue1 == null && (modelSize = this.myModel.size()) > 0) {
            selectedValue1 = this.myModel.getElement(modelSize - 1);
        }
        return (T)((selectedValue = selectedValue1) != null && klass.isAssignableFrom(selectedValue.getClass()) ? selectedValue : null);
    }

    @Override
    public Point getBestPopupPosition() {
        MyItemLabel item;
        int index = this.myModel.getSelectedIndex();
        int modelSize = this.myModel.size();
        if (index == -1) {
            index = modelSize - 1;
        }
        if (index > -1 && index < modelSize && (item = this.getItem(index)) != null) {
            return new Point(item.getX(), item.getY() + item.getHeight());
        }
        return null;
    }

    public void installListeners() {
        final MyPsiTreeChangeAdapter psiListener = new MyPsiTreeChangeAdapter();
        final MyProblemListener problemListener = new MyProblemListener();
        final MyFileStatusListener fileStatusListener = new MyFileStatusListener();
        final MyTimerListener timerListener = new MyTimerListener();
        PsiManager.getInstance((Project)this.myProject).addPsiTreeChangeListener((PsiTreeChangeListener)psiListener);
        WolfTheProblemSolver.getInstance((Project)this.myProject).addProblemListener((WolfTheProblemSolver.ProblemListener)problemListener);
        FileStatusManager.getInstance((Project)this.myProject).addFileStatusListener((FileStatusListener)fileStatusListener);
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        actionManager.addTimerListener(10000, timerListener);
        final MessageBusConnection busConnection = this.myProject.getMessageBus().connect();
        busConnection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new MyModuleRootListener());
        busConnection.subscribe(NavBarModelListener.NAV_BAR, (Object)new NavBarModelListener(){

            @Override
            public void modelChanged() {
                NavBarPanel.this.scheduleListUpdate();
            }

            @Override
            public void selectionChanged() {
                NavBarPanel.this.updateItems();
                NavBarPanel.this.scrollSelectionToVisible();
            }
        });
        if (this.myDetacher != null) {
            this.uninstallListeners();
        }
        this.myDetacher = new Runnable(){

            @Override
            public void run() {
                ActionManagerEx.getInstanceEx().removeTimerListener(timerListener);
                busConnection.disconnect();
                WolfTheProblemSolver.getInstance((Project)NavBarPanel.this.myProject).removeProblemListener((WolfTheProblemSolver.ProblemListener)problemListener);
                PsiManager.getInstance((Project)NavBarPanel.this.myProject).removePsiTreeChangeListener((PsiTreeChangeListener)psiListener);
                FileStatusManager.getInstance((Project)NavBarPanel.this.myProject).removeFileStatusListener((FileStatusListener)fileStatusListener);
            }
        };
    }

    public void uninstallListeners() {
        this.myDetacher.run();
        this.myDetacher = null;
        this.myListUpdateAlarm.cancelAllRequests();
        this.myModelUpdateAlarm.cancelAllRequests();
    }

    public void installBorder(final int rightOffset) {
        this.setBorder(new Border(){

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                g.setColor(c.getBackground() != null ? c.getBackground().darker() : Color.darkGray);
                if (rightOffset == -1) {
                    g.drawLine(0, 0, width - 1, 0);
                } else {
                    g.drawLine(0, 0, width - rightOffset + 3, 0);
                }
                g.drawLine(0, height - 1, width, height - 1);
                if (rightOffset == -1) {
                    g.drawLine(0, 0, 0, height);
                    g.drawLine(width - 1, 0, width - 1, height - 1);
                }
            }

            @Override
            public Insets getBorderInsets(Component c) {
                return new Insets(3, 4, 3, 4);
            }

            @Override
            public boolean isBorderOpaque() {
                return true;
            }
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.installListeners();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.uninstallListeners();
    }

    public void updateState(boolean show) {
        this.updateModel();
        if (this.isShowing()) {
            MyItemLabel item;
            this.updateList();
            int selectedIndex = this.myModel.getSelectedIndex();
            if (show && selectedIndex > -1 && selectedIndex < this.myModel.size() && (item = this.getItem(selectedIndex)) != null) {
                IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)((Object)item), true);
            }
        }
    }

    public void showHint(@Nullable Editor editor, DataContext dataContext) {
        this.updateModel();
        if (this.myModel.isEmpty()) {
            return;
        }
        this.myHint = new LightweightHint(this){

            @Override
            public void hide() {
                super.hide();
                NavBarPanel.this.cancelPopup();
            }
        };
        this.myHint.setForceLightweightPopup(true);
        this.registerKeyboardAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavBarPanel.this.hideHint();
            }
        }, KeyStroke.getKeyStroke(27, 0), 0);
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Window focusedWindow = focusManager.getFocusedWindow();
        if (editor == null) {
            RelativePoint relativePoint = JBPopupFactory.getInstance().guessBestPopupLocation(dataContext);
            Component owner = focusManager.getFocusOwner();
            Component cmp = relativePoint.getComponent();
            if (cmp instanceof JComponent && cmp.isShowing()) {
                this.myHint.show((JComponent)cmp, relativePoint.getPoint().x, relativePoint.getPoint().y, owner instanceof JComponent ? (JComponent)owner : null);
            }
        } else {
            Container container = focusedWindow != null ? focusedWindow : editor.getContentComponent();
            Point p = AbstractPopup.getCenterOf(container, this);
            p.x -= container.getLocation().x;
            p.y = container.getHeight() / 4;
            HintManagerImpl.getInstanceImpl().showEditorHint(this.myHint, editor, p, 1, 0, true);
        }
        this.select();
    }

    public static boolean wolfHasProblemFilesBeneath(final PsiElement scope) {
        return WolfTheProblemSolver.getInstance((Project)scope.getProject()).hasProblemFilesBeneath((Condition)new Condition<VirtualFile>(){

            public boolean value(VirtualFile virtualFile) {
                if (scope instanceof PsiDirectory) {
                    PsiDirectory directory = (PsiDirectory)scope;
                    if (!VfsUtil.isAncestor((VirtualFile)directory.getVirtualFile(), (VirtualFile)virtualFile, (boolean)false)) {
                        return false;
                    }
                    return ModuleUtil.findModuleForFile((VirtualFile)virtualFile, (Project)scope.getProject()) == ModuleUtil.findModuleForPsiElement((PsiElement)scope);
                }
                if (scope instanceof PsiDirectoryContainer) {
                    PsiDirectory[] psiDirectories;
                    for (PsiDirectory directory : psiDirectories = ((PsiDirectoryContainer)scope).getDirectories()) {
                        if (!VfsUtil.isAncestor((VirtualFile)directory.getVirtualFile(), (VirtualFile)virtualFile, (boolean)false)) continue;
                        return true;
                    }
                }
                return false;
            }
        });
    }

    private void scheduleListUpdate() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NavBarPanel.this.myListUpdateAlarm.cancelAllRequests();
                NavBarPanel.this.myListUpdateAlarm.addRequest(new Runnable(){

                    @Override
                    public void run() {
                        if (NavBarPanel.this.myProject.isDisposed()) {
                            return;
                        }
                        NavBarPanel.this.updateList();
                    }
                }, 50);
            }
        });
    }

    private class MySiblingsListCellRenderer
    extends ColoredListCellRenderer {
        private MySiblingsListCellRenderer() {
        }

        protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            SimpleTextAttributes nameAttributes;
            boolean isProblemFile;
            Color color;
            String name;
            block9: {
                block7: {
                    PsiElement psiElement;
                    block8: {
                        this.setFocusBorderAroundIcon(false);
                        name = NavBarModel.getPresentableText(value, NavBarPanel.this.getWindow());
                        color = list.getForeground();
                        isProblemFile = false;
                        if (!(value instanceof PsiElement)) break block7;
                        psiElement = (PsiElement)value;
                        PsiFile psiFile = psiElement.getContainingFile();
                        if (psiFile == null) break block8;
                        VirtualFile vFile = psiFile.getVirtualFile();
                        if (vFile == null) break block9;
                        if (WolfTheProblemSolver.getInstance((Project)NavBarPanel.this.myProject).isProblemFile(vFile)) {
                            isProblemFile = true;
                        }
                        FileStatus status = FileStatusManager.getInstance((Project)NavBarPanel.this.myProject).getStatus(vFile);
                        color = status.getColor();
                        break block9;
                    }
                    isProblemFile = NavBarPanel.wolfHasProblemFilesBeneath(psiElement);
                    break block9;
                }
                if (value instanceof Module) {
                    Module module = (Module)value;
                    isProblemFile = WolfTheProblemSolver.getInstance((Project)NavBarPanel.this.myProject).hasProblemFilesBeneath(module);
                } else if (value instanceof Project) {
                    Module[] modules;
                    for (Module module : modules = ModuleManager.getInstance((Project)((Project)value)).getModules()) {
                        if (!WolfTheProblemSolver.getInstance((Project)NavBarPanel.this.myProject).hasProblemFilesBeneath(module)) continue;
                        isProblemFile = true;
                        break;
                    }
                }
            }
            if (isProblemFile) {
                TextAttributes attributes = new TextAttributes(color, null, Color.red, EffectType.WAVE_UNDERSCORE, 0);
                nameAttributes = SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes);
            } else {
                nameAttributes = new SimpleTextAttributes(0, color);
            }
            this.append(name, nameAttributes);
            this.setIcon(NavBarPanel.getIcon(value, false));
            this.setPaintFocusBorder(false);
            this.setBackground(selected ? UIUtil.getListSelectionBackground() : UIUtil.getListBackground());
        }
    }

    private class MyFileStatusListener
    implements FileStatusListener {
        private MyFileStatusListener() {
        }

        public void fileStatusesChanged() {
            NavBarPanel.this.scheduleListUpdate();
        }

        public void fileStatusChanged(@NotNull VirtualFile virtualFile) {
            if (virtualFile == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/navigationToolbar/NavBarPanel$MyFileStatusListener.fileStatusChanged must not be null");
            }
            NavBarPanel.this.scheduleListUpdate();
        }
    }

    private class MyProblemListener
    extends WolfTheProblemSolver.ProblemListener {
        private MyProblemListener() {
        }

        public void problemsAppeared(VirtualFile file) {
            NavBarPanel.this.scheduleListUpdate();
        }

        public void problemsDisappeared(VirtualFile file) {
            NavBarPanel.this.scheduleListUpdate();
        }
    }

    private class MyModuleRootListener
    implements ModuleRootListener {
        private MyModuleRootListener() {
        }

        public void beforeRootsChange(ModuleRootEvent event) {
        }

        public void rootsChanged(ModuleRootEvent event) {
            NavBarPanel.this.scheduleModelUpdate();
        }
    }

    private class MyPsiTreeChangeAdapter
    extends PsiTreeChangeAdapter {
        private MyPsiTreeChangeAdapter() {
        }

        public void childAdded(PsiTreeChangeEvent event) {
            NavBarPanel.this.scheduleModelUpdate();
        }

        public void childReplaced(PsiTreeChangeEvent event) {
            NavBarPanel.this.scheduleModelUpdate();
        }

        public void childMoved(PsiTreeChangeEvent event) {
            NavBarPanel.this.scheduleModelUpdate();
        }

        public void childrenChanged(PsiTreeChangeEvent event) {
            NavBarPanel.this.scheduleModelUpdate();
        }

        public void propertyChanged(PsiTreeChangeEvent event) {
            NavBarPanel.this.scheduleModelUpdate();
        }
    }

    private final class MyIdeView
    implements IdeView {
        private MyIdeView() {
        }

        public void selectElement(PsiElement element) {
            Navigatable navigatable;
            NavBarPanel.this.myModel.updateModel(element);
            if (element instanceof Navigatable && (navigatable = (Navigatable)element).canNavigate()) {
                ((Navigatable)element).navigate(true);
            }
            NavBarPanel.this.hideHint();
        }

        public PsiDirectory[] getDirectories() {
            PsiFile file;
            PsiDirectory dir = (PsiDirectory)NavBarPanel.this.getSelectedElement(PsiDirectory.class);
            if (dir != null && dir.isValid()) {
                return new PsiDirectory[]{dir};
            }
            PsiElement element = (PsiElement)NavBarPanel.this.getSelectedElement(PsiElement.class);
            if (element != null && element.isValid() && (file = element.getContainingFile()) != null) {
                PsiDirectory[] psiDirectoryArray;
                PsiDirectory psiDirectory = file.getContainingDirectory();
                if (psiDirectory != null) {
                    PsiDirectory[] psiDirectoryArray2 = new PsiDirectory[1];
                    psiDirectoryArray = psiDirectoryArray2;
                    psiDirectoryArray2[0] = psiDirectory;
                } else {
                    psiDirectoryArray = PsiDirectory.EMPTY_ARRAY;
                }
                return psiDirectoryArray;
            }
            PsiDirectoryContainer directoryContainer = (PsiDirectoryContainer)NavBarPanel.this.getSelectedElement(PsiDirectoryContainer.class);
            if (directoryContainer != null) {
                return directoryContainer.getDirectories();
            }
            Module module = (Module)NavBarPanel.this.getSelectedElement(Module.class);
            if (module != null && !module.isDisposed()) {
                ArrayList<PsiDirectory> dirs = new ArrayList<PsiDirectory>();
                VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots();
                PsiManager psiManager = PsiManager.getInstance((Project)NavBarPanel.this.myProject);
                for (VirtualFile virtualFile : sourceRoots) {
                    PsiDirectory directory = psiManager.findDirectory(virtualFile);
                    if (directory == null || !directory.isValid()) continue;
                    dirs.add(directory);
                }
                return dirs.toArray(new PsiDirectory[dirs.size()]);
            }
            return PsiDirectory.EMPTY_ARRAY;
        }

        public PsiDirectory getOrChooseDirectory() {
            return DirectoryChooserUtil.getOrChooseDirectory(this);
        }
    }

    private final class MyTimerListener
    implements TimerListener {
        private MyTimerListener() {
        }

        public ModalityState getModalityState() {
            return ModalityState.stateForComponent((Component)NavBarPanel.this);
        }

        public void run() {
            Dialog dialog;
            if (!NavBarPanel.this.isShowing()) {
                return;
            }
            Window mywindow = SwingUtilities.windowForComponent(NavBarPanel.this);
            if (mywindow != null && !mywindow.isActive()) {
                return;
            }
            Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
            if (window instanceof Dialog && (dialog = (Dialog)window).isModal() && !SwingUtilities.isDescendingFrom(NavBarPanel.this, dialog)) {
                return;
            }
            NavBarPanel.this.scheduleModelUpdate();
        }
    }

    protected class MyItemLabel
    extends SimpleColoredComponent {
        private final String myText;
        private final SimpleTextAttributes myAttributes;
        private final int myIndex;
        private final Icon myIcon;

        public MyItemLabel(int idx, Icon icon, String presentableText, SimpleTextAttributes textAttributes) {
            this.myIndex = idx;
            this.myText = presentableText;
            this.myIcon = icon;
            this.myAttributes = textAttributes;
            this.setIpad(new Insets(1, 2, 1, 2));
            this.update();
        }

        private void update() {
            this.clear();
            this.setIcon(this.myIcon);
            boolean focused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() == NavBarPanel.this;
            boolean selected = NavBarPanel.this.myModel.getSelectedIndex() == this.myIndex;
            this.setPaintFocusBorder(selected);
            this.setFocusBorderAroundIcon(selected);
            this.setBackground(selected && focused ? UIUtil.getListSelectionBackground() : UIUtil.getListBackground());
            Color fg = selected && focused ? UIUtil.getListSelectionForeground() : (NavBarPanel.this.myModel.getSelectedIndex() < this.myIndex && NavBarPanel.this.myModel.getSelectedIndex() != -1 ? UIUtil.getInactiveTextColor() : this.myAttributes.getFgColor());
            Color bg = selected && focused ? UIUtil.getListSelectionBackground() : this.myAttributes.getBgColor();
            this.append(this.myText, new SimpleTextAttributes(bg, fg, this.myAttributes.getWaveColor(), this.myAttributes.getStyle()));
            this.repaint();
        }
    }
}

