/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.macro;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public abstract class Macro {
    public static final ExtensionPointName<Macro> EP_NAME = ExtensionPointName.create((String)"com.intellij.macro");
    protected String myCachedPreview;

    @NonNls
    public abstract String getName();

    public abstract String getDescription();

    @Nullable
    public abstract String expand(DataContext var1) throws ExecutionCancelledException;

    public void cachePreview(DataContext dataContext) {
        try {
            this.myCachedPreview = this.expand(dataContext);
        }
        catch (ExecutionCancelledException e) {
            this.myCachedPreview = "";
        }
    }

    public final String preview() {
        return this.myCachedPreview;
    }

    static String getPath(VirtualFile file) {
        return file.getPath().replace('/', File.separatorChar);
    }

    static File getIOFile(VirtualFile file) {
        return new File(Macro.getPath(file));
    }

    @Nullable
    protected static VirtualFile getVirtualDirOrParent(DataContext dataContext) {
        VirtualFile vFile = (VirtualFile)PlatformDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (vFile != null && !vFile.isDirectory()) {
            vFile = vFile.getParent();
        }
        return vFile;
    }

    public static class Silent
    extends Macro {
        private final Macro myDelegate;
        private final String myValue;

        public Silent(Macro delegate, String value) {
            this.myDelegate = delegate;
            this.myValue = value;
        }

        @Override
        public String expand(DataContext dataContext) throws ExecutionCancelledException {
            return this.myValue;
        }

        @Override
        public String getDescription() {
            return this.myDelegate.getDescription();
        }

        @Override
        public String getName() {
            return this.myDelegate.getName();
        }
    }

    public static final class ExecutionCancelledException
    extends Exception {
    }
}

