/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl.convert;

import com.intellij.conversion.impl.ConversionServiceImpl;
import com.intellij.ide.impl.convert.ProjectFileVersion;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="ProjectFileVersion", storages={@Storage(id="other", file="$PROJECT_FILE$")})
public class ProjectFileVersionImpl
extends ProjectFileVersion
implements ProjectComponent,
PersistentStateComponent<ProjectFileVersionState> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.impl.convert.ProjectFileVersionImpl");
    @NonNls
    public static final String COMPONENT_NAME = "ProjectFileVersion";
    private Project myProject;

    public ProjectFileVersionImpl(Project project) {
        this.myProject = project;
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if (COMPONENT_NAME == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/impl/convert/ProjectFileVersionImpl.getComponentName must not return null");
        }
        return COMPONENT_NAME;
    }

    public void initComponent() {
    }

    public void disposeComponent() {
        String filePath;
        if (this.myProject.isDefault() || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        IProjectStore stateStore = ((ProjectEx)this.myProject).getStateStore();
        if (stateStore.getStorageScheme() == StorageScheme.DEFAULT) {
            filePath = stateStore.getProjectFilePath();
        } else {
            VirtualFile baseDir = stateStore.getProjectBaseDir();
            String string = filePath = baseDir != null ? baseDir.getPath() : null;
        }
        if (filePath != null) {
            ConversionServiceImpl.saveConversionResult(FileUtil.toSystemDependentName((String)filePath));
        } else {
            LOG.info("Cannot save conversion result: filePath == null");
        }
    }

    public ProjectFileVersionState getState() {
        return null;
    }

    public void loadState(ProjectFileVersionState object) {
    }

    public static class ProjectFileVersionState {
    }
}

