/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.ModuleStructureComponent;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.TimerListener;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class StructureViewWrapperImpl
implements StructureViewWrapper,
Disposable {
    private final Project myProject;
    private VirtualFile myFile;
    private StructureView myStructureView;
    private ModuleStructureComponent myModuleStructureComponent;
    private final JPanel myPanel;
    private final MergingUpdateQueue myUpdateQueue;
    private final String myKey = new String("DATA_SELECTOR");
    private Runnable myPendingSelection;

    public StructureViewWrapperImpl(Project project) {
        this.myProject = project;
        this.myPanel = new ContentPanel();
        this.myPanel.setBackground(UIUtil.getTreeTextBackground());
        this.myUpdateQueue = new MergingUpdateQueue("StructureView", Registry.intValue((String)"structureView.coalesceTime"), false, (JComponent)this.myPanel, (Disposable)this, (JComponent)this.myPanel, true);
        this.myUpdateQueue.setRestartTimerOnAdd(true);
        ActionManager.getInstance().addTimerListener(500, new TimerListener(){

            public ModalityState getModalityState() {
                return ModalityState.stateForComponent((Component)StructureViewWrapperImpl.this.myPanel);
            }

            public void run() {
                StructureViewWrapperImpl.this.checkUpdate();
            }
        });
        this.getComponent().addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 2L) != 0L) {
                    StructureViewWrapperImpl.this.scheduleRebuild();
                }
            }
        });
    }

    private void checkUpdate() {
        if (this.myProject.isDisposed()) {
            return;
        }
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (SwingUtilities.isDescendingFrom(this.myPanel, owner) || JBPopupFactory.getInstance().isPopupActive()) {
            return;
        }
        DataContext dataContext = DataManager.getInstance().getDataContext(owner);
        if (dataContext.getData(this.myKey) == this) {
            return;
        }
        if (PlatformDataKeys.PROJECT.getData(dataContext) != this.myProject) {
            return;
        }
        VirtualFile[] files = (VirtualFile[])PlatformDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        if (files != null && files.length == 1) {
            this.setFile(files[0]);
        } else if (files != null && files.length > 1) {
            this.setFile(null);
        }
    }

    private void setFile(VirtualFile file) {
        if (!Comparing.equal((Object)file, (Object)this.myFile)) {
            this.myFile = file;
            this.scheduleRebuild();
        }
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void dispose() {
        this.rebuild();
    }

    @Override
    public boolean selectCurrentElement(final FileEditor fileEditor, final VirtualFile file, final boolean requestFocus) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (StructureViewWrapperImpl.this.myStructureView != null) {
                    if (!Comparing.equal((Object)StructureViewWrapperImpl.this.myStructureView.getFileEditor(), (Object)fileEditor)) {
                        StructureViewWrapperImpl.this.myFile = file;
                        StructureViewWrapperImpl.this.rebuild();
                    }
                    StructureViewWrapperImpl.this.myStructureView.navigateToSelectedElement(requestFocus);
                }
            }
        };
        if (this.isStructureViewShowing()) {
            if (this.myUpdateQueue.isEmpty()) {
                runnable.run();
            } else {
                this.myPendingSelection = runnable;
            }
        } else {
            this.myPendingSelection = runnable;
        }
        return true;
    }

    private void scheduleRebuild() {
        this.myUpdateQueue.queue(new Update("rebuild"){

            public void run() {
                if (StructureViewWrapperImpl.this.myProject.isDisposed()) {
                    return;
                }
                StructureViewWrapperImpl.this.rebuild();
            }
        });
    }

    public void rebuild() {
        VirtualFile[] selectedFiles;
        if (this.myProject.isDisposed()) {
            return;
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        boolean hadFocus = ToolWindowId.STRUCTURE_VIEW.equals(ToolWindowManager.getInstance((Project)this.myProject).getActiveToolWindowId());
        Dimension referenceSize = null;
        if (this.myStructureView != null) {
            if (this.myStructureView instanceof StructureView.Scrollable) {
                referenceSize = ((StructureView.Scrollable)this.myStructureView).getCurrentSize();
            }
            this.myStructureView.storeState();
            Disposer.dispose((Disposable)this.myStructureView);
            this.myStructureView = null;
        }
        if (this.myModuleStructureComponent != null) {
            Disposer.dispose((Disposable)this.myModuleStructureComponent);
            this.myModuleStructureComponent = null;
        }
        this.myPanel.removeAll();
        if (!this.isStructureViewShowing()) {
            return;
        }
        VirtualFile file = this.myFile;
        if (file == null && (selectedFiles = FileEditorManager.getInstance((Project)this.myProject).getSelectedFiles()).length > 0) {
            file = selectedFiles[0];
        }
        if (file != null && file.isValid()) {
            if (file.isDirectory()) {
                Module module;
                if (ProjectRootsUtil.isModuleContentRoot(file, this.myProject) && (module = ModuleUtil.findModuleForFile((VirtualFile)file, (Project)this.myProject)) != null) {
                    JComponent focusedComponent;
                    this.myModuleStructureComponent = new ModuleStructureComponent(module);
                    this.myPanel.add((Component)((Object)this.myModuleStructureComponent), "Center");
                    if (hadFocus && (focusedComponent = IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)((Object)this.myModuleStructureComponent))) != null) {
                        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)focusedComponent, true);
                    }
                }
            } else {
                StructureViewBuilder structureViewBuilder;
                FileEditor editor = FileEditorManager.getInstance((Project)this.myProject).getSelectedEditor(file);
                boolean needDisposeEditor = false;
                if (editor == null) {
                    editor = this.createTempFileEditor(file);
                    needDisposeEditor = true;
                }
                if (editor != null && editor.isValid() && (structureViewBuilder = editor.getStructureViewBuilder()) != null) {
                    JComponent focusedComponent;
                    this.myStructureView = structureViewBuilder.createStructureView(editor, this.myProject);
                    if (this.myStructureView instanceof StructureView.Scrollable) {
                        ((StructureView.Scrollable)this.myStructureView).setReferenceSizeWhileInitializing(referenceSize);
                    }
                    this.myPanel.add((Component)this.myStructureView.getComponent(), "Center");
                    if (hadFocus && (focusedComponent = IdeFocusTraversalPolicy.getPreferredFocusedComponent(this.myStructureView.getComponent())) != null) {
                        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)focusedComponent, true);
                    }
                    this.myStructureView.restoreState();
                    this.myStructureView.centerSelectedRow();
                }
                if (needDisposeEditor && editor != null) {
                    Disposer.dispose((Disposable)editor);
                }
            }
        }
        if (this.myModuleStructureComponent == null && this.myStructureView == null) {
            this.myPanel.add((Component)new JLabel(IdeBundle.message((String)"message.nothing.to.show.in.structure.view", (Object[])new Object[0]), 0), "Center");
        }
        this.myPanel.validate();
        this.myPanel.repaint();
        if (this.myPendingSelection != null) {
            Runnable selection = this.myPendingSelection;
            this.myPendingSelection = null;
            selection.run();
        }
    }

    @Nullable
    private FileEditor createTempFileEditor(VirtualFile file) {
        int i$ = 0;
        FileEditorProviderManager editorProviderManager = FileEditorProviderManager.getInstance();
        FileEditorProvider[] providers = editorProviderManager.getProviders(this.myProject, file);
        FileEditorProvider[] arr$ = providers;
        int len$ = arr$.length;
        if (i$ < len$) {
            FileEditorProvider provider = arr$[i$];
            return provider.createEditor(this.myProject, file);
        }
        return null;
    }

    protected boolean isStructureViewShowing() {
        ToolWindowManager windowManager = ToolWindowManager.getInstance((Project)this.myProject);
        ToolWindow toolWindow = windowManager.getToolWindow(ToolWindowId.STRUCTURE_VIEW);
        return toolWindow != null && toolWindow.isVisible();
    }

    private class ContentPanel
    extends JPanel
    implements DataProvider {
        public ContentPanel() {
            super(new BorderLayout());
        }

        public Object getData(@NonNls String dataId) {
            if (dataId == StructureViewWrapperImpl.this.myKey) {
                return StructureViewWrapperImpl.this;
            }
            return null;
        }
    }
}

