/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.structureView.StructureViewFactoryEx;
import com.intellij.ide.structureView.StructureViewWrapper;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;

public class StructureViewSelectInTarget
implements SelectInTarget {
    private final Project myProject;

    public StructureViewSelectInTarget(Project project) {
        this.myProject = project;
    }

    public String toString() {
        return IdeBundle.message((String)"select.in.file.structure", (Object[])new Object[0]);
    }

    public boolean canSelect(SelectInContext context) {
        return context.getFileEditorProvider() != null;
    }

    public void selectIn(final SelectInContext context, final boolean requestFocus) {
        final FileEditor fileEditor = context.getFileEditorProvider().openFileEditor();
        ToolWindowManager windowManager = ToolWindowManager.getInstance((Project)context.getProject());
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                StructureViewFactoryEx.getInstanceEx(StructureViewSelectInTarget.this.myProject).runWhenInitialized(new Runnable(){

                    @Override
                    public void run() {
                        StructureViewWrapper structureView = StructureViewSelectInTarget.this.getStructureViewWrapper();
                        structureView.selectCurrentElement(fileEditor, context.getVirtualFile(), requestFocus);
                    }
                });
            }
        };
        if (requestFocus) {
            windowManager.getToolWindow(ToolWindowId.STRUCTURE_VIEW).activate(runnable);
        } else {
            runnable.run();
        }
    }

    private StructureViewWrapper getStructureViewWrapper() {
        return StructureViewFactoryEx.getInstanceEx(this.myProject).getStructureViewWrapper();
    }

    public String getToolWindowId() {
        return ToolWindowId.STRUCTURE_VIEW;
    }

    public String getMinorViewId() {
        return null;
    }

    public float getWeight() {
        return 4.0f;
    }
}

