/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetFinder;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetRootsProvider;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WrappingVirtualFile;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectSettingsSelectInTarget
implements SelectInTarget,
DumbAware {
    public boolean canSelect(SelectInContext context) {
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)context.getProject()).getFileIndex();
        VirtualFile file = context.getVirtualFile();
        if (file instanceof WrappingVirtualFile) {
            Object o = ((WrappingVirtualFile)file).getWrappedObject(context.getProject());
            return o instanceof Facet;
        }
        return fileIndex.isInContent(file) || fileIndex.isInLibraryClasses(file) || fileIndex.isInLibrarySource(file);
    }

    public void selectIn(SelectInContext context, boolean requestFocus) {
        Module module;
        Facet facet;
        final Project project = context.getProject();
        VirtualFile file = context.getVirtualFile();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        if (file instanceof WrappingVirtualFile) {
            Object o = ((WrappingVirtualFile)file).getWrappedObject(project);
            facet = o instanceof Facet ? (Facet)o : null;
            module = facet == null ? null : facet.getModule();
        } else {
            module = fileIndex.getModuleForFile(file);
            facet = ProjectSettingsSelectInTarget.findFacet(project, file, fileIndex);
        }
        if (module != null || facet != null) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (facet != null) {
                        ModulesConfigurator.showFacetSettingsDialog(facet, null);
                    } else {
                        ModulesConfigurator.showDialog(project, module.getName(), null, false);
                    }
                }
            });
            return;
        }
        final LibraryOrderEntry libraryOrderEntry = ProjectSettingsSelectInTarget.findLibrary(file, fileIndex);
        if (libraryOrderEntry != null) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    ModulesConfigurator.showLibrarySettings(project, libraryOrderEntry);
                }
            });
            return;
        }
        final Sdk jdk = ProjectSettingsSelectInTarget.findJdk(file, fileIndex);
        if (jdk != null) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    ModulesConfigurator.showSdkSettings(project, jdk);
                }
            });
        }
    }

    @Nullable
    private static LibraryOrderEntry findLibrary(VirtualFile file, ProjectFileIndex fileIndex) {
        List entries = fileIndex.getOrderEntriesForFile(file);
        for (OrderEntry entry : entries) {
            if (!(entry instanceof LibraryOrderEntry)) continue;
            return (LibraryOrderEntry)entry;
        }
        return null;
    }

    @Nullable
    private static Sdk findJdk(VirtualFile file, ProjectFileIndex fileIndex) {
        List entries = fileIndex.getOrderEntriesForFile(file);
        for (OrderEntry entry : entries) {
            if (!(entry instanceof JdkOrderEntry)) continue;
            return ((JdkOrderEntry)entry).getJdk();
        }
        return null;
    }

    @Nullable
    private static Facet findFacet(@NotNull Project project, @NotNull VirtualFile file, @NotNull ProjectFileIndex fileIndex) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/impl/ProjectSettingsSelectInTarget.findFacet must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/impl/ProjectSettingsSelectInTarget.findFacet must not be null");
        }
        if (fileIndex == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/ide/impl/ProjectSettingsSelectInTarget.findFacet must not be null");
        }
        if (!fileIndex.isInSourceContent(file)) {
            for (FacetTypeId id : FacetTypeRegistry.getInstance().getFacetTypeIds()) {
                Facet facet;
                if (!ProjectSettingsSelectInTarget.hasFacetWithRoots(project, id) || (facet = FacetFinder.getInstance((Project)project).findFacet(file, id)) == null) continue;
                return facet;
            }
        }
        return null;
    }

    private static <F extends Facet> boolean hasFacetWithRoots(@NotNull Project project, @NotNull FacetTypeId<F> id) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/impl/ProjectSettingsSelectInTarget.hasFacetWithRoots must not be null");
        }
        if (id == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/impl/ProjectSettingsSelectInTarget.hasFacetWithRoots must not be null");
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            Collection facets = FacetManager.getInstance((Module)module).getFacetsByType(id);
            Iterator iterator = facets.iterator();
            if (!iterator.hasNext()) continue;
            return iterator.next() instanceof FacetRootsProvider;
        }
        return false;
    }

    public String getToolWindowId() {
        return null;
    }

    public String getMinorViewId() {
        return null;
    }

    public String toString() {
        return IdeBundle.message((String)"select.in.project.settings", (Object[])new Object[0]);
    }

    public float getWeight() {
        return 10.0f;
    }
}

