/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;

public class PatchProjectUtil {
    private PatchProjectUtil() {
    }

    public static void patchProject(final Project project) {
        final Map<Pattern, Set<Pattern>> excludePatterns = PatchProjectUtil.loadPatterns("idea.exclude.patterns");
        final Map<Pattern, Set<Pattern>> includePatterns = PatchProjectUtil.loadPatterns("idea.include.patterns");
        if (excludePatterns.isEmpty() && includePatterns.isEmpty()) {
            return;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        final ModifiableModuleModel modulesModel = ModuleManager.getInstance((Project)project).getModifiableModel();
        final Module[] modules = modulesModel.getModules();
        final ModifiableRootModel[] models = new ModifiableRootModel[modules.length];
        for (int i = 0; i < modules.length; ++i) {
            ContentEntry[] contentEntries;
            models[i] = ModuleRootManager.getInstance((Module)modules[i]).getModifiableModel();
            final int idx = i;
            for (final ContentEntry contentEntry : contentEntries = models[i].getContentEntries()) {
                final VirtualFile contentRoot = contentEntry.getFile();
                if (contentRoot == null) continue;
                final HashSet<VirtualFile> included = new HashSet<VirtualFile>();
                PatchProjectUtil.iterate(contentRoot, new ContentIterator(){

                    public boolean processFile(VirtualFile fileOrDir) {
                        Set dirPatterns;
                        String relativeName = VfsUtil.getRelativePath((VirtualFile)fileOrDir, (VirtualFile)contentRoot, (char)'/');
                        for (Pattern module : excludePatterns.keySet()) {
                            if (module != null && !module.matcher(modules[idx].getName()).matches()) continue;
                            dirPatterns = (Set)excludePatterns.get(module);
                            for (Pattern pattern : dirPatterns) {
                                if (!pattern.matcher(relativeName).matches()) continue;
                                contentEntry.addExcludeFolder(fileOrDir);
                                return false;
                            }
                        }
                        if (includePatterns.isEmpty()) {
                            return true;
                        }
                        for (Pattern module : includePatterns.keySet()) {
                            if (module != null && !module.matcher(modules[idx].getName()).matches()) continue;
                            dirPatterns = (Set)includePatterns.get(module);
                            for (Pattern pattern : dirPatterns) {
                                if (!pattern.matcher(relativeName).matches()) continue;
                                included.add(fileOrDir);
                                return true;
                            }
                        }
                        return true;
                    }
                }, index);
                PatchProjectUtil.processIncluded(contentEntry, included);
            }
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                ProjectRootManagerEx.getInstanceEx(project).multiCommit(modulesModel, models);
            }
        });
    }

    public static void processIncluded(ContentEntry contentEntry, Set<VirtualFile> included) {
        if (included.isEmpty()) {
            return;
        }
        HashSet<VirtualFile> parents = new HashSet<VirtualFile>();
        for (VirtualFile file : included) {
            if (file == contentEntry.getFile()) {
                return;
            }
            VirtualFile parent = file.getParent();
            if (parent == null || parents.contains(parent)) continue;
            parents.add(parent);
            for (VirtualFile toExclude : parent.getChildren()) {
                boolean toExcludeSibling = true;
                for (VirtualFile includeRoot : included) {
                    if (!VfsUtil.isAncestor((VirtualFile)toExclude, (VirtualFile)includeRoot, (boolean)false)) continue;
                    toExcludeSibling = false;
                }
                if (!toExcludeSibling) continue;
                contentEntry.addExcludeFolder(toExclude);
            }
        }
        PatchProjectUtil.processIncluded(contentEntry, parents);
    }

    public static void iterate(VirtualFile contentRoot, ContentIterator iterator, ProjectFileIndex idx) {
        VirtualFile[] files;
        if (!iterator.processFile(contentRoot)) {
            return;
        }
        if (idx.getModuleForFile(contentRoot) == null) {
            return;
        }
        for (VirtualFile file : files = contentRoot.getChildren()) {
            PatchProjectUtil.iterate(file, iterator, idx);
        }
    }

    public static Map<Pattern, Set<Pattern>> loadPatterns(@NonNls String propertyKey) {
        HashMap<Pattern, Set<Pattern>> result = new HashMap<Pattern, Set<Pattern>>();
        String patterns = System.getProperty(propertyKey);
        if (patterns != null) {
            String[] pathPatterns;
            for (String excludedPattern : pathPatterns = patterns.split(";")) {
                String module = null;
                int idx = 0;
                if (excludedPattern.startsWith("[")) {
                    idx = excludedPattern.indexOf("]") + 1;
                    module = excludedPattern.substring(1, idx - 1);
                }
                Pattern modulePattern = module != null ? Pattern.compile(StringUtil.replace(module, (String)"*", (String)".*")) : null;
                Pattern pattern = Pattern.compile(FileUtil.convertAntToRegexp((String)excludedPattern.substring(idx)));
                HashSet<Pattern> dirPatterns = (HashSet<Pattern>)result.get(modulePattern);
                if (dirPatterns == null) {
                    dirPatterns = new HashSet<Pattern>();
                    result.put(modulePattern, dirPatterns);
                }
                dirPatterns.add(pattern);
            }
        }
        return result;
    }
}

