/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.newProjectWizard.AddModuleWizard;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.module.LanguageLevelUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewProjectUtil {
    private NewProjectUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createNewProject(Project projectToClose, @Nullable String defaultPath) {
        boolean proceed = ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                ProjectManager.getInstance().getDefaultProject();
            }
        }, ProjectBundle.message((String)"project.new.wizard.progress.title", (Object[])new Object[0]), true, null);
        if (!proceed) {
            return;
        }
        AddModuleWizard dialog = new AddModuleWizard(null, ModulesProvider.EMPTY_MODULES_PROVIDER, defaultPath);
        dialog.show();
        if (!dialog.isOK()) {
            return;
        }
        ProjectManagerEx projectManager = ProjectManagerEx.getInstanceEx();
        String projectFilePath = dialog.getNewProjectFilePath();
        ProjectBuilder projectBuilder = dialog.getProjectBuilder();
        try {
            Project newProject;
            File ideaDir;
            if (StorageScheme.DIRECTORY_BASED == dialog.getStorageScheme() && !(ideaDir = new File(projectFilePath + File.separator + ".idea")).exists() && !ideaDir.mkdirs()) {
                Messages.showErrorDialog((String)("Unable to create '.idea' directory at: " + projectFilePath), (String)"Project initialization failed");
                return;
            }
            Project project = newProject = projectBuilder == null || !projectBuilder.isUpdate() ? projectManager.newProject(dialog.getProjectName(), projectFilePath, true, false) : projectToClose;
            if (newProject == null) {
                return;
            }
            final Sdk jdk = dialog.getNewProjectJdk();
            if (jdk != null) {
                CommandProcessor.getInstance().executeCommand(newProject, new Runnable(){

                    @Override
                    public void run() {
                        ApplicationManager.getApplication().runWriteAction(new Runnable(){

                            @Override
                            public void run() {
                                NewProjectUtil.applyJdkToProject(newProject, jdk);
                            }
                        });
                    }
                }, null, null);
            }
            final String compileOutput = dialog.getNewCompileOutput();
            CommandProcessor.getInstance().executeCommand(newProject, new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            String canonicalPath = compileOutput;
                            try {
                                canonicalPath = FileUtil.resolveShortWindowsName((String)compileOutput);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            canonicalPath = FileUtil.toSystemIndependentName((String)canonicalPath);
                            CompilerProjectExtension.getInstance((Project)newProject).setCompilerOutputUrl(VfsUtil.pathToUrl((String)canonicalPath));
                        }
                    });
                }
            }, null, null);
            newProject.save();
            if (projectBuilder != null && !projectBuilder.validate(projectToClose, newProject)) {
                return;
            }
            if (newProject != projectToClose) {
                NewProjectUtil.closePreviousProject(projectToClose);
            }
            if (projectBuilder != null) {
                projectBuilder.commit(newProject, null, ModulesProvider.EMPTY_MODULES_PROVIDER);
            }
            final boolean need2OpenProjectStructure = projectBuilder == null || projectBuilder.isOpenProjectSettingsAfter();
            StartupManager.getInstance((Project)newProject).registerPostStartupActivity(new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (newProject.isDisposed()) {
                                return;
                            }
                            if (need2OpenProjectStructure) {
                                ModulesConfigurator.showDialog(newProject, null, null, true);
                            }
                            ApplicationManager.getApplication().invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (newProject.isDisposed()) {
                                        return;
                                    }
                                    ToolWindow toolWindow = ToolWindowManager.getInstance((Project)newProject).getToolWindow(ToolWindowId.PROJECT_VIEW);
                                    if (toolWindow != null) {
                                        toolWindow.activate(null);
                                    }
                                }
                            }, ModalityState.NON_MODAL);
                        }
                    });
                }
            });
            if (newProject != projectToClose) {
                ProjectUtil.updateLastProjectLocation(projectFilePath);
                projectManager.openProject(newProject);
            }
        }
        finally {
            if (projectBuilder != null) {
                projectBuilder.cleanup();
            }
        }
    }

    public static void applyJdkToProject(@NotNull Project project, @NotNull Sdk jdk) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/impl/NewProjectUtil.applyJdkToProject must not be null");
        }
        if (jdk == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/impl/NewProjectUtil.applyJdkToProject must not be null");
        }
        String versionString = jdk.getVersionString();
        if (versionString == null) {
            return;
        }
        ProjectRootManagerEx rootManager = ProjectRootManagerEx.getInstanceEx(project);
        rootManager.setProjectJdk(jdk);
        LanguageLevel level = LanguageLevelUtil.getDefaultLanguageLevel((String)versionString);
        LanguageLevelProjectExtension ext = LanguageLevelProjectExtension.getInstance((Project)project);
        if (level.compareTo((Enum)ext.getLanguageLevel()) < 0) {
            ext.setLanguageLevel(level);
        }
    }

    public static void closePreviousProject(Project projectToClose) {
        int exitCode;
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        if (openProjects.length > 0 && (exitCode = Messages.showDialog((String)IdeBundle.message((String)"prompt.open.project.in.new.frame", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.new.project", (Object[])new Object[0]), (String[])new String[]{IdeBundle.message((String)"button.newframe", (Object[])new Object[0]), IdeBundle.message((String)"button.existingframe", (Object[])new Object[0])}, (int)1, (Icon)Messages.getQuestionIcon())) == 1) {
            ProjectUtil.closeProject(projectToClose != null ? projectToClose : openProjects[openProjects.length - 1]);
        }
    }
}

