/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter.custom.impl;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ModifyKeywordDialog
extends DialogWrapper {
    private final JTextField myKeywordName = new JTextField();

    public ModifyKeywordDialog(Component parent, String initialValue) {
        super(parent, false);
        if (initialValue == null || "".equals(initialValue)) {
            this.setTitle(IdeBundle.message((String)"title.add.new.keyword", (Object[])new Object[0]));
        } else {
            this.setTitle(IdeBundle.message((String)"title.edit.keyword", (Object[])new Object[0]));
        }
        this.init();
        this.myKeywordName.setText(initialValue);
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.weightx = 0.0;
        gc.insets = new Insets(5, 0, 5, 5);
        panel.add((Component)new JLabel(IdeBundle.message((String)"editbox.keyword", (Object[])new Object[0])), gc);
        gc = new GridBagConstraints();
        gc.gridx = 1;
        gc.gridy = 0;
        gc.weightx = 1.0;
        gc.fill = 2;
        gc.gridwidth = 2;
        gc.insets = new Insets(0, 0, 5, 0);
        panel.add((Component)this.myKeywordName, gc);
        panel.setPreferredSize(new Dimension(220, 40));
        return panel;
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    protected void doOKAction() {
        String keywordName = this.myKeywordName.getText().trim();
        if (keywordName.length() == 0) {
            Messages.showMessageDialog((Component)this.getContentPane(), (String)IdeBundle.message((String)"error.keyword.cannot.be.empty", (Object[])new Object[0]), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return;
        }
        if (keywordName.indexOf(32) >= 0) {
            Messages.showMessageDialog((Component)this.getContentPane(), (String)IdeBundle.message((String)"error.keyword.may.not.contain.spaces", (Object[])new Object[0]), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return;
        }
        super.doOKAction();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myKeywordName;
    }

    public String getKeywordName() {
        return this.myKeywordName.getText();
    }
}

