/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.highlighter.XmlLikeFileType;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlFileType
extends XmlLikeFileType {
    @NonNls
    public static final String DOT_DEFAULT_EXTENSION = ".html";
    private static final Icon ICON = IconLoader.getIcon((String)"/fileTypes/html.png");

    public HtmlFileType() {
        super((Language)HTMLLanguage.INSTANCE);
    }

    public HtmlFileType(Language language) {
        super(language);
    }

    @NotNull
    public String getName() {
        if ("HTML" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/highlighter/HtmlFileType.getName must not return null");
        }
        return "HTML";
    }

    @NotNull
    public String getDescription() {
        String string = IdeBundle.message((String)"filetype.description.html", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/highlighter/HtmlFileType.getDescription must not return null");
        }
        return string;
    }

    @NotNull
    public String getDefaultExtension() {
        if ("html" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/highlighter/HtmlFileType.getDefaultExtension must not return null");
        }
        return "html";
    }

    public Icon getIcon() {
        return ICON;
    }

    @Override
    public String getCharset(@NotNull VirtualFile file, byte[] content) {
        String strContent;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/highlighter/HtmlFileType.getCharset must not be null");
        }
        String charset = XmlUtil.extractXmlEncodingFromProlog(content);
        if (charset != null) {
            return charset;
        }
        try {
            strContent = new String(content, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        Charset c = HtmlUtil.detectCharsetFromMetaHttpEquiv(strContent);
        return c == null ? null : c.name();
    }

    @Override
    public Charset extractCharsetFromFileContent(@Nullable Project project, @Nullable VirtualFile file, @NotNull String content) {
        if (content == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/ide/highlighter/HtmlFileType.extractCharsetFromFileContent must not be null");
        }
        String name = XmlUtil.extractXmlEncodingFromProlog(content);
        Charset charset = CharsetToolkit.forName((String)name);
        if (charset != null) {
            return charset;
        }
        return HtmlUtil.detectCharsetFromMetaHttpEquiv(content);
    }
}

