/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.method;

import com.intellij.ide.hierarchy.HierarchyBrowserManager;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.hierarchy.method.MethodHierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.method.MethodHierarchyUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.Nullable;

public final class MethodHierarchyTreeStructure
extends HierarchyTreeStructure {
    private final SmartPsiElementPointer myMethod;

    public MethodHierarchyTreeStructure(Project project, PsiMethod method) {
        super(project, null);
        this.myBaseDescriptor = this.buildHierarchyElement(project, method);
        ((MethodHierarchyNodeDescriptor)this.myBaseDescriptor).setTreeStructure(this);
        this.myMethod = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)method);
        this.setBaseElement(this.myBaseDescriptor);
    }

    private HierarchyNodeDescriptor buildHierarchyElement(Project project, PsiMethod method) {
        PsiClass psiClass;
        int i;
        PsiClass suitableBaseClass = MethodHierarchyTreeStructure.findSuitableBaseClass(method);
        MethodHierarchyNodeDescriptor descriptor = null;
        ArrayList<PsiClass> superClasses = MethodHierarchyTreeStructure.createSuperClasses(suitableBaseClass);
        if (!suitableBaseClass.equals(method.getContainingClass())) {
            superClasses.add(0, suitableBaseClass);
        }
        for (i = superClasses.size() - 1; i >= 0 && MethodHierarchyUtil.findBaseMethodInClass(method, psiClass = superClasses.get(i), false) == null; --i) {
            superClasses.remove(i);
        }
        for (i = superClasses.size() - 1; i >= 0; --i) {
            PsiClass superClass = superClasses.get(i);
            MethodHierarchyNodeDescriptor newDescriptor = new MethodHierarchyNodeDescriptor(project, descriptor, superClass, false, this);
            if (descriptor != null) {
                descriptor.setCachedChildren((Object[])new HierarchyNodeDescriptor[]{newDescriptor});
            }
            descriptor = newDescriptor;
        }
        MethodHierarchyNodeDescriptor newDescriptor = new MethodHierarchyNodeDescriptor(project, descriptor, method.getContainingClass(), true, this);
        if (descriptor != null) {
            descriptor.setCachedChildren((Object[])new HierarchyNodeDescriptor[]{newDescriptor});
        }
        return newDescriptor;
    }

    private static ArrayList<PsiClass> createSuperClasses(PsiClass aClass) {
        if (!aClass.isValid()) {
            return new ArrayList<PsiClass>();
        }
        ArrayList<PsiClass> superClasses = new ArrayList<PsiClass>();
        while (!MethodHierarchyTreeStructure.isJavaLangObject(aClass)) {
            PsiClass aClass1 = aClass;
            PsiClass[] superTypes = aClass1.getSupers();
            PsiClass superType = null;
            for (PsiClass type : superTypes) {
                if (type.isInterface() || MethodHierarchyTreeStructure.isJavaLangObject(type)) continue;
                superType = type;
                break;
            }
            if (superType == null) {
                for (PsiClass type : superTypes) {
                    if (MethodHierarchyTreeStructure.isJavaLangObject(type)) continue;
                    superType = type;
                    break;
                }
            }
            if (superType == null || superClasses.contains(superType)) break;
            superClasses.add(superType);
            aClass = superType;
        }
        return superClasses;
    }

    private static boolean isJavaLangObject(PsiClass aClass) {
        return "java.lang.Object".equals(aClass.getQualifiedName());
    }

    private static PsiClass findSuitableBaseClass(PsiMethod method) {
        PsiClass containingClass = method.getContainingClass();
        if (containingClass instanceof PsiAnonymousClass) {
            return containingClass;
        }
        PsiClass superClass = containingClass.getSuperClass();
        if (superClass == null) {
            return containingClass;
        }
        if (MethodHierarchyUtil.findBaseMethodInClass(method, superClass, true) == null) {
            for (PsiClass anInterface : containingClass.getInterfaces()) {
                if (MethodHierarchyUtil.findBaseMethodInClass(method, anInterface, true) == null) continue;
                return anInterface;
            }
        }
        return containingClass;
    }

    @Nullable
    public final PsiMethod getBaseMethod() {
        PsiElement element = this.myMethod.getElement();
        return element instanceof PsiMethod ? (PsiMethod)element : null;
    }

    @Override
    protected final Object[] buildChildren(HierarchyNodeDescriptor descriptor) {
        PsiClass psiClass = ((MethodHierarchyNodeDescriptor)descriptor).getPsiClass();
        Collection<PsiClass> subclasses = MethodHierarchyTreeStructure.getSubclasses(psiClass);
        ArrayList<MethodHierarchyNodeDescriptor> descriptors = new ArrayList<MethodHierarchyNodeDescriptor>(subclasses.size());
        for (PsiClass aClass : subclasses) {
            if (HierarchyBrowserManager.getInstance((Project)this.myProject).getState().HIDE_CLASSES_WHERE_METHOD_NOT_IMPLEMENTED && this.shouldHideClass(aClass)) continue;
            MethodHierarchyNodeDescriptor d = new MethodHierarchyNodeDescriptor(this.myProject, descriptor, aClass, false, this);
            descriptors.add(d);
        }
        return descriptors.toArray(new HierarchyNodeDescriptor[descriptors.size()]);
    }

    private static Collection<PsiClass> getSubclasses(PsiClass psiClass) {
        if (psiClass instanceof PsiAnonymousClass || psiClass.hasModifierProperty("final")) {
            return Collections.emptyList();
        }
        return ClassInheritorsSearch.search((PsiClass)psiClass, (SearchScope)psiClass.getUseScope(), (boolean)false).findAll();
    }

    private boolean shouldHideClass(PsiClass psiClass) {
        if (this.getMethod(psiClass, false) != null || this.isSuperClassForBaseClass(psiClass)) {
            return false;
        }
        if (this.hasBaseClassMethod(psiClass) || this.isAbstract((PsiModifierListOwner)psiClass)) {
            for (PsiClass subclass : MethodHierarchyTreeStructure.getSubclasses(psiClass)) {
                if (this.shouldHideClass(subclass)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isAbstract(PsiModifierListOwner owner) {
        return owner.hasModifierProperty("abstract");
    }

    private boolean hasBaseClassMethod(PsiClass psiClass) {
        PsiMethod baseClassMethod = this.getMethod(psiClass, true);
        return baseClassMethod != null && !this.isAbstract((PsiModifierListOwner)baseClassMethod);
    }

    private PsiMethod getMethod(PsiClass aClass, boolean checkBases) {
        return MethodHierarchyUtil.findBaseMethodInClass(this.getBaseMethod(), aClass, checkBases);
    }

    boolean isSuperClassForBaseClass(PsiClass aClass) {
        PsiMethod baseMethod = this.getBaseMethod();
        if (baseMethod == null) {
            return false;
        }
        PsiClass baseClass = baseMethod.getContainingClass();
        if (baseClass == null) {
            return false;
        }
        return baseClass.isInheritor(aClass, true);
    }
}

