/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyBrowserBaseEx;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.psi.PsiElement;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CallHierarchyBrowserBase
extends HierarchyBrowserBaseEx {
    public static final String CALLEE_TYPE = IdeBundle.message((String)"title.hierarchy.callees.of", (Object[])new Object[0]);
    public static final String CALLER_TYPE = IdeBundle.message((String)"title.hierarchy.callers.of", (Object[])new Object[0]);
    private static final String CALL_HIERARCHY_BROWSER_DATA_KEY = "com.intellij.ide.hierarchy.CallHierarchyBrowserBase";

    public CallHierarchyBrowserBase(Project project, PsiElement method) {
        super(project, method);
    }

    @Override
    @Nullable
    protected JPanel createLegendPanel() {
        return null;
    }

    @Override
    @NotNull
    protected String getBrowserDataKey() {
        if (CALL_HIERARCHY_BROWSER_DATA_KEY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/hierarchy/CallHierarchyBrowserBase.getBrowserDataKey must not return null");
        }
        return CALL_HIERARCHY_BROWSER_DATA_KEY;
    }

    @Override
    protected void prependActions(@NotNull DefaultActionGroup actionGroup) {
        if (actionGroup == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/hierarchy/CallHierarchyBrowserBase.prependActions must not be null");
        }
        actionGroup.add((AnAction)new ChangeViewTypeActionBase(IdeBundle.message((String)"action.caller.methods.hierarchy", (Object[])new Object[0]), IdeBundle.message((String)"action.caller.methods.hierarchy", (Object[])new Object[0]), IconLoader.getIcon((String)"/hierarchy/caller.png"), CALLER_TYPE));
        actionGroup.add((AnAction)new ChangeViewTypeActionBase(IdeBundle.message((String)"action.callee.methods.hierarchy", (Object[])new Object[0]), IdeBundle.message((String)"action.callee.methods.hierarchy", (Object[])new Object[0]), IconLoader.getIcon((String)"/hierarchy/callee.png"), CALLEE_TYPE));
        actionGroup.add((AnAction)new HierarchyBrowserBaseEx.AlphaSortAction(this));
        actionGroup.add((AnAction)new HierarchyBrowserBaseEx.ChangeScopeAction(this));
    }

    @Override
    @NotNull
    protected String getActionPlace() {
        if ("CallHierarchyViewToolbar" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/hierarchy/CallHierarchyBrowserBase.getActionPlace must not return null");
        }
        return "CallHierarchyViewToolbar";
    }

    @Override
    @NotNull
    protected String getPrevOccurenceActionNameImpl() {
        String string = IdeBundle.message((String)"hierarchy.call.prev.occurence.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/hierarchy/CallHierarchyBrowserBase.getPrevOccurenceActionNameImpl must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String getNextOccurenceActionNameImpl() {
        String string = IdeBundle.message((String)"hierarchy.call.next.occurence.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/hierarchy/CallHierarchyBrowserBase.getNextOccurenceActionNameImpl must not return null");
        }
        return string;
    }

    protected static class BaseOnThisMethodAction
    extends HierarchyBrowserBaseEx.BaseOnThisElementAction {
        public BaseOnThisMethodAction() {
            super(IdeBundle.message((String)"action.base.on.this.method", (Object[])new Object[0]), "CallHierarchy", CallHierarchyBrowserBase.CALL_HIERARCHY_BROWSER_DATA_KEY);
        }
    }

    private class ChangeViewTypeActionBase
    extends ToggleAction {
        private final String myTypeName;

        public ChangeViewTypeActionBase(String shortDescription, String longDescription, Icon icon, String typeName) {
            super(shortDescription, longDescription, icon);
            this.myTypeName = typeName;
        }

        public final boolean isSelected(AnActionEvent event) {
            return this.myTypeName.equals(CallHierarchyBrowserBase.this.myCurrentViewType);
        }

        public final void setSelected(AnActionEvent event, boolean flag) {
            if (flag) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CallHierarchyBrowserBase.this.changeView(ChangeViewTypeActionBase.this.myTypeName);
                    }
                });
            }
        }

        public final void update(AnActionEvent event) {
            super.update(event);
            CallHierarchyBrowserBase.this.setEnabled(CallHierarchyBrowserBase.this.isValidBase());
        }
    }
}

