/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class FileTemplateTab {
    public Map<FileTemplate, FileTemplate> savedTemplates;
    private final String myTitle;
    protected static final Color MODIFIED_FOREGROUND = new Color(0, 0, 210);

    protected FileTemplateTab(String title) {
        this.myTitle = title;
    }

    public abstract JComponent getComponent();

    @Nullable
    public abstract FileTemplate getSelectedTemplate();

    public abstract void selectTemplate(FileTemplate var1);

    public abstract void removeSelected();

    public abstract void onTemplateSelected();

    public void init(FileTemplate[] templates) {
        FileTemplate oldSelection = this.getSelectedTemplate();
        FileTemplate newSelection = null;
        LinkedHashMap<FileTemplate, FileTemplate> templatesToSave = new LinkedHashMap<FileTemplate, FileTemplate>();
        for (FileTemplate aTemplate : templates) {
            FileTemplate copy = FileTemplateUtil.cloneTemplate(aTemplate);
            templatesToSave.put(aTemplate, copy);
            if (this.savedTemplates == null || this.savedTemplates.get(aTemplate) != oldSelection) continue;
            newSelection = copy;
        }
        this.savedTemplates = templatesToSave;
        this.initSelection(newSelection);
    }

    protected abstract void initSelection(FileTemplate var1);

    public abstract void fireDataChanged();

    @NotNull
    public FileTemplate[] getTemplates() {
        FileTemplate[] fileTemplateArray = this.savedTemplates.values().toArray(new FileTemplate[this.savedTemplates.values().size()]);
        if (fileTemplateArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/fileTemplates/impl/FileTemplateTab.getTemplates must not return null");
        }
        return fileTemplateArray;
    }

    public abstract void addTemplate(FileTemplate var1);

    public String getTitle() {
        return this.myTitle;
    }
}

