/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.bookmarks.BookmarkManager;
import com.intellij.ide.bookmarks.actions.BookmarksAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowManager;

public class ToggleBookmarkAction
extends BookmarksAction
implements DumbAware {
    public ToggleBookmarkAction() {
        this.getTemplatePresentation().setText(IdeBundle.message((String)"action.toggle.bookmark", (Object[])new Object[0]));
    }

    @Override
    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        BookmarksAction.BookmarkInContextInfo info = new BookmarksAction.BookmarkInContextInfo(dataContext, project).invoke();
        if (info.getFile() == null) {
            return;
        }
        if (info.getBookmarkAtPlace() != null) {
            BookmarkManager.getInstance(project).removeBookmark(info.getBookmarkAtPlace());
        } else {
            BookmarkManager.getInstance(project).addTextBookmark(info.getFile(), info.getLine(), "");
        }
    }

    @Override
    public void update(AnActionEvent event) {
        DataContext dataContext = event.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        event.getPresentation().setEnabled(project != null && (ToolWindowManager.getInstance((Project)project).isEditorComponentActive() && PlatformDataKeys.EDITOR.getData(dataContext) != null || PlatformDataKeys.VIRTUAL_FILE.getData(dataContext) != null));
        event.getPresentation().setText(IdeBundle.message((String)"action.toggle.bookmark", (Object[])new Object[0]));
    }
}

