/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.Nullable;

public abstract class UndoRedoAction
extends DumbAwareAction {
    public UndoRedoAction() {
        this.setEnabledInModalContext(true);
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        FileEditor editor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(dataContext);
        UndoManager undoManager = UndoRedoAction.getUndoManager(editor, dataContext);
        Project project = UndoRedoAction.getProject(editor, dataContext);
        if (editor == null && project != null && DumbService.getInstance((Project)project).isDumb()) {
            DumbService.getInstance((Project)project).showDumbModeNotification("Global Undo and Redo are not available while indices are being built");
            return;
        }
        this.perform(editor, undoManager);
    }

    public void update(AnActionEvent event) {
        String actionName;
        Boolean isModalContext;
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        FileEditor editor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(dataContext);
        if (editor == null && (isModalContext = (Boolean)PlatformDataKeys.IS_MODAL_CONTEXT.getData(dataContext)) != null && isModalContext.booleanValue()) {
            presentation.setEnabled(false);
            return;
        }
        UndoManager undoManager = UndoRedoAction.getUndoManager(editor, dataContext);
        boolean available = this.isAvailable(editor, undoManager);
        presentation.setEnabled(available);
        String string = actionName = available ? this.formatAction(editor, undoManager) : null;
        if (actionName == null) {
            actionName = "";
        }
        String shortActionName = StringUtil.first((String)actionName, (int)30, (boolean)true);
        if (actionName.length() == 0) {
            actionName = ActionsBundle.message((String)this.getActionDescriptionEmptyMessageKey(), (Object[])new Object[0]);
        }
        presentation.setText(ActionsBundle.message((String)this.getActionMessageKey(), (Object[])new Object[]{shortActionName}).trim());
        presentation.setDescription(ActionsBundle.message((String)this.getActionDescriptionMessageKey(), (Object[])new Object[]{actionName}).trim());
    }

    private static UndoManager getUndoManager(FileEditor editor, DataContext dataContext) {
        Project project = UndoRedoAction.getProject(editor, dataContext);
        return project != null ? UndoManager.getInstance((Project)project) : UndoManager.getGlobalInstance();
    }

    private static Project getProject(FileEditor editor, DataContext dataContext) {
        Project project = editor instanceof TextEditor ? ((TextEditor)editor).getEditor().getProject() : (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        return project;
    }

    protected abstract boolean isAvailable(FileEditor var1, UndoManager var2);

    protected abstract void perform(FileEditor var1, UndoManager var2);

    protected abstract String getActionMessageKey();

    protected abstract String getActionDescriptionMessageKey();

    protected abstract String getActionDescriptionEmptyMessageKey();

    @Nullable
    protected abstract String formatAction(FileEditor var1, UndoManager var2);
}

