/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.Icons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;

public class ToolWindowSwitcher
extends AnAction
implements DumbAware {
    private static volatile ToolWindowSwitcherPanel SWITCHER = null;
    private static final Color BORDER_COLOR = new Color(135, 135, 135);
    private static final Color SEPARATOR_COLOR = BORDER_COLOR.brighter();
    @NonNls
    private static final String SWITCHER_FEATURE_ID = "switcher";
    private static final KeyListener performanceProblemsSolver = new KeyAdapter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() != 17) return;
            Class<ToolWindowSwitcher> clazz = ToolWindowSwitcher.class;
            synchronized (ToolWindowSwitcher.class) {
                if (SWITCHER == null) return;
                SWITCHER.navigate();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    };
    private static Component focusComponent = null;
    @NonNls
    private static final String SWITCHER_TITLE = "Switcher";

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)PlatformDataKeys.PROJECT.getData(e.getDataContext());
        if (project == null) {
            return;
        }
        if (SWITCHER == null) {
            focusComponent = FocusManager.getCurrentManager().getFocusOwner();
            if (focusComponent != null) {
                focusComponent.addKeyListener(performanceProblemsSolver);
            }
            SWITCHER = new ToolWindowSwitcherPanel(project);
            FeatureUsageTracker.getInstance().triggerFeatureUsed(SWITCHER_FEATURE_ID);
        }
        if (e.getInputEvent().isShiftDown()) {
            SWITCHER.goBack();
        } else {
            SWITCHER.goForward();
        }
    }

    private static class ToolWindowsRenderer
    extends ColoredListCellRenderer {
        private static final Map<String, Icon> iconCache = new HashMap<String, Icon>();
        private final Map<ToolWindow, String> ids;

        public ToolWindowsRenderer(Map<ToolWindow, String> ids) {
            this.ids = ids;
        }

        protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            if (value instanceof ToolWindow) {
                ToolWindow tw = (ToolWindow)value;
                String name = this.ids.get(tw);
                this.setIcon(this.getIcon(tw));
                TextAttributes attributes = new TextAttributes(Color.BLACK, null, null, EffectType.LINE_UNDERSCORE, 0);
                this.append(name, SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes));
            }
        }

        private Icon getIcon(ToolWindow toolWindow) {
            Icon icon = iconCache.get(this.ids.get(toolWindow));
            if (icon != null) {
                return icon;
            }
            icon = toolWindow.getIcon();
            if (icon == null) {
                return Icons.UI_FORM_ICON;
            }
            icon = ToolWindowsRenderer.to16x16(icon);
            iconCache.put(this.ids.get(toolWindow), icon);
            return icon;
        }

        private static Icon to16x16(Icon icon) {
            if (icon.getIconHeight() == 16 && icon.getIconWidth() == 16) {
                return icon;
            }
            int w = Math.min(icon.getIconWidth(), 16);
            int h = Math.min(icon.getIconHeight(), 16);
            BufferedImage image = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(16, 16, 3);
            Graphics2D g = image.createGraphics();
            icon.paintIcon(null, g, 0, 0);
            g.dispose();
            BufferedImage img = new BufferedImage(16, 16, 3);
            int offX = Math.max((16 - w) / 2, 0);
            int offY = Math.max((16 - h) / 2, 0);
            for (int col = 0; col < w; ++col) {
                for (int row = 0; row < h; ++row) {
                    img.setRGB(col + offX, row + offY, image.getRGB(col, row));
                }
            }
            return new ImageIcon(img);
        }
    }

    private static class VirtualFilesRenderer
    extends ColoredListCellRenderer {
        private final Project myProject;

        public VirtualFilesRenderer(Project project) {
            this.myProject = project;
        }

        protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            if (value instanceof VirtualFile) {
                VirtualFile virtualFile = (VirtualFile)value;
                String name = virtualFile.getPresentableName();
                this.setIcon(IconUtil.getIcon((VirtualFile)virtualFile, (int)2, (Project)this.myProject));
                FileStatus fileStatus = FileStatusManager.getInstance((Project)this.myProject).getStatus(virtualFile);
                TextAttributes attributes = new TextAttributes(fileStatus.getColor(), null, null, EffectType.LINE_UNDERSCORE, 0);
                this.append(name, SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes));
            }
        }
    }

    private class ToolWindowSwitcherPanel
    extends JPanel
    implements KeyListener,
    MouseListener,
    MouseMotionListener {
        final JBPopup myPopup;
        final Map<ToolWindow, String> ids;
        final JList toolwindows;
        final JList files;
        final JPanel separator;
        final ToolWindowManager twManager;
        final JLabel pathLabel;
        final JPanel descriptions;
        final Project project;
        final int CTRL_KEY;
        final int ALT_KEY;
        private boolean mouseMovedFirstTime;

        ToolWindowSwitcherPanel(Project project) {
            super(new BorderLayout(0, 0));
            this.ids = new HashMap<ToolWindow, String>();
            this.pathLabel = new JLabel(" ");
            this.mouseMovedFirstTime = true;
            this.project = project;
            this.setFocusable(true);
            this.addKeyListener(this);
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.setBackground(Color.WHITE);
            this.pathLabel.setHorizontalAlignment(4);
            Font font = this.pathLabel.getFont();
            this.pathLabel.setFont(font.deriveFont(10.0f));
            this.descriptions = new JPanel(new BorderLayout()){

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    g.setColor(BORDER_COLOR);
                    g.drawLine(0, 0, this.getWidth(), 0);
                }
            };
            this.descriptions.setBorder(BorderFactory.createEmptyBorder(1, 4, 1, 4));
            this.descriptions.add(this.pathLabel);
            this.twManager = ToolWindowManager.getInstance((Project)project);
            DefaultListModel<ToolWindow> twModel = new DefaultListModel<ToolWindow>();
            for (String id : this.twManager.getToolWindowIds()) {
                ToolWindow tw = this.twManager.getToolWindow(id);
                if (!tw.isAvailable()) continue;
                this.ids.put(tw, id);
            }
            ArrayList<ToolWindow> windows = new ArrayList<ToolWindow>(this.ids.keySet());
            Collections.sort(windows, new ToolWindowComparator());
            for (ToolWindow window : windows) {
                twModel.addElement(window);
            }
            this.toolwindows = new JList(twModel);
            this.toolwindows.setBorder(IdeBorderFactory.createEmptyBorder((int)5, (int)5, (int)5, (int)20));
            this.toolwindows.setSelectionMode(0);
            this.toolwindows.setCellRenderer(new ToolWindowsRenderer(this.ids));
            this.toolwindows.addKeyListener(this);
            this.toolwindows.addMouseListener(this);
            this.toolwindows.addMouseMotionListener(this);
            this.toolwindows.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!ToolWindowSwitcherPanel.this.toolwindows.getSelectionModel().isSelectionEmpty()) {
                        ToolWindowSwitcherPanel.this.files.getSelectionModel().clearSelection();
                    }
                }
            });
            this.separator = new JPanel(){

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    g.setColor(SEPARATOR_COLOR);
                    g.drawLine(0, 0, 0, this.getHeight());
                }

                @Override
                public Dimension getMaximumSize() {
                    Dimension max = super.getMaximumSize();
                    return new Dimension(5, max.height);
                }
            };
            this.separator.setBackground(Color.WHITE);
            FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
            VirtualFile[] openFiles = editorManager.getOpenFiles();
            try {
                Arrays.sort(openFiles, new RecentFilesComparator(project));
            }
            catch (Exception e) {
                // empty catch block
            }
            DefaultListModel<VirtualFile> filesModel = new DefaultListModel<VirtualFile>();
            for (VirtualFile openFile : openFiles) {
                filesModel.addElement(openFile);
            }
            this.files = new JList(filesModel);
            this.files.setSelectionMode(0);
            this.files.setBorder(IdeBorderFactory.createEmptyBorder((int)5, (int)5, (int)5, (int)20));
            this.files.setCellRenderer(new VirtualFilesRenderer(project));
            this.files.addKeyListener(this);
            this.files.addMouseListener(this);
            this.files.addMouseMotionListener(this);
            this.files.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!ToolWindowSwitcherPanel.this.files.getSelectionModel().isSelectionEmpty()) {
                        ToolWindowSwitcherPanel.this.toolwindows.getSelectionModel().clearSelection();
                    }
                }
            });
            this.add((Component)this.toolwindows, "West");
            if (filesModel.size() > 0) {
                this.files.setAlignmentY(1.0f);
                this.add((Component)this.files, "East");
                this.add((Component)this.separator, "Center");
            }
            this.add((Component)this.descriptions, "South");
            this.files.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                private String getTitle2Text(String fullText) {
                    int labelWidth = ToolWindowSwitcherPanel.this.pathLabel.getWidth();
                    if (fullText == null || fullText.length() == 0) {
                        return " ";
                    }
                    while (ToolWindowSwitcherPanel.this.pathLabel.getFontMetrics(ToolWindowSwitcherPanel.this.pathLabel.getFont()).stringWidth(fullText) > labelWidth) {
                        int sep = fullText.indexOf(File.separatorChar, 4);
                        if (sep < 0) {
                            return fullText;
                        }
                        fullText = "..." + fullText.substring(sep);
                    }
                    return fullText;
                }

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.updatePathLabel();
                        }
                    });
                }

                private void updatePathLabel() {
                    Object[] values = ToolWindowSwitcherPanel.this.files.getSelectedValues();
                    if (values != null && values.length == 1) {
                        VirtualFile parent = ((VirtualFile)values[0]).getParent();
                        if (parent != null) {
                            ToolWindowSwitcherPanel.this.pathLabel.setText(this.getTitle2Text(parent.getPresentableUrl()));
                        } else {
                            ToolWindowSwitcherPanel.this.pathLabel.setText(" ");
                        }
                    } else {
                        ToolWindowSwitcherPanel.this.pathLabel.setText(" ");
                    }
                }
            });
            int modifiers = this.getModifiers(ToolWindowSwitcher.this.getShortcutSet());
            if ((modifiers & 8) != 0) {
                this.ALT_KEY = 17;
                this.CTRL_KEY = 18;
            } else {
                this.ALT_KEY = 18;
                this.CTRL_KEY = 17;
            }
            IdeFrameImpl ideFrame = WindowManagerEx.getInstanceEx().getFrame(project);
            this.myPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this, (JComponent)this).setResizable(false).setModalContext(false).setFocusable(true).setRequestFocus(true).setTitle(ToolWindowSwitcher.SWITCHER_TITLE).setMovable(false).setCancelCallback((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    SWITCHER = null;
                    if (focusComponent != null) {
                        focusComponent.removeKeyListener(performanceProblemsSolver);
                        focusComponent = null;
                    }
                    return true;
                }
            }).createPopup();
            this.myPopup.showInCenterOf((Component)ideFrame.getContentPane());
        }

        private int getModifiers(ShortcutSet shortcutSet) {
            if (shortcutSet == null || shortcutSet.getShortcuts().length == 0 || !(shortcutSet.getShortcuts()[0] instanceof KeyboardShortcut)) {
                return 2;
            }
            return ((KeyboardShortcut)shortcutSet.getShortcuts()[0]).getFirstKeyStroke().getModifiers();
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == this.CTRL_KEY || e.getKeyCode() == 10) {
                this.navigate();
            } else if (e.getKeyCode() == 37) {
                this.goLeft();
            } else if (e.getKeyCode() == 39) {
                this.goRight();
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 38: {
                    this.goBack();
                    break;
                }
                case 40: {
                    this.goForward();
                    break;
                }
                case 27: {
                    this.cancel();
                    break;
                }
                case 8: 
                case 127: {
                    this.closeTabOrToolWindow();
                }
            }
            if (e.getKeyCode() == this.ALT_KEY) {
                if (this.isFilesSelected()) {
                    this.goLeft();
                } else {
                    this.goRight();
                }
            }
        }

        private void closeTabOrToolWindow() {
            Object value = this.getSelectedList().getSelectedValue();
            if (value instanceof VirtualFile) {
                VirtualFile virtualFile = (VirtualFile)value;
                FileEditorManager editorManager = FileEditorManager.getInstance((Project)this.project);
                if (editorManager instanceof FileEditorManagerImpl) {
                    JList jList = this.getSelectedList();
                    ((FileEditorManagerImpl)editorManager).closeFile(virtualFile, false);
                    int selectedIndex = jList.getSelectedIndex();
                    if (jList.getModel().getSize() == 1) {
                        this.goLeft();
                        ((DefaultListModel)jList.getModel()).removeElementAt(selectedIndex);
                        this.remove(jList);
                        this.remove(this.separator);
                    } else {
                        this.goForward();
                        ((DefaultListModel)jList.getModel()).removeElementAt(selectedIndex);
                        jList.setSize(jList.getPreferredSize());
                    }
                    this.pack();
                }
            } else if (value instanceof ToolWindow) {
                ToolWindow toolWindow = (ToolWindow)value;
                if (this.twManager instanceof ToolWindowManagerImpl) {
                    ToolWindowManagerImpl manager = (ToolWindowManagerImpl)this.twManager;
                    manager.hideToolWindow(this.ids.get(toolWindow), false, false);
                } else {
                    toolWindow.hide(null);
                }
            }
        }

        private void pack() {
            this.setSize(this.getPreferredSize());
            JRootPane rootPane = SwingUtilities.getRootPane(this);
            Container container = this;
            do {
                container = container.getParent();
                container.setSize(container.getPreferredSize());
            } while (container != rootPane);
            container.getParent().setSize(container.getPreferredSize());
        }

        private boolean isFilesSelected() {
            return this.getSelectedList() == this.files;
        }

        private boolean isFilesVisible() {
            return this.files.getModel().getSize() > 0;
        }

        private boolean isToolWindowsSelected() {
            return this.getSelectedList() == this.toolwindows;
        }

        private void goRight() {
            if (this.isFilesSelected() || !this.isFilesVisible()) {
                this.cancel();
            } else if (this.files.getModel().getSize() > 0) {
                this.files.setSelectedIndex(Math.min(this.toolwindows.getSelectedIndex(), this.files.getModel().getSize() - 1));
                this.toolwindows.getSelectionModel().clearSelection();
            }
        }

        private void cancel() {
            this.myPopup.cancel();
        }

        private void goLeft() {
            if (this.isToolWindowsSelected()) {
                this.cancel();
            } else if (this.toolwindows.getModel().getSize() > 0) {
                this.toolwindows.setSelectedIndex(Math.min(this.files.getSelectedIndex(), this.toolwindows.getModel().getSize() - 1));
                this.files.getSelectionModel().clearSelection();
            }
        }

        public void goForward() {
            JList list = this.getSelectedList();
            int index = list.getSelectedIndex() + 1;
            if (index >= list.getModel().getSize()) {
                index = 0;
                if (this.isFilesVisible()) {
                    list = this.isFilesSelected() ? this.toolwindows : this.files;
                }
            }
            list.setSelectedIndex(index);
        }

        public void goBack() {
            JList list = this.getSelectedList();
            int index = list.getSelectedIndex() - 1;
            if (index < 0) {
                if (this.isFilesVisible()) {
                    list = this.isFilesSelected() ? this.toolwindows : this.files;
                }
                index = list.getModel().getSize() - 1;
            }
            list.setSelectedIndex(index);
        }

        public JList getSelectedList() {
            if (this.toolwindows.isSelectionEmpty() && this.files.isSelectionEmpty()) {
                if (this.files.getModel().getSize() > 1) {
                    this.files.setSelectedIndex(0);
                    return this.files;
                }
                this.toolwindows.setSelectedIndex(0);
                return this.toolwindows;
            }
            return this.toolwindows.isSelectionEmpty() ? this.files : this.toolwindows;
        }

        private void navigate() {
            this.myPopup.cancel();
            Object value = this.getSelectedList().getSelectedValue();
            if (value instanceof ToolWindow) {
                ((ToolWindow)value).activate(null, true, true);
            } else if (value instanceof VirtualFile) {
                FileEditorManager.getInstance((Project)this.project).openFile((VirtualFile)value, true);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Object source = e.getSource();
            if (source instanceof JList) {
                JList jList = (JList)source;
                if (jList.getSelectedIndex() == -1 && jList.getAnchorSelectionIndex() != -1) {
                    jList.setSelectedIndex(jList.getAnchorSelectionIndex());
                }
                if (jList.getSelectedIndex() != -1) {
                    this.navigate();
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            JList list;
            int index;
            if (this.mouseMovedFirstTime) {
                this.mouseMovedFirstTime = false;
                return;
            }
            Object source = e.getSource();
            if (source instanceof JList && 0 <= (index = (list = (JList)source).locationToIndex(e.getPoint())) && index < list.getModel().getSize()) {
                list.setSelectedIndex(index);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        private class ToolWindowComparator
        implements Comparator<ToolWindow> {
            private ToolWindowComparator() {
            }

            @Override
            public int compare(ToolWindow o1, ToolWindow o2) {
                return ToolWindowSwitcherPanel.this.ids.get(o1).compareTo(ToolWindowSwitcherPanel.this.ids.get(o2));
            }
        }

        private class RecentFilesComparator
        implements Comparator<VirtualFile> {
            private final VirtualFile[] recentFiles;

            public RecentFilesComparator(Project project) {
                this.recentFiles = EditorHistoryManager.getInstance(project).getFiles();
            }

            @Override
            public int compare(VirtualFile vf1, VirtualFile vf2) {
                return ArrayUtil.find((Object[])this.recentFiles, (Object)vf2) - ArrayUtil.find((Object[])this.recentFiles, (Object)vf1);
            }
        }
    }
}

