/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import javax.swing.Icon;

public class SaveAsDirectoryBasedFormatAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        int result;
        IProjectStore projectStore;
        Project project = (Project)PlatformDataKeys.PROJECT.getData(e.getDataContext());
        if (project instanceof ProjectEx && StorageScheme.DIRECTORY_BASED != (projectStore = ((ProjectEx)project).getStateStore()).getStorageScheme() && (result = Messages.showOkCancelDialog((Project)project, (String)"Project will be saved and reopened in new Directory-Based format.\nAre you sure you want to continue?", (String)"Save project to Directory-Based format", (Icon)Messages.getWarningIcon())) == 0) {
            boolean ok;
            VirtualFile baseDir = project.getBaseDir();
            assert (baseDir != null);
            File ideaDir = new File(baseDir.getPath(), ".idea" + File.separatorChar);
            boolean bl = ok = ideaDir.exists() && ideaDir.isDirectory() || ideaDir.mkdirs();
            if (ok) {
                LocalFileSystem.getInstance().refreshAndFindFileByIoFile(ideaDir);
                StateStorageManager storageManager = projectStore.getStateStorageManager();
                for (String file : storageManager.getStorageFileNames()) {
                    storageManager.clearStateStorage(file);
                }
                projectStore.setProjectFilePath(baseDir.getPath());
                project.save();
                ProjectUtil.closeProject(project);
                ProjectUtil.openProject(baseDir.getPath(), null, false);
            } else {
                Messages.showErrorDialog((Project)project, (String)String.format("Unable to create '.idea' directory (%s)", ideaDir), (String)"Error saving project!");
            }
        }
    }

    public void update(AnActionEvent e) {
        boolean visible;
        Presentation presentation = e.getPresentation();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(e.getDataContext());
        boolean bl = visible = project != null;
        if (project instanceof ProjectEx) {
            visible = ((ProjectEx)project).getStateStore().getStorageScheme() != StorageScheme.DIRECTORY_BASED;
        }
        presentation.setVisible(visible);
    }
}

