/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.QuickSwitchSchemeAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsManagerImpl;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.options.SharedScheme;
import com.intellij.openapi.project.Project;
import java.util.Collection;

public class QuickChangeColorSchemeAction
extends QuickSwitchSchemeAction {
    protected void fillActions(Project project, DefaultActionGroup group, DataContext dataContext) {
        EditorColorsScheme[] schemes = EditorColorsManager.getInstance().getAllSchemes();
        EditorColorsScheme current = EditorColorsManager.getInstance().getGlobalScheme();
        for (EditorColorsScheme scheme : schemes) {
            this.addScheme(group, current, scheme, false);
        }
        Collection sharedSchemes = ((EditorColorsManagerImpl)EditorColorsManager.getInstance()).getSchemesManager().loadSharedSchemes();
        if (!sharedSchemes.isEmpty()) {
            group.add((AnAction)Separator.getInstance());
            for (SharedScheme sharedScheme : sharedSchemes) {
                this.addScheme(group, current, (EditorColorsScheme)sharedScheme.getScheme(), true);
            }
        }
    }

    private void addScheme(DefaultActionGroup group, EditorColorsScheme current, final EditorColorsScheme scheme, final boolean addScheme) {
        group.add(new AnAction(scheme.getName(), "", scheme == current ? ourCurrentAction : ourNotCurrentAction){

            public void actionPerformed(AnActionEvent e) {
                Editor[] editors;
                if (addScheme) {
                    EditorColorsManager.getInstance().addColorsScheme(scheme);
                }
                EditorColorsManager.getInstance().setGlobalScheme(scheme);
                for (Editor editor : editors = EditorFactory.getInstance().getAllEditors()) {
                    ((EditorEx)editor).reinitSettings();
                }
            }
        });
    }

    protected boolean isEnabled() {
        return EditorColorsManager.getInstance().getAllSchemes().length > 1 || ((EditorColorsManagerImpl)EditorColorsManager.getInstance()).getSchemesManager().isImportAvailable();
    }
}

