/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowManager;

public class PrevSplitAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        final Project project = (Project)PlatformDataKeys.PROJECT.getData(e.getDataContext());
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(project, new Runnable(){

            @Override
            public void run() {
                FileEditorManagerEx manager = FileEditorManagerEx.getInstanceEx(project);
                manager.setCurrentWindow(manager.getPrevWindow(manager.getCurrentWindow()));
            }
        }, IdeBundle.message((String)"command.go.to.prev.split", (Object[])new Object[0]), null);
    }

    public void update(AnActionEvent event) {
        Project project = (Project)PlatformDataKeys.PROJECT.getData(event.getDataContext());
        Presentation presentation = event.getPresentation();
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        FileEditorManagerEx manager = FileEditorManagerEx.getInstanceEx(project);
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
        presentation.setEnabled(toolWindowManager.isEditorComponentActive() && manager.isInSplitter() && manager.getCurrentWindow() != null);
    }
}

