/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.actions.CopyReferenceAction;
import com.intellij.ide.actions.QualifiedNameProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public class PasteReferenceProvider
implements PasteProvider {
    public void performPaste(DataContext dataContext) {
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        if (project == null || editor == null) {
            return;
        }
        String fqn = PasteReferenceProvider.getCopiedFqn();
        QualifiedNameProvider theProvider = null;
        PsiElement element = null;
        for (QualifiedNameProvider provider : (QualifiedNameProvider[])Extensions.getExtensions(QualifiedNameProvider.EP_NAME)) {
            element = provider.qualifiedNameToElement(fqn, project);
            if (element == null) continue;
            theProvider = provider;
            break;
        }
        if (theProvider != null) {
            PasteReferenceProvider.insert(fqn, element, editor, theProvider);
        }
    }

    public boolean isPastePossible(DataContext dataContext) {
        return this.isPasteEnabled(dataContext);
    }

    public boolean isPasteEnabled(DataContext dataContext) {
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        return project != null && editor != null && PasteReferenceProvider.getCopiedFqn() != null;
    }

    private static void insert(final String fqn, final PsiElement element, final Editor editor, final QualifiedNameProvider provider) {
        final PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)editor.getProject());
        documentManager.commitDocument(editor.getDocument());
        PsiFile file = documentManager.getPsiFile(editor.getDocument());
        if (!CodeInsightUtilBase.prepareFileForWrite(file)) {
            return;
        }
        final Project project = editor.getProject();
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        Document document = editor.getDocument();
                        documentManager.doPostponedOperationsAndUnblockDocument(document);
                        documentManager.commitDocument(document);
                        EditorModificationUtil.deleteSelectedText((Editor)editor);
                        provider.insertQualifiedName(fqn, element, editor, project);
                    }
                });
            }
        }, IdeBundle.message((String)"command.pasting.reference", (Object[])new Object[0]), null);
    }

    @Nullable
    private static String getCopiedFqn() {
        Transferable contents = CopyPasteManager.getInstance().getContents();
        if (contents == null) {
            return null;
        }
        try {
            DataFlavor flavor = CopyReferenceAction.getFlavor();
            if (flavor != null) {
                return (String)contents.getTransferData(flavor);
            }
        }
        catch (UnsupportedFlavorException e) {
        }
        catch (IOException e) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return null;
    }
}

