/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class CreateHtmlAction
extends CreateElementActionBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actions.CreateHtmlAction");
    private final FileType myFileType;
    private final String myTemplateName;

    public CreateHtmlAction() {
        this((FileType)StdFileTypes.HTML, "Html");
    }

    protected CreateHtmlAction(FileType fileType, String templateName) {
        super(IdeBundle.message((String)"action.create.new.filetype", (Object[])new Object[]{fileType.getName()}), IdeBundle.message((String)"action.description.create.new.file", (Object[])new Object[]{fileType.getName()}), fileType.getIcon());
        this.myFileType = fileType;
        this.myTemplateName = templateName;
    }

    @NotNull
    protected PsiElement[] invokeDialog(Project project, PsiDirectory directory) {
        CreateElementActionBase.MyInputValidator validator = new CreateElementActionBase.MyInputValidator((CreateElementActionBase)this, project, directory);
        Messages.showInputDialog((Project)project, (String)IdeBundle.message((String)"prompt.enter.new.filetype.name", (Object[])new Object[]{this.myFileType.getName()}), (String)IdeBundle.message((String)"title.new.filetype", (Object[])new Object[]{this.myFileType.getName()}), (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)validator);
        PsiElement[] psiElementArray = validator.getCreatedElements();
        if (psiElementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/actions/CreateHtmlAction.invokeDialog must not return null");
        }
        return psiElementArray;
    }

    protected void checkBeforeCreate(String newName, PsiDirectory directory) throws IncorrectOperationException {
        newName = this.getName(newName);
        directory.checkCreateFile(newName);
    }

    public static boolean isExtensionOfType(@NotNull String fileName, @NotNull FileType type) {
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/actions/CreateHtmlAction.isExtensionOfType must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/actions/CreateHtmlAction.isExtensionOfType must not be null");
        }
        int i = fileName.lastIndexOf(46);
        if (i != -1) {
            String ext = fileName.substring(i + 1);
            if (type.getDefaultExtension().equals(ext)) {
                return true;
            }
        }
        return false;
    }

    private String getName(String oldName) {
        if (CreateHtmlAction.isExtensionOfType(oldName, this.myFileType)) {
            return oldName;
        }
        return oldName + "." + this.myFileType.getDefaultExtension();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    protected PsiElement[] create(String newName, PsiDirectory directory) throws Exception {
        PsiElement[] psiElementArray;
        block4: {
            FileTemplate template = FileTemplateManager.getInstance().getInternalTemplate(this.myTemplateName);
            try {
                PsiElement element = FileTemplateUtil.createFromTemplate(template, this.getName(newName), FileTemplateManager.getInstance().getDefaultProperties(), directory);
                PsiFile psiFile = element.getContainingFile();
                VirtualFile virtualFile = psiFile.getVirtualFile();
                if (virtualFile == null) break block4;
                FileEditorManager.getInstance((Project)directory.getProject()).openFile(virtualFile, true);
                psiElementArray = new PsiElement[]{psiFile};
                if (psiElementArray != null) return psiElementArray;
                throw new IllegalStateException("@NotNull method com/intellij/ide/actions/CreateHtmlAction.create must not return null");
            }
            catch (IncorrectOperationException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        psiElementArray = PsiElement.EMPTY_ARRAY;
        if (PsiElement.EMPTY_ARRAY != null) return psiElementArray;
        throw new IllegalStateException("@NotNull method com/intellij/ide/actions/CreateHtmlAction.create must not return null");
    }

    protected String getErrorTitle() {
        return IdeBundle.message((String)"title.cannot.create.filetype", (Object[])new Object[]{this.myFileType.getName()});
    }

    protected String getCommandName() {
        return IdeBundle.message((String)"command.name.create.new.file", (Object[])new Object[]{this.myFileType.getName()});
    }

    protected String getActionName(PsiDirectory directory, String newName) {
        return IdeBundle.message((String)"progress.creating.filetype.in.directory", (Object[])new Object[]{this.myFileType.getName(), newName, directory.getName()});
    }

    public void update(AnActionEvent e) {
        super.update(e);
        Presentation presentation = e.getPresentation();
        FileTypeManager manager = FileTypeManager.getInstance();
        FileType fileType = manager.getFileTypeByExtension(".html");
        if (fileType == FileTypes.PLAIN_TEXT) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
        }
    }
}

