/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.util.Alarm;
import com.intellij.util.ReflectionUtil;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.dnd.DragGestureRecognizer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.plaf.basic.BasicPopupMenuUI;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class SwingCleanuper
implements ApplicationComponent {
    private final Alarm myAlarm = new Alarm();

    SwingCleanuper(ProjectManager projectManager) {
        projectManager.addProjectManagerListener((ProjectManagerListener)new ProjectManagerAdapter(){

            public void projectOpened(Project project) {
                SwingCleanuper.this.myAlarm.cancelAllRequests();
            }

            public void projectClosed(Project project) {
                SwingCleanuper.this.myAlarm.cancelAllRequests();
                SwingCleanuper.this.myAlarm.addRequest(new Runnable(){

                    @Override
                    public void run() {
                        Application app;
                        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
                        IdeFrameImpl frame = window instanceof IdeFrameImpl ? (IdeFrameImpl)window : (IdeFrameImpl)SwingUtilities.getAncestorOfClass(IdeFrameImpl.class, window);
                        if (frame != null && (app = ApplicationManager.getApplication()) != null && app.isActive()) {
                            ((JComponent)((Object)frame.getStatusBar())).requestFocus();
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Field f;
                                try {
                                    Field newFocusOwnerField = KeyboardFocusManager.class.getDeclaredField("newFocusOwner");
                                    newFocusOwnerField.setAccessible(true);
                                    newFocusOwnerField.set(null, null);
                                }
                                catch (Exception exc) {
                                    // empty catch block
                                }
                                KeyboardFocusManager focusManager = FocusManager.getCurrentKeyboardFocusManager();
                                SwingCleanuper.resetField(focusManager, Component.class, "realOppositeComponent");
                                SwingCleanuper.resetField(focusManager, Window.class, "realOppositeWindow");
                                try {
                                    Object helperObject = ReflectionUtil.getField(BasicPopupMenuUI.class, null, Object.class, (String)"menuKeyboardHelper");
                                    if (null != helperObject) {
                                        SwingCleanuper.resetField(helperObject, Component.class, "lastFocused");
                                    }
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                try {
                                    Field recognizerField = TransferHandler.class.getDeclaredField("recognizer");
                                    recognizerField.setAccessible(true);
                                    Object recognizerObject = recognizerField.get(null);
                                    if (recognizerObject != null) {
                                        Method setComponentMethod = DragGestureRecognizer.class.getDeclaredMethod("setComponent", Component.class);
                                        setComponentMethod.invoke(recognizerObject, new Object[]{null});
                                    }
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                try {
                                    SwingCleanuper.fixJTextComponentMemoryLeak();
                                }
                                catch (NoSuchFieldException e) {
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                focusManager.setGlobalCurrentFocusCycleRoot(null);
                                try {
                                    Method m = KeyboardFocusManager.class.getDeclaredMethod("setGlobalFocusOwner", Component.class);
                                    m.setAccessible(true);
                                    m.invoke((Object)focusManager, new Object[]{null});
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                try {
                                    f = KeyboardFocusManager.class.getDeclaredField("newFocusOwner");
                                    f.setAccessible(true);
                                    f.set(null, null);
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                try {
                                    f = KeyboardFocusManager.class.getDeclaredField("permanentFocusOwner");
                                    f.setAccessible(true);
                                    f.set(null, null);
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                try {
                                    f = KeyboardFocusManager.class.getDeclaredField("currentFocusCycleRoot");
                                    f.setAccessible(true);
                                    f.set(null, null);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        });
                    }
                }, 2500);
            }
        });
    }

    private static void resetField(Object object, Class type, @NonNls String name) {
        try {
            ReflectionUtil.resetField((Object)object, (Field)ReflectionUtil.findField(object.getClass(), (Class)type, (String)name));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void disposeComponent() {
    }

    @NotNull
    public final String getComponentName() {
        if ("SwingCleanuper" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/SwingCleanuper.getComponentName must not return null");
        }
        return "SwingCleanuper";
    }

    public final void initComponent() {
    }

    private static void fixJTextComponentMemoryLeak() throws NoSuchFieldException, IllegalAccessException {
        Field focusedComponentField = JTextComponent.class.getDeclaredField("focusedComponent");
        focusedComponentField.setAccessible(true);
        JTextComponent component = (JTextComponent)focusedComponentField.get(null);
        if (component != null && !component.isDisplayable()) {
            focusedComponentField.set(null, null);
        }
    }
}

