/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.changes;

import com.intellij.history.core.IdPath;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.changes.ContentChangeAppliedState;
import com.intellij.history.core.changes.ContentChangeNonAppliedState;
import com.intellij.history.core.changes.StructuralChange;
import com.intellij.history.core.storage.Content;
import com.intellij.history.core.storage.Stream;
import com.intellij.history.core.tree.Entry;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class ContentChange
extends StructuralChange<ContentChangeNonAppliedState, ContentChangeAppliedState> {
    public ContentChange(String path, Content newContent, long timestamp) {
        super(path);
        ((ContentChangeNonAppliedState)this.getNonAppliedState()).myNewContent = newContent;
        ((ContentChangeNonAppliedState)this.getNonAppliedState()).myNewTimestamp = timestamp;
    }

    public ContentChange(Stream s) throws IOException {
        super(s);
        ((ContentChangeAppliedState)this.getAppliedState()).myOldContent = s.readContent();
        ((ContentChangeAppliedState)this.getAppliedState()).myOldTimestamp = s.readLong();
    }

    @Override
    public void write(Stream s) throws IOException {
        super.write(s);
        s.writeContent(((ContentChangeAppliedState)this.getAppliedState()).myOldContent);
        s.writeLong(((ContentChangeAppliedState)this.getAppliedState()).myOldTimestamp);
    }

    @Override
    protected ContentChangeAppliedState createAppliedState() {
        return new ContentChangeAppliedState();
    }

    @Override
    protected ContentChangeNonAppliedState createNonAppliedState() {
        return new ContentChangeNonAppliedState();
    }

    public Content getOldContent() {
        return ((ContentChangeAppliedState)this.getAppliedState()).myOldContent;
    }

    public long getOldTimestamp() {
        return ((ContentChangeAppliedState)this.getAppliedState()).myOldTimestamp;
    }

    @Override
    protected IdPath doApplyTo(Entry root, ContentChangeAppliedState newState) {
        Entry e = root.getEntry(this.getPath());
        newState.myOldContent = e.getContent();
        newState.myOldTimestamp = e.getTimestamp();
        e.changeContent(((ContentChangeNonAppliedState)this.getNonAppliedState()).myNewContent, ((ContentChangeNonAppliedState)this.getNonAppliedState()).myNewTimestamp);
        return e.getIdPath();
    }

    @Override
    public void doRevertOn(Entry root) {
        Entry e = root.getEntry(this.getAffectedIdPath());
        e.changeContent(((ContentChangeAppliedState)this.getAppliedState()).myOldContent, ((ContentChangeAppliedState)this.getAppliedState()).myOldTimestamp);
    }

    @Override
    public List<Content> getContentsToPurge() {
        return Collections.singletonList(((ContentChangeAppliedState)this.getAppliedState()).myOldContent);
    }

    @Override
    public boolean isFileContentChange() {
        return true;
    }

    @Override
    public void accept(ChangeVisitor v) throws IOException, ChangeVisitor.StopVisitingException {
        v.visit(this);
    }
}

