/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.ProjectScope;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.UsageView;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ShowRecentFindUsagesAction
extends AnAction {
    public void update(AnActionEvent e) {
        UsageView usageView = (UsageView)e.getData(UsageView.USAGE_VIEW_KEY);
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        e.getPresentation().setEnabled(usageView != null && project != null);
    }

    public void actionPerformed(AnActionEvent e) {
        UsageView usageView = (UsageView)e.getData(UsageView.USAGE_VIEW_KEY);
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        final FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)project)).getFindUsagesManager();
        ArrayList<FindUsagesManager.SearchData> history = new ArrayList<FindUsagesManager.SearchData>(findUsagesManager.getFindUsageHistory());
        if (!history.isEmpty()) {
            history.remove(history.size() - 1);
            Collections.reverse(history);
        }
        if (history.isEmpty()) {
            history.add(new FindUsagesManager.SearchData());
        }
        BaseListPopupStep<FindUsagesManager.SearchData> step = new BaseListPopupStep<FindUsagesManager.SearchData>(FindBundle.message("recent.find.usages.action.title", new Object[0]), history){

            public Icon getIconFor(FindUsagesManager.SearchData data) {
                if (data.myElements == null) {
                    return null;
                }
                PsiElement psiElement = data.myElements[0].getElement();
                if (psiElement == null) {
                    return null;
                }
                return psiElement.getIcon(0);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public String getTextFor(FindUsagesManager.SearchData data) {
                String string;
                if (data.myElements == null) {
                    string = FindBundle.message("recent.find.usages.action.nothing", new Object[0]);
                    if (string == null) throw new IllegalStateException("@NotNull method com/intellij/find/impl/ShowRecentFindUsagesAction$1.getTextFor must not return null");
                    return string;
                }
                PsiElement psiElement = data.myElements[0].getElement();
                if (psiElement == null) {
                    string = UsageViewBundle.message((String)"node.invalid", (Object[])new Object[0]);
                    if (string == null) throw new IllegalStateException("@NotNull method com/intellij/find/impl/ShowRecentFindUsagesAction$1.getTextFor must not return null");
                    return string;
                }
                String scopeString = data.myOptions.searchScope == null ? null : data.myOptions.searchScope.getDisplayName();
                string = FindBundle.message("recent.find.usages.action.description", StringUtil.capitalize((String)UsageViewUtil.getType(psiElement)), UsageViewUtil.getDescriptiveName(psiElement), scopeString == null ? ProjectScope.getAllScope((Project)psiElement.getProject()).getDisplayName() : scopeString);
                if (string != null) return string;
                throw new IllegalStateException("@NotNull method com/intellij/find/impl/ShowRecentFindUsagesAction$1.getTextFor must not return null");
            }

            public PopupStep onChosen(final FindUsagesManager.SearchData selectedValue, boolean finalChoice) {
                return this.doFinalStep(new Runnable(){

                    @Override
                    public void run() {
                        if (selectedValue.myElements != null) {
                            findUsagesManager.rerunAndRecallFromHistory(selectedValue);
                        }
                    }
                });
            }
        };
        RelativePoint point = e.getInputEvent() instanceof MouseEvent ? new RelativePoint((MouseEvent)e.getInputEvent()) : new RelativePoint((Component)usageView.getComponent(), new Point(4, 4));
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)step).show(point);
    }
}

